# -*- coding: utf-8 -*-
class Serveur < ActiveRecord::Base

  include Importations
  include Rapports

  attr_accessible :actif, :tfrequence, :tunit , :modele , :commande , :arguments
  attr_accessible :laststart, :lastduration, :laststatus, :current , :percent , :canceled
  attr_accessible :inprogress, :byetab , :tries, :maxseconds
  
  belongs_to :user
  
  belongs_to :composante
  
  has_many :actions, :dependent => :destroy
  
  SCRIPT="SCRIPT"
  URL="URL"
  
  MINUTE="minute"
  HOUR="hour"
  DAY="day"
  
  MODELES=[SCRIPT,URL]
  TUNITS=[MINUTE,HOUR,DAY]
  
  before_create do
    self.actif=false
    self.tfrequence=15
    self.tunit=MINUTE
    self.inprogress=false
    self.modele=SCRIPT
    self.byetab=false
    self.canceled=false
    self.user=User.current
  end
  
  
  after_find do
    if actions.empty? &&  commande!=nil && !commande.empty?
      action=Action.new(arguments: arguments)
      action.script=Script.find_by_id(commande)
      action.actif=true
      action.save
      actions<<action
      commande=""
      arguments=""
      save
    end
  end
  
  
  after_save do
    #logger.info("#{changed_attributes}")
    #logger.info("actif ? #{actif}")
    if (changed_attributes.key? "tfrequence") ||(changed_attributes.key? "actif") || (changed_attributes.key? "tunit") 
      Serveur.regenerateWhenever self                                
    end                            
    true
  end
  
  def currentStatus
    return {ui: "inprogress", title: "En cours d'éxécution"} if  inprogress?
    return {ui: "played", title: "Activé"} if actif?
    return {ui: "stoped", title: "Arrété"} if !actif?
    return {ui: "", title: ""}
  end
  
  def checkCanceled
    
      if canceled?
        logme("CANCELED")
        return true
      end
      
      return false
           
  end

  def getStatus
    return BatchData::RUNNING if inprogress
    return BatchData::STOPED
  end

  def json
    { :id=> composante.id, :description => "<b>#{composante.name}</b>", :status => getStatus, :message => current, :percent => percent }
  end
  
  def logme(message)
    puts "#{composante.fullname}:#{message}"
  end
  
  def execute (entity=nil)

    logme "Démarre le traitement"

    #if User.current != nil
    #  logme("User must not be set, so do nothing !!")
    #  return
    #end

    if locked?
      logme("Serveur en cours d'éxéxution, so do nothing #essais:#{tries}")
      if tries>3
        debloque 
      else
        update_attributes({:tries=>tries+1})
      end
      return
    end
    
    lock

    actions.each do |action|

        puts "\tAction: #{action}"
        
        if ! action.actif?
          puts " === Pas actif ==="
          next
        end

        byetab=action.script.byserver?

        # Par établissement / serveur
        if  byetab
          # Tous les uids pour le Serveur
          logger.info("byEtab:#{composante.composanteKey.id}")
          puts "byEtab:#{composante.composanteKey} (id:#{composante.composanteKey.id})"
          if entity==nil
            uids=Value.all(:select => "masteruid,valeur",:conditions => ["composante_id = ?", composante.composanteKey.id],order: "masteruid ASC")
          else
            uids=Value.all(:select => "masteruid,valeur",:conditions => ["composante_id = ? AND masteruid = ?", composante.composanteKey.id,entity],order: "masteruid ASC")
          end
          total=uids.count
          i=0
          #threads=[]
          #maxThread=Appconfig.EXPERT_MAX_THREAD.to_i()
          #Thread.abort_on_exception = true
          #threadUser=User.current
          puts "#{entity}/ UID count: #{total}"
          uids.each do |value|
           uids=value.valeur
           uids.split(",").each do |uid|
            i=i+1
            s=reload
            break if s.canceled
                
            begin
              e=Entities.get(value.masteruid)
              print "\tMaster:#{value.masteruid},uid:#{uid}"
              output=action.launch(self,uid,value.masteruid,maxseconds)
              update_attributes({:current => "<b>#{action}</b> #{output[:arguments]} <br>#{e}",:percent => ((i*100)/total).to_i() })
              Importations::parseIndividual(uid,composante,output[:resultat],self,value.masteruid)  
            rescue => msg 
              puts "/!\\ ### ERREUR /!\\ #{msg}"
            end
            
           end    
          end
    
          update_attributes({:current => "",:percent => 100 })
          
        else
          
          begin
            Importations::parseGlobal(composante,action.launch(self)[:resultat],self)
          rescue => msg 
              puts "Exception #{msg}"
              msg.backtrace.each { |errorline| puts errorline }
          end   
              
        end

    end

    unlock

  end
  
  # launch 'Serveur.find(#{self.id}).execute'
  def task
    path=Rails.root.join('script','serveur.sh')
    "
    every #{self.tfrequence}.#{tunit} do
      executer '#{path} #{self.id}'
    end 
    "
  end
  
  def scriptName
    #s=Script.find_by_id(commande)
    #if s != nil
    #  r=""
    #  if byetab
    #    r="<b>(Par serveur)</b>"
    #  end
    #  return "#{s.nom} #{arguments} #{r}"
    #end
    #"inconnu"
    "TODO"
  end
  
  #launch 'Serveur.find(#{id}).execute'
  
  def self.regenerateWhenever s
     logger.info("Regénération de la crontab")
    
    
     File.open("config/schedule.rb", "w") do |f|

       f.write "env 'PATH', ENV['PATH']\n"
       f.write "job_type :launch,  \"cd :path && rails runner -e :environment ':task' :output\"\n"
       f.write "job_type :executer,  \":task :output\"\n"


       Serveur.all.each do |serveur|
         
         serveur=s if s.id==serveur.id
         
         logger.info("#{serveur.composante.name} est #{serveur.actif}")
          next if ! serveur.actif?
          logger.info("#{serveur.composante.name} est #{serveur.task}")
          
          f.write serveur.task  
       end

       path=Rails.root.join('script','notifications.sh')
       f.write "
       every 1.minute do
         executer '#{path}'
       end"
       
     end
     
     system("whenever --update-crontab")
  
  end

  def locked?
    inprogress 
  end


  def canBeExecutable?
    return true if User.current.admin?
    return false if  User.current==nil
    return true if user.id==User.current.id
    if user.group?
      return true if  User.current.groups.exists?   Group.find(user.id)
    end
    false
  end
  
  def stop
    logme("CANCEL demandé par #{User.current.uid}")
    update_attributes({:canceled=>true,:inprogress=>false,:laststatus=> "Annuler par #{User.current.uid}"})
  end
  
  def debloque
    logme("Nombre max d'essais atteint: #{tries} ")
    update_attributes({:canceled=>true,:inprogress=>false,:laststatus=> "Nombre max d'essais atteint: #{tries}"})  
  end

  private

  def lock()
    logme "LOCK"
    update_attributes({:tries=>0,:canceled=>false,:inprogress=>true,:laststart=>Time.now.utc.localtime,:percent=>0,:current=>"Exécution du script"})
    User.current=user if User.current==nil # Exécution via crontab, le current user, prend celui du créateur du serveur

  end

  def unlock()
    User.current=nil if User.current.id != user.id  
    d=Time.now.utc.localtime.minus_with_coercion(laststart )

    status=laststatus
    if ! canceled?
      status="Terminé"
    end

    update_attributes({:tries=>0,:canceled=>false,:inprogress=>false,:lastduration=>d,:laststatus=>status})
    logme "UNLOCK"
  end

  

end
