# -*- coding: utf-8 -*-
class User < UserSimple


  has_many :permissions, :dependent => :destroy
  has_many :composantes, :through => :permissions

  has_many :objets
  has_one  :right

  belongs_to :user
  belongs_to :profile
  belongs_to :filtre

  has_and_belongs_to_many :groups
  has_and_belongs_to_many :menus

  attr_accessible :password
  has_secure_password

  validates_uniqueness_of :uid, :message => "Cet utilisateur éxiste déja"
  validates_format_of :uid, :with => /^([0-9,\-,.,@,_,A-Z]*)$/i,:message => " format invalide"


  @@currentSelectedFilter={}

  serialize :entities
  serialize :zephir_profil
  
  include Zephir

  before_validation do
    self.password=rand(36**16).to_s(36)  if !self.password_digest
  end

  before_create do
    self.categorie=USER
    self.actif=true

    gAll=Group.all

    # Tout le monde fait partie du groupe ALL
    if groups.index(gAll) == nil  && ! group?
      groups << gAll
    end


    # Si le groupe all existe in récupère sont profile
    if self.profile == nil
      if gAll  && !group?
        self.profile=gAll.profile.dup
      else
        self.profile=Profile.create
      end
    end

    self.guest=false
    self.user=User.current  if User.current != nil
    self.user=User.admin  if User.current == nil &&  User.admin
    self.entities={} if self.entities==nil
    self.zephir_profil=Zephir.defaultProfil()

    if gAll && !group?
      profile.filtres=Group.all.profile.filtres
      profile.vues_order=Group.all.profile.vues_order
      profile.vues_active=Group.all.profile.vues_active
      profile.save
    end

  end

  after_create do
    # Si c'est l'admin on met en place le profil particulier
    if uid==ADMIN
      self.avatar=AVATAR_ADMIN
      self.profile.set(Profile::ADMIN_MODE,true)
      self.profile.set(Profile::SET_GPS,true)
      self.profile.set(Profile::EDIT_MODE,true)
      self.profile.save

    end
  end

  before_save do
    self.zephir_uid=self.uid if  self.zephir_uid == nil
    self.uid="@#{self.uid}" if self.uid.first!="@" and self.categorie==GROUP # Force le premier caractère à @ pour un groupe
    true
  end

  after_find do
    self.entities={} if self.entities==nil
    @permissions_cache={}
    @entities=nil
    @rneFromCAS=nil
    if self.profile
      @visibleEntities=self.profile.get(Profile::VISIBLE_ENTITIES)
      @visibleFilters=self.profile.get(Profile::VISIBLE_FILTERS)
    end
  end

  def self.clearSelectedFilter()
    @@currentSelectedFilter.delete User.current.id
  end

  def self.hasSelectedFilter(filtre,hashSelectedFilters=nil)

    return false if !filtre.id

    return User.current.profile.filtres.include? filtre

    #============================================
    hashSelectedFilters=User.hashSelectedFilter if hashSelectedFilters==nil

    r=hashSelectedFilters[filtre.id]

    if r==nil
      r=User.current.profile.filtres.include? filtre
      hashSelectedFilters[filtre.id]=r
    #else
    #  logger.info("filtre id=#{filtre.id} selected from cache")
    end

    r
  end

  def self.hashSelectedFilter
    hashSelectedFilters=@@currentSelectedFilter[User.currentid]
    if hashSelectedFilters==nil
      hashSelectedFilters={}
      @@currentSelectedFilter[User.currentid]=hashSelectedFilters
      logger.info("Create selected filters cache")
    end
    hashSelectedFilters
  end

  def self.setSelectedFilter(filtre)
    if @@currentSelectedFilter[User.currentid]==nil
      @@currentSelectedFilter[User.currentid]={}
    end
    @@currentSelectedFilter[User.currentid][filtre.id]=true
  end

  def self.unsetSelectedFilter(filtre)
    return if @@currentSelectedFilter[User.currentid]==nil
    @@currentSelectedFilter[User.currentid][filtre.id]=false
  end



  #def initialize(*params)
  #  super(*params)
  #  self.categorie=USER
  #end



  # =======================================================
  # Gestion des dernieres entités pour l'utilsateur
  # ie : Ceux visible dans la barre de navigation (5 maximum)
  def showEntity(uid,action=nil)
    entities[uid]=action #if ! entities.include? uid
    entities.shift if  entities.size>20
    @current_entity=uid
    update_attributes({entities: entities})
    uid
  end
  
  def getEntityAction(uid)
    entities[uid]
  end
  
  def remove_entity(uid)
    entities.delete(uid)  
    update_attributes({entities: entities})
  end
  
  def current_entity
    @current_entity  
  end
  
  def current_entity=uid
    @current_entity=uid  
  end
  
  def unsetCurrentEntity
    @current_entity = "" 
  end
  
  def save_entity_action(entity,action)
    
  end
  # =========================================================

  def entitiesFilter=(arr)
    @entities=arr
    if arr != nil
        logger.info("User:entitiesFilter= set entities (count=#{arr.count}) for user #{uid}")
    else
        logger.info("User:entitiesFilter= unset entities for user #{uid}")    
    end
  end

  def rneFromCAS=(rnes)
    return if rnes==nil
    @entities=nil
    @rneFromCAS=rnes.split(",")
    profile.set(Profile::VISIBLE_ENTITIES,{})
    profile.save
    logger.info("#{rnes} from CAS set for #{uid}")
  end

  def rneFromCAS
    @rneFromCAS
  end

  def entitiesFilter

      return @entities if @entities!=nil

      return @rneFromCAS if @rneFromCAS!=nil

      arr=getZephirEntities()
      #arr=User.find(user_id).entitiesFilter if user_id!=nil   # On récupère les filtres du parent
      if filtre != nil
        logger.info("Le filtre '#{filtre.nom}' a été défini pour l'utilisateur #{uid}")
        if !arr.empty?
          logger.info("Entities Zephir: #{arr}")
          logger.info("Entities Filtre: #{filtre.evaluation.content}")
          arr=arr & filtre.evaluation.content
        else
          logger.info("Filtre User: #{filtre.nom}")
          arr=  filtre.evaluation.content
        end
      end

      if filtre==nil
        groups.each do |g|
          next if g.filtre==nil
          c=g.filtre.evaluation.content
          next if c.empty?
          arr=c if arr.empty?
          arr=arr | c if g.user_id==user_id  #
          arr=arr & c if g.user_id!=user_id && ! arr.empty?#
          arr= c      if g.user_id!=user_id &&  arr.empty?#
        end
      end

      # Aucun établissement, on utilise le filtre par défaut
      if arr.empty? && !Appconfig.GEN_GUEST_FILTER.empty?

        f=Filtre.find_by_id(Appconfig.GEN_GUEST_FILTER)
        if f !=nil
          logger.info("FILTRE PAR DEFAUT : #{f.nom}")
          arr= f.evaluation.content
        end

        if f == nil
          logger.info("Aucun filtre => Tous les étabs")
          Entities.getAll().each do |value|
            arr<<value.valeur
          end
        end
      end
      
      # Aucun établissement et pas de filtre par défaut
      # Ou filtre user == all
      # On récupère tous les étabs
      if (arr.empty? && Appconfig.GEN_GUEST_FILTER.empty? ) || (filtre!=nil && filtre.all?)
        arr.clear()
        Entities.getAll().each do |value|
            arr<<value.valeur
          end  
      end

      #logger.info("=====> entitiesFilter #{arr}")

      arr.collect(&:upcase)
  end
  
  def has_perspective?
    !Perspective.currents.empty?
  end
  
  def hasEntity?(uid)
    @entities=entitiesFilter if @entities == nil
    return false if @entities== nil
    @entities.include?  uid 
  end

  def visibleEntity?(uid)
    return @visibleEntities.has_key? uid  if @visibleEntities
    return true
  end

  def visibleEntitiesAndFilters(ve,vf)
   #return if ve==@visibleEntities
   @visibleEntities=ve
   @visibleFilters=vf.uniq
   User.current.profile.set(Profile::VISIBLE_ENTITIES,@visibleEntities)
   User.current.profile.set(Profile::VISIBLE_FILTERS,@visibleFilters)
   User.current.profile.save
  end

  def  visibleEntities
    @visibleEntities
  end

  def  visibleFilters
    @visibleFilters
  end


  # =========================================================
  # Récupère les utilisateurs créés par l'utilisateur connecté
  def self.allManaged
    a=[User.connected.id]
    User.connected.groups.each do |g|
      a<<g.id
    end
    if User.connected.admin?
      a<<Group.guest.id
    end
    # Guest = 0 (Pas les utilisateurs créés en invité)
    User.find_all_by_guest(0,:conditions => ["user_id in (?)  ",a])
  end

  # managed? return true si c'est l'utilisateur qui est le créateur du user
  # ou si c'est l'administrateur
  def managed?
    user_id==User.current.id || User.current.admin?
  end


  # Groupes disponibles pour l'utilisateur,
  # EN fonction de User.current
  def groupsAvailable

    arr=[]

    # Tous les groupes créer par User
    arr.concat(Group.find_all_by_user_id_and_categorie(User.current.id,GROUP))

    # Si Admin tous les groupes spéciaux
    if User.current.admin?
      arr.concat(Group.find_all_by_user_id_and_categorie(Group.admin.id,GROUP))
      arr.concat(Group.find_all_by_special(true))
    end

    # Groupes disponibles, il y a aussi les groupes non spéciaux de l'utilisateur courrant
    arr.concat(User.current.groups.select {|v| ! v.special?  } )

    arr.uniq!{|x| x.id}
  end

  # Un utilisateur est connecté si lastaction date d'au plus 3 minutes
  def self.connectedUsers
    User.all(conditions: ["lastaction > ?",Time.now-3.minutes])
  end



  def self.checkIfUserIsAlreadyConnected
    User.current=nil
    User.all(:conditions => [ "connected = true and lastaction <= ?",Time.now.utc-3.minutes]).each do |user|
      user.update_attribute(:connected,false)
      User.sendSystemMessage(
          "<table><tr><td style='width:50px'>#{user.avatarHTML}</td>
          <td>La session de #{user.uid} à été fermée</td></tr></table>",
          Message::WARNING)
    end
  end

  def self.sendSystemMessage(message,type)
      User.connectedUsers.each do |user|
        next if User.current!=nil && user.id==User.current.id
        puts "Send SYSTEM message for #{user.uid}"
        Message.system(user,message,type)
      end
  end


  def readable?
    User.current.memberOf? user
  end

  def match(critere)
    return true if uid.downcase.include?(critere)
    return true if !nom.empty? && nom.downcase.include?(critere)
    false
  end

  # Return true si  self==user  ou les groupes contiennent user
  def memberOf?(user)
    return false if !user
    return true if id==user.id
    groups.exists? user
  end



  def guest?
    memberOf? Group.guest
  end
  
  def gps?
    memberOf? Group.gps
  end
  


  def manager?
    (memberOf? Group.manager) || admin?
  end

  def admin?(bUseAdminMode=true)


    # Si uid c'est admin retourne , true
    return true if uid==User::ADMIN || uid == Group::ADMIN

    # Retourne faux si l'utilisateur ne fait pas partie du groupe admin
    return false if ! memberOf? Group.admin


    # Si en mode admin
    return profile.adminMode? if  bUseAdminMode

    return true

  end

  def cas?
    memberOf? Group.cas_user
  end



  # Permet de mettre le current user a Admin
  def self.A
    User.current=User.admin if User.current == nil
    User.current # Retourne le User.current
  end

  def self.U(uid)
    u=User.find_by_uid(uid)
    User.current=u
  end

  # Retourne l'utilisateur admin
  def self.admin
    u=User.find_by_uid(User::ADMIN)
    puts "Oups!!! User admin n'existe pas !!!"  if u==nil
    u
  end



  def get(key)
    profile.get key
  end

  def set(key,value)
    profile.set(key,value)
  end

  def has(key)
    profile.has(key)
  end

  def self.anonymous
    User.find_by_uid(ANONYMOUS)
  end
  
  def filtreModeET
    return profile.get(Profile::FILTRE_MODE)=="0" || profile.get(Profile::FILTRE_MODE)==false
  end

  def filtreModeOU
    return !filtreModeET
  end
  
  def currentComposante
    profile.get(Profile::COMPOSANTE)
  end
  
  def currentComposante=(c)
    profile.set(Profile::COMPOSANTE,c)
    profile.save
  end

  def notificationsFiltre
    profile.get(Profile::NOTIFICATIONS_FILTRE)
  end

  def notificationsFiltre=(filtre)
    return if filtre==nil
    profile.set(Profile::NOTIFICATIONS_FILTRE,filtre.id)
  end

  def self.createMethods
    Profile::OPTIONS.each do |option|
      m=option.downcase
      self.class.send(:define_method, m) do
        User.current.profile.get(option.upcase)
      end
    end
  end

  
  # ============================= GESTION DE ZEPHIR =========================
  def getZephirEntities()
    return  [] if zephir_profil==nil
    zephir_profil[:entities]
  end
  
  def getZephirGroupes()
    return  [] if zephir_profil==nil
    zephir_profil[:groupes]
  end
  
  # Ajout des groupes Zephir
  def addToGroupesFromzephir()
    zephir()
    groupes=getZephirGroupes()
    arr=[]
    groupes.each do |g|
         grp=Group.dynamique(g,self,"ZEPHIR")
         groups << grp if grp
    end
     #user.groups.concat(arr)
     #self.save
  end
  
  def zephir
    if Appconfig.ZEPHIR
      self.zephir_profil= Zephir.getUserRights(self,logger)
    else
      self.zephir_profil={groupes: [], entities: []}
    end
    #logger.info("========= Recup ZEPHIR ============")
    #logger.info("#{self.zephir_profil}")
    #logger.info("=======================================")
    
    self.save

  end
  # ==============================================================================

  def self.current
    Thread.current[:user]
  end
  def self.currentid
    Thread.current[:userid]
  end
  def self.current=(user)
    Thread.current[:user] = user
    Thread.current[:userid]=user.id if user!=nil
  end

  def self.connected
    Thread.current[:raw_user]
  end

  def self.connected=(user)
    Thread.current[:raw_user] = user
  end

end
