class UserSimple < ActiveRecord::Base

  attr_accessible :nom, :prenom, :uid ,  :mail, :portable,  :actif ,:connected
  attr_accessible :entities  , :special  , :lastaction  , :categorie, :avatar
  attr_accessible :dynamic, :share
  attr_accessible  :zephir_uid, :zephir_profil,:zephir_password

  AVATAR_ADMIN="/assets/markers/avatar/Elite-Captain-Blue-Shielded-icon.png"
  USER="user"
  GROUP="group"
  ADMIN="admin"
  ADMIN_DEFAULT_PASSWORD="$admin!"
  ANONYMOUS="anonymous"

  INVITE_PREFIX="--"

  set_table_name "users"

  def self.generateUidForInvite
    "#{INVITE_PREFIX}#{Time.now.to_i()}"
  end

  def for_json()
    { :id=>id, :cell => [ id,ApplicationController.helpers.format_user_categorie(categorie).pluralize,
                          ApplicationController.helpers.format_user(self) ]   }
  end

  def filtre
    User.find(self.id).filtre
  end

  def groups
    User.find(self.id).groups
  end

  def notificationsFiltre
    User.find(self.id).notificationsFiltre
  end

  def profile
    User.find(self.id).profile
  end

  def menus
    User.find(self.id).menus
  end

  def memberOf?(user)
    User.find(self.id).memberOf? user
  end

  # ========================================================
  # Gestion du cache pour les rapports
  # ceci évite de récupérer les permissions dans la base
  # a chaque entités
  def addPermissionsCache(composante,perm)
    @permissions_cache[composante.id]=perm
  end

  def getPermissionsCache(composante)
    @permissions_cache={} if @permissions_cache==nil
    @permissions_cache[composante.id]
  end

  def clearPermissionCache()
    @permissions_cache.clear
  end
  # =======================================================


  def manager?
    User.find(self.id).manager?
  end

  def admin?(bUseAdminMode=true)
    User.find(self.id).admin? bUseAdminMode
  end

  def all?
    uid==Group::ALL
  end

  def nobody?
    uid==Group::NOBODY
  end

  def connected?
    ! guest
  end

  def self.guest?
    User.current.guest
  end

  def group?
    uid.first=="@" or categorie==GROUP
  end

  def uidtronque
    return uid.gsub("-","").gsub(".","")
  end

  # Balisages HTML qui présente l'avatar
  def avatarHTML
    "<div style='width:48px; height:48px; background-size: contain; background-repeat: no-repeat; background-image: url(#{avatar_url});'>&nbsp;</div>"
  end


  def avatar_url

    return "/assets/markers/picto/protocol2_30.png"  if group? && dynamic?

    url=Appconfig.GEN_AVATAR_EXTERNE
    return url.gsub("{uid}",uid) if !url.empty?

    return AVATAR_ADMIN if avatar.empty? && uid==UserSimple::ADMIN
    return "/assets/markers/avatar/Casper-icon.png" if avatar.empty?

    avatar
  end


end
