# -*- coding: utf-8 -*-
class Value < ValueSimple

  belongs_to :composante

  #validates :uid, :presence => true
  #validates :valeur, :presence => true
  #validates :composante, :presence => true

  # ======================= PRE_FILTRE ============================

  #before_save do
    #TODO: A faire
    #if ! self.composante.isModifiable?
    #  return false
    #end
  #end

 # validates :masteruid, :uniqueness => {:scope => :composante_id}

  before_create do
    self.etat=OK
    self.nberreurs=0
    self.message="" if self.message==nil
    #self.valeur=""  if self.valeur==nil
    true
  end


  def noCheckNbErrors
     @noCheckNbErrors=true
  end


  before_save do

    #Sauvegarde du masteuruid, si ce n'est pas un master
    if self.masteruid==nil &&  !self.composante.inMaster?
      logger.info("CLEON:Value.before_save masteruid is nil")
      cuid=Master.serveurUidsForComposante (self.composante)
      u=self.uid
      logger.info("CLEON:Value.before_save try to get masteruid cuid=#{cuid}")
      v=Value.all(conditions: [ " composante_id = ? AND ( (valeur like '#{u}') or (valeur like '%,#{u},%') or (valeur like '#{u},%')   or (valeur like '%,#{u}') ) ", cuid.id])
      logger.info("CLEON:Value.before_save try to get masteruid count=#{v.count}")
      self.masteruid=v.first().uid.upcase if v.count>=1
    end

    # Sauvegarde du masteruid, si c'est un master (masteruid=uid)
    if self.masteruid==nil &&  self.composante.inMaster?
      self.uid.upcase!
      self.masteruid=self.uid
    end
    
    self.extra=Value.computeExtra(self.composante.categorie,self.valeur,self)
    self.extra[:last]=self.valeur_change[0] if self.valeur_change != nil

    #logger.info("EXTRA:#{self.extra} VALEUR=#{valeur} dirty=#{self.valeur_change}")

    # Gestion de l'état
    previous=self.etat
    @status=getStatut()
    self.etat=@status[:etat] if !defined?(@noCheckNbErrors)
    self.message=@status[:message]
    
    @newrecord=self.new_record? && !self.message.empty? && self.etat != OK
   
    if previous==nil
      self.extra[:last]=self.composante.default  
    end
    
    
    inc=0
    inc=1  if  (previous==OK || previous==nil) &&  (self.etat==KO)
    inc=-1 if  (previous==KO) &&  (self.etat==OK)
    
    # Met à jour le Nb d'erreur des parents , si c'est une feuille et si l'état a changé
    if self.composante.isLeaf?  && inc != 0 &&  !defined?(@noCheckNbErrors)
      #puts("")
      #puts(" => #{self.masteruid} , #{self.composante.fullname}")
      p=self.composante.parent
      while  p.id!=1  # On s'arrete dès que p est -1 (ie root)
        value=Value.find_by_uid_and_composante_id(uid,p.id)
        #puts("#{self.uid} , #{p.fullname} inc=#{inc}")
        if value==nil
          value=Value.new(uid: uid,masteruid: masteruid)
          value.composante=p
          value.valeur=""
          value.nberreurs=0
          value.save
        end
        value.update_attributes({:nberreurs => (value.nberreurs + inc)})

        p=p.parent
      end # Next parent

      self.nberreurs=inc
    end
    #
    
    true
  end
  
  # ======================= POST_FILTRE ============================

  after_destroy do
    # Evaluation des filtres associés à la composante
    self.composante.filtres.each do |filtre|
      b=filtre.evaluer(self.masteruid,true,true) # Force l'évaluation et la sauvegarde
    end
    true
  end

  after_save do

    # Evaluation des filtres associés à la composante
    self.composante.filtres.each do |filtre|
      #puts("Value#after_save filtre=|#{filtre.nom}| owner=#{filtre.owner.uid} master=#{self.masteruid}")
      b=filtre.evaluer(self.masteruid,true,true) # Force l'évaluation et la sauvegarde
      #puts(" evaluation = #{b}")
    end

    if @newrecord
      self.update_attributes( @status)
    end

    true
  end
  
  # =========================================================================

  # Récupère l'état d'une composante en fonction
  # des paramètres (catégrorie,...) de la composante associée
  def getStatut()
    e=OK
    m=""
    
    #logger.info("===== CALCUL DU STATUT ")
    
    # Récupère les valeurs actuelle de la composante
    # Ce calcul de statut peut intervenir dans le préfiltre after_save d'une composante
    e_error_cond=composante.error_condition
    e_error_msg=composante.error_message 
    e_change=composante.change_message

    # Tratiement par défaut pour un STATUT
    case composante.categorie
      when Composante::STATUT
        if Value.to_bool(valeur)  then e = OK else e =KO  end
    end
    
    # Une condition éxiste => On la traite
    if !e_error_cond.empty?
      # Si le test est vrai, alors la valeur est en erreur
      if RapportColumn::formater(uid,e_error_cond,true,composante,self)  
        #puts "#{composante.fullname} #{valeur} KO"
        e = KO 
      else 
        e = OK 
        m="" 
      end
    end
     
    # Si il y a un message de changement de valeur on le calcul
    if !e_change.empty? && source != "SentinelleV2"
      m=RapportColumn::formater(uid,e_change,false,composante,self)  
    end
    
    # Si en échec et un message d'erreur éxiste on reclacul le message d'erreur
    # Note: le message d'erreurest prioritaire sur le message de changement de valeur
    if !e_error_msg.empty? && e == KO  && source != "SentinelleV2"
      m=RapportColumn::formater(uid,e_error_msg,false,composante,self)  
      #puts "Message d'erreur #{m}"
    end
    
    # Pas de message de changement de valeur, par contre un message d'erreur
    # Et on passe de KO a OK, on change la valeur du message (Permet d'effacer le message en erreur)
    if e_change.empty? && !e_error_msg.empty? && (e == OK) && (self.etat == KO)
      m<<"OK" 
    end
    
    {etat: e, message: m}

  end
  
  def time
    updated_at.to_i
  end
  
  def reEvaluerStatut
    save
  end
  
  def attr(key)
    extra[key]
  end

  def val4History
    r=valeur
    case composante.categorie
      when Composante::CAPACITYDISK
        r="#{extra[:percent]}|#{extra[:used]}|#{extra[:available]}"
      when Composante::PING
        r=extra[:avg]
      when Composante::RATEbps
        r=extra[:rate]
    end
    r
  end
  
  # Calcul les valeurs 'extra' en fonction de la catégorie
  def self.computeExtra(categorie,valeur,value)
    
    case categorie
      # Valeur de la forme (%,capaciteMo,utiliséMo,restantMo,format)
      when Composante::CAPACITYDISK 
        a=valeur.gsub(" ","").scan(/\(([0-9]*)\|([0-9]*)\|([0-9]*)\|([0-9]*)\|'(.*)'\)/)
        if a != nil
          a=a[0]
          return  {} if a==nil
          return {percent: a[0].to_i,capacity: a[1].to_i, used: a[2].to_i, available: a[3].to_i, format: a[4]}    
        end

      # Valeur de la forme min | avg | max | lost | value1 ... valueN
      when Composante::PING
        a= valeur.split("|")
        return {min: -1, avg: -1, max: -1, lost: -1, samples: []   } if a.length < 4
        ret={min: a[0].to_f, avg: a[1].to_f , max: a[2].to_f, lost: a[3].to_i }
        ret[:samples]=a[4].split(" ").map { |x| x.to_f }
        return ret

      # SI c'est un statut l'extra prend la valeur OK ou ECHEC  
      when Composante::STATUT
        b=Value.to_bool(valeur) 
        return {statut: (b)?"OK":"ECHEC"} 
      
      # Uptime, calcul le temps approximatif du reboot
      when Composante::UPTIME
        now=Time.new - valeur.to_i()
        return { date: I18n.localize(now,:format =>:uptime) , time:now.to_i}
        
      #Rate
      when Composante::RATEbps
        a=valeur.gsub(" ","").split("|")
        return {} if a.count <2
        octets=a[0].to_i(); time=a[1].to_i()
        # Si la précédente valeur a le Nb d'octets on peut calculer le débit
        if value!=nil && value.extra != nil && value.extra.has_key?(:octets)
          if  time != value.attr(:time)
           # Si nb Octets est < a l'ancienne valeur
           # Cela signifie que le compteur a été dépassé
           #
           r=(octets - value.attr(:octets) ) / (time - value.attr(:time) )
           puts
           if r < 0
             r=( (octets+0xffffffff*8) - value.attr(:octets) ) / (time - value.attr(:time) )
             puts "rate < 0 : new rate #{r} "
           end

          else
           r=0
          end
        else
           r=-1
        end
        
        return { octets: octets ,time: time ,rate: r}
        
    end
    {}
      
  end

  # Example
  # ckey       : SCRIBE.id      // composante représentant l'Identifiant Zephir
  # ckeyvalue  : 15             // Identifiant Zephir
  # composante : SCRIBE.uptime  // Composante a changer de valeur
  # value      : valeur  
  # masteruid  : 9740001H       // 
  def self.setValue(params={})
    ckey=params[:ckey]
    ckeyvalue=params[:ckeyvalue]
    composante=params[:composante]
    value=params[:value]

    response=Response.new
    
    if composante==nil
      response.error "Value.setValue aucune composante"  
      return response
    end
    
    if value==nil
      response.error "Value.setValue aucune valeur"  
      return response  
    end

    

    #puts "SET_VALUE [#{params[:masteruid]} key/#{ckey}:#{ckeyvalue}] => #{composante}=#{value} "
    logger.debug(" SET_VALUE [key/#{ckey.fullname}:#{ckeyvalue}] => #{composante.fullname}=#{value} (CAS1 ? #{ckey.serveur} ?= #{composante.serveur} #{ckey.serveur.id ==  composante.serveur.id}) ")

    # On veut mettre à jour une valeur du même serveur que la ckey
    if ckey.serveur.id ==  composante.serveur.id
      logger.debug("Value self.setValue: CAS 1")
      uid=ckeyvalue
      valeur=value
    # sinon
    else
      
      arr=value.split(UID_SEP)
      # Est-ce que la valeur précise l'uid du serveur
      # ie valeur est de la forme:  <uid>=><valeur>
      # Si c'est le cas et la composantekey est Master.ckey 
      #    => on regarde si uid est dans la liste des Serveur_uid pour la
      if arr.size==2
        #puts "CAS2" #logger.debug("Value self.setValue: CAS 2")
        logger.debug("Value self.setValue: CAS 2")
        uid=arr[0]
        valeur=arr[1]
        
        # Oui composanteKey==Master.key
        if Master.composanteKey.id == ckey.id
           #logger.info("Value self.setValue: CAS 2bis (MasterKey==ckey)")
           #logger.info("#{ckeyvalue},#{} ")
           cuid=Master.serveurUidsForComposante(composante)
           v_uid=Value.getValue(ckeyvalue,cuid)
           # L'uid n'est pas dans la liste
           
           # Pas encode de valeur, on la créé
           if v_uid==nil
              Value.setComposanteValue(uid: ckeyvalue,composante: cuid,valeur: uid, source: params[:source])
           else
              # Existe déja => on l'ajoute
              if ! v_uid.include? uid
                #logger.debug("=====================================================")
                #logger.debug("Value self.setValue: CAS 2 existe déja ajoute #{uid}")
                v_uid.addValeur uid 
                v_uid.save               
                #logger.debug("VUID=#{v_uid}")  
                #logger.debug("=====================================================")
              end 
           end 
        end
      else
        logger.debug("Value self.setValue: CAS 3 composante:#{composante}")
        # Sinon on va rechercher dans Master.uids la valeur
        # Si plus d'une valeur trouvée on ne fait rien
        # ckey doit désigner la composante clef de Master
        cuid=Master.serveurUidsForComposante(composante)
        #puts "#{composante.fullname} cuid=#{cuid} masteur=#{params[:masteruid]}"
        vuid=Value.getValue(ckeyvalue,cuid)
        if vuid==nil
          
          if composante.inMaster?
            uid=params[:masteruid]
          else
            #c=Composante.getComposanteFromFullname(composante.fullname)
            #cuid=Master.serveurUidsForComposante(composante)
            #v_uid=Value.getValue(ckeyvalue,cuid)
            
            #logger.debug("Pas de valeur d'uid pour  '#{composante.serveur.name}'  [#{ckey.fullname}=#{ckeyvalue}]")
            response.error "Pas de valeur d'uid pour  '#{composante.serveur.name}'  [#{cuid.fullname}=#{ckeyvalue}]"
            #errors.add_to_base("Pas de valeur d'uid pour le serveur #{composante.serveur.name}  [Uid maitre=#{ckeyvalue}]")
            return response
          
          end
        end
        if vuid!=nil && vuid.multivalue?
           #logger.debug("uid pour '#{composante.serveur.name}' est multivalué  [#{ckey.fullname}=#{ckeyvalue}]")
           response.error "uid pour '#{composante.serveur.name}' est multivalué  [#{ckey.fullname}=#{ckeyvalue}]"
           #flash[:error]="uid pour le serveur #{composante.serveur.name} est multivalué  [Uid maitre=#{ckeyvalue}]"
          return response
        end
        uid=vuid.valeur if vuid!=nil
        valeur=value
      end
    end
    
    Value.setComposanteValue(uid: uid,composante: composante,valeur: valeur, source: params[:source],masteruid: params[:masteruid])
  end

  def source
    @source
  end

  def source=(s)
    @source=s
  end
  
  # Affecte la valeur d'une composante pou uid,composante,valeur
  def self.setComposanteValue(options={})
    response=Response.new
    
    uid=options[:uid]
    composante=options[:composante]
    valeur=options[:valeur]
    #logger.info "CLEON:Value.setComposanteValue(uid: #{uid},composante: #{composante},valeur: #{valeur})"
    

    #puts "COMPOSANTE_VALUE #{options[:masteruid]} uid: #{uid} #{composante}=#{valeur}"

    if composante==nil
      puts "Composante nulle"
      response.error "Composante nulle"
      return response
    end

    # TODO: A corriger
    #if ! composante.isModifiable?
    #  response.error "Composante non modifiable"
    #  return response
    #end

    #logger.info("#{options}")
    v=Value.find_by_uid_and_composante_id(uid,composante.id)
    # La valeur n'éxiste pas encore on la créé
    if v==nil
      #puts "Création d'une valeur"
      v=Value.new(uid: uid)
      v.masteruid=options[:masteruid] 
      v.composante_id=composante.id
      v.valeur=""
    end
    
    # Si c'est un statut on convertit la valeur en 'on' ou 'off'
    if composante.STATUT?
      options[:valeur]=(Value.to_bool(options[:valeur]))?"on":"off"  
    end
    
    # Si c'est une composanteKey on remplace les . et : par rien
    if composante.composanteKey?
      options[:valeur]=options[:valeur].gsub(".","_").gsub(":","_")
    end

    # Si la valeur est différente on la change
    if options[:valeur] !=  v.valeur || composante.logall?

      # Si on met à jour une composante qui référence les serveurs
      # On créé les valeurs associées
      if composante.refServeurUid?
        uidsBefore=v.toutesLesValeurs
        options[:valeur].gsub!(",","|") # Pour des raisons de compatibilité, des anciens scripts retourne comme séparateur une ,
      end

      v.source=options[:source]

      # Modification de la valeur
      v.valeur=options[:valeur]
      #puts "BEFORE:#{v}"
      if v.save
        #puts "AFTER:#{v}"
        response.success
      else
        response.error v.errors.full_messages.first
      end

      # C'est une composante du master qui ref des serveurs (Ex AMON_uids)
      # On créé les uids pour la composanteKey du serveur
      if composante.refServeurUid?
        logger.info("////\\\\REFUIDS")
        uidsAfter=v.toutesLesValeurs
        logger.info("////\\\\REFUIDS #{uidsAfter}")
        # Ex : serveurkey=AMON.zeph_id
        serveurkey=Master.serveurComposanteKeyFromMasterUid(composante) 
        #serveurkey=composante.composanteKey
        uidsAfter.each do |uid|
          # Est-ce que le serveur correspondant existe
          # uid,
          v_uid=Value.getValue(uid,serveurkey)#composante.composanteKey)
          #puts "////\\\\REFUIDS getValue(uid:#{uid},key:#{serveurkey})=>v_uid:[#{v_uid}]"
          logger.info("////\\\\REFUIDS v_uid=#{v_uid} uid=#{uid} ckey=#{composante.composanteKey.fullname}")
          if v_uid==nil
            logger.info("//////=>uid: #{uid},composante: #{serveurkey.id},valeur: #{uid} /////")
            Value.setComposanteValue(uid: uid,
                                    composante: serveurkey,
                                    valeur: uid,source: options[:source])
          end
        end

        # On traite tous les uids qui ne sont plus la
        notUsed=uidsBefore - uidsAfter
	      serveurtag=v.composante.tag.gsub(Master::UIDS_SUFFIX,"")
        #puts ("refServuerUid found #{composante.name} Destroy all values for uid:#{notUsed} and masteuruid:#{v.masteruid} : serveutag:#{serveurtag}" )
        #logger.info("refServuerUid found #{composante.name} Destroy all values for uid:#{notUsed} and masteuruid:#{v.masteruid} : serveutag:#{serveurtag}" )
        notUsed.each do |uid|
          # Suppression des valeurs dans la base, uniquement les valeurs ne correspondant pas au serveur en cours
          valuesToDestroy=Value.all(:conditions => ["uid = ? AND masteruid = ? ",uid,v.masteruid]).delete_if{ |o| ! o.composante.fullname.start_with?("#{serveurtag}") }
	        logger.info("#{valuesToDestroy.count} to destroy for uid #{uid} and  masteuruid:#{v.masteruid} and serveurtag=#{serveurtag} ")
	        valuesToDestroy.each { |object| object.destroy }
        end

      end

    else
      response.success
    end

    response
  end

  # Valeur possible pour le ptag
  # uid.serveur.tag
  # tag (composant en paramètre permet de déterminer le fullname)
  # tag peut être de la forme
  #  tag              : Récupère l'attribut valeur
  #  tag:nberreurs    : le nombre d'érreurs
  #  tag:<extra attr> : Attribut sauver dans extra
  def self.getValueFromFullname(entity_uid,ptag,composante=nil,currentValue=nil,master=nil)
    uid=entity_uid
    fullname=ptag
    attribut=""
    #logger.debug(" self.getValueFromFullname(entity_uid=#{entity_uid} ptag=#{ptag} composante=#{composante})")
    #puts " Value.getValueFromFullname(entity_uid=#{entity_uid} ptag=#{ptag} composante=#{composante})"

    b=ptag.split(":")
    if b.size>1
       ptag = b[0]
       attribut= b[1]
       #logger.debug("attribut #{attribut} trouvé ptag=#{ptag}" )
    end

    a=ptag.split(".")

    #Fullname de la forme : uid.serveur.tag
    if a.size == 3
      uid=a[0]
      fullname="#{a[1]}.#{a[2]}"
    end

    # Pas de composante passé et ptag ne conteint pas de . (c'est peu être un serveur)
    if a.size==1  &&  composante==nil
      fullname="#{ptag}.#{ptag}"
    end
    
    # Pas de tag passé 
    if a.size==0  &&  composante!=nil
      fullname=composante.fullname
      #logger.info("Pas de tag fullname=#{fullname}")
    end

    #Fullname de la forme: tag => On utilise la composante en paramètre pour déterminer le fullname
    if a.size == 1 &&  composante!=nil && composante.getComposante(ptag) != nil
      fullname=composante.getComposante(ptag).fullname
    end
    
    #logger.info("uid=#{uid} ptag=#{ptag}")

    # On récupère la composante
    c=Composante.getComposanteFromFullname(fullname)
    #puts "Composante.getComposanteFromFullname('#{fullname}')=>#{c.fullname}"
    #logger.info("Composante.getComposanteFromFullname('#{fullname}')=>#{c}")

    # Pas de composante trouvée
    if c==nil
      return  NOTFOUND
    end

    # Si la composante n'est pas le master
    # Note : Si a ==0 , le ptag passé en paramètre est de la forme :attr (ne contient pas de .),
    #        le contexte correspond donc a une valeur dont l'uid est passé en paramètre
    if ! c.inMaster? && a.size != 0 
      cuid=Master.serveurUidsForComposante(c)
      vuid=Value.getValue(entity_uid,cuid)
      uid=vuid.toutesLesValeurs().first if vuid!=nil && vuid.is_a?(Value)
      #puts "#{cuid.fullname} #{entity_uid} #{uid}"
    end

    # Si la composante est dans le master on utilise le masteruid s'il existe
    if c.inMaster? && a.size != 0
      uid=master if master != nil 
    end


    # On récupère la valeur
    # SI la valeur courrant == à la valeur recherché on utilise la valeur courante (Cas du filtre before_save)
    if currentValue != nil && c.id ==  currentValue.composante.id && currentValue.uid==uid
      v=  currentValue
    else
      v=Value.getValue(uid,c)  
    end
    
    #puts "///\\\ ====uid=#{uid} fullname=#{fullname} = #{v} attr=#{attribut}"
    #logger.info("///\\\ ====uid=#{uid} fullname=#{fullname} = #{v} attr=#{attribut} change=#{v.valeur_change}")

    if v!=nil && !attribut.empty?
      #logger.info("=> EXTRA#{v.extra}")
      return v[attribut]  if v[attribut]!=nil
      #return v.valeur_change[1] if attribut=="last" && v.valeur_change!=nil
      return composante.name if attribut=="name"
      return composante.tag if attribut=="tag"
      v=v.attr(attribut.to_sym) 
    end

    if v == nil && c != nil
      return c.default
    end

    v
  end

  def self.getValue(uid,composante)
    #puts "getValue #{uid} #{composante.fullname}"

    if composante==nil
      logger.debug("Value.getValue uid=#{uid} Composante is nil")
      return nil
    end
    
    return FORBIDDEN if ! composante.isReadable?
    Value.find_by_uid_and_composante_id(uid,composante.id)
  end
  
  def self.getValeur(uid,composante)
    return NOTFOUND if composante==nil
    v=Value.find_by_uid_and_composante_id(uid,composante.id)
    return composante.default if v==nil
    v.valeur
  end
  
  def addValeur(val)
    v=self.valeur
    if self.valeur!="" and self.valeur!=nil
      v=self.valeur+MULTIVALUE_SEP
    end
    v=v+val
    update_attribute(:valeur , v )
    #self.valeur="kkkk"
  end
  
  def toutesLesValeurs
    return [] if valeur ==nil
    valeur.split(MULTIVALUE_SEP)   
  end
  
  def include?(v)
    return toutesLesValeurs.include? v if multivalue?
    valeur==v 
  end

  def multivalue?
    valeur.include? MULTIVALUE_SEP
  end
  
  def to_s
    "(ID:#{id}) #{composante.fullname}[#{uid}]=#{valeur}"
  end


  def format(fullinfo=false)
    composante.format(self,fullinfo)
  end

  
  def self.remplacer(expression,entity_uid=nil,composante=nil)
        
        r=expression
        a=expression.scan(/{([0-9,A-Z,a-z,.,-,_]*)}/)
        a.each do |c|
            #valeur=Value.getValue(entity_uid,Composante.getComposanteFromFullname(c[0]))
            tag="#{c.first}"
            next if tag.empty?
            #logger.info("===> Value.remplacer #{c.first} uid=#{entity_uid}")
            value=Value.getValueFromFullname(entity_uid,tag,composante)
            if value==nil || value.is_a?(String)
              r=r.gsub("{"+tag+"}","n/a")
            else
              r=r.gsub("{"+tag+"}",value.valeur)
            end
            #logger.info(r)
             
        end
        r
  end
  
  def self.to_bool(string)
    return true if string== true || string =~ (/(true|on|t|yes|y|1|ok)$/i)
    return false if string== false || string.nil? || string =~ (/(false|off|f|no|n|0|echec)$/i)
  end


end


class ValueNotFound < Value



end

class ValueForbidden < Value



end
