class Vue  < Objet

  include Rapports

  has_and_belongs_to_many :filtres  ,  :order => "position ASC"
  before_destroy do
    filtres.each do |f|
      f.destroy
    end 
    filtres.clear
  end


  AFTER="+"
  BEFORE="-"

  def initialize(*params)
    super(*params)
    self.categorie=VUE
    self.nom="Nouvelle vue"
    self.description="Description de la vue"
    self.data=[]
  end
  
  # === CURRENTS
  def self.currents
    order=User.current.profile.vues_order
    if order!=nil && !order.empty?
      orders="case id ";i=0
      order.each do |id|
        orders<<"  when #{id} then #{i} "
        i=i.next()
      end
      orders<<"end"
    else
      orders="id"
    end

    vues=Objet.filtrer(Vue.all(:conditions => ["categorie = ?",VUE],:order=> orders))
    vues.delete_if {|o| o.filtres.empty? }
  end

  def default
    filtre=Filtre.new
    filtre.categorie=Objet::FILTRE_VUE
    filtre.nom=filtre.defaultName
    filtre.groupe=id
    self.position=0
    self.filtres<<filtre
  end

  # Pour chaque filtre on change le groupe
  before_save do
    self.filtres.each do |filtre|
      filtre.categorie=FILTRE_VUE
      filtre.groupe=self.id
      filtre.save
    end
  end

  # 
  def actif?
    vues=User.current.profile.vues_active
    #logger.info("#{vues}")
    return vues.include?(id)  if vues!=nil
    #profileFilters=User.current.profile.filtres
    #filtres.each do |f|
    #  if profileFilters.exists?  f
    #    return true
    #  end
    #end
    false
  end

  def mesFiltres
    Filtre.all(:conditions => ["categorie = ?",FILTRE_VUE ]).select { |f| f.data.groupe==id}
  end

  def getFiltres
    arr=[]
    filtres.each do |f|
      if f.groupe == nil
        f.groupe=id
        f.save
      end
      arr << f
    end
    arr
  end

  def self.filtres

    order=User.current.profile.vues_order

    # S'il n'y a pas d'order on créé une liste vide
    if order==nil || order==0
      order=[]
    end

    if !order.empty?
      orders="case id ";i=0
      order.each do |id|
        orders<<"  when #{id} then #{i} "
        i=i.next()
      end
      orders<<"end"
    else
       orders="id"
    end

    vues=Objet.filtrer(Vue.all(:conditions => ["categorie = ?",VUE],:order=> orders))
    ret=[]
    order=[]
    vues.each do |vue|
      
      next if vue.filtres.empty?
      
      order<<vue.id

      f=Filtre.new(:groupe=>vue.id,:nom=>BEFORE)    # Pour limiter la borne SUP
      ret<< f

      ret= ret +  vue.getFiltres

      f=Filtre.new(:groupe=>vue.id,:nom=>AFTER)      # Pour limiter la borne INF
      ret<< f

    end

    if User.current.profile.vues_order != order
      User.current.profile.update_attribute(:vues_order,order)
    end


    ret
  end





end