# -*- coding: utf-8 -*-
# encoding: utf-8

# Load the rails application
require File.expand_path('../application', __FILE__)

# Initialize the rails application
Alizes::Application.initialize!

Encoding.default_external = Encoding::UTF_8
Encoding.default_internal = Encoding::UTF_8


require 'rubycas-client'

if ActiveRecord::Base.connection.tables.include?("appconfigs")

  if ! Appconfig.createMethods
    puts "La création de la configuration de base a échouée !!!"
    puts "Il manque sans doute l'initialisation de Sentinelle !!!"
  else
    #Appconfig.init()
    User.createMethods

    if ! Dir.exists?("data/scripts")
      Dir.mkdir("data/scripts")
    end

    CASClient::Frameworks::Rails::Filter.configure(:cas_base_url => Appconfig.CAS_URL)

    Alizes::Application.configure do
      config.action_mailer.delivery_method = :smtp
      config.action_mailer.smtp_settings = {
          :address        => Appconfig.MAIL_SMTP_HOST,
          :port           => Appconfig.MAIL_SMTP_PORT.to_i,
          :tls            => Appconfig.MAIL_SMTP_TLS,
          :enable_starttls_auto => Appconfig.MAIL_SMTP_TLS
      }

      user=Appconfig.MAIL_SMTP_USER
      pwd=Appconfig.MAIL_SMTP_PWD
      if !user.empty? and !pwd.empty?
        config.action_mailer.smtp_settings[:user_name]=user
        config.action_mailer.smtp_settings[:password]=pwd
        config.action_mailer.smtp_settings[:authentication]=Appconfig.MAIL_SMTP_AUTH
      end

      config.action_mailer.perform_deliveries = true
      config.action_mailer.raise_delivery_errors = true
    end

  end

  #Engine::Kernel.buildServeurs
end



#cas_logger = CASClient::Logger.new("log/cas.log")
#cas_logger.level = Logger::DEBUG


I18n.default_locale = :fr

