Alizes::Application.routes.draw do


  match "session/connect" =>  "session#connect"  , :via => :post
  match "session/login" =>  "session#login"
  match "session/changeuser" =>  "session#changeuser"
  match "session/logout" =>  "session#logout" , :via => :get
  match "session/remove_entity" =>  "session#remove_entity"

  match "gestion" =>  "administration#index"

  match "batches/:id/rapport" =>  "batches#rapport"
  match "batches" =>  "batches#index"
  match "batches/show" =>  "batches#show"


  match "batches/refresh" =>  "batches#refresh"
  match "batches/stop" =>  "batches#stop"
  match "batches/start" =>  "batches#start"
  match "batches/clear" =>  "batches#clear"

  match "administration/conf" => "administration#conf"  , :format => :js
  match "administration/configuration" => "administration#configuration"   , :via => :get
  match "administration/configuration" => "administration#conf_save"  , :via => :post , :as => "configuration"
  match "administration/scripts" => "administration#scripts_accueil"
  match "administration/scripts_list" => "administration#scripts_list"
  match "administration/add" => "administration#add"
  match "administration/:id/edit" => "administration#edit"
  match "administration/:id/save" => "administration#save" ,:via => :put
  match "administration/:id/launch" => "administration#launch", :format => :json,:via => :post

  match "users/avatars" => "users#avatars"
  match "users/profile" => "users#profile_get" , :via => :get, :format => :js
  match "users/profile" => "users#profile_set" , :via => :put, :format => :js
  match "users/list" => "users#list", :format => :json
  match "users/manage" => "users#manage"
  match "users/groups" => "users#groups" , :via => :post
  match "users/groups" => "users#add" , :via => :get
  match "users/users" => "users#users" , :via => :post
  match "users/:id/groups" => "users#groupsforuser" , :format => :json  
  match "users/:id/groupsavailable" => "users#groupsavailable" , :format => :json
  match "users/:id/users" => "users#usersforgroup" , :format => :json
  match "users/:id/userssavailable" => "users#usersavailable" , :format => :json
  match "users/edit" => "users#edit" , :format => :js
  match "users/:id" =>  "users#save" , :via => :put , :format => :js, :as => "user"  
  match "users/search" => "users#search"
  match "users/setoption" => "users#setoption", :via => :post
  match "users/getoption" => "users#getoption", :via => :get

  match "main" =>  "main#accueil"  , :nolayout=> true
  match "main/sidebar" =>  "main#sidebar"
  match "main/alive"   =>  "main#alive" , :format => :json

  match "main/:id/rights" => "main#rights" , :format => :json
  match "main/:id/rights" => "main#rights_edit"

  match "main/handler" => "main#set_handler" , :format => :json, :via => :post
  match "main/handler" => "main#get_handler" , :format => :text, :via => :get

  match "main/saveright" => "main#right_save" , :format => :js
  match "main/:id/addright" => "main#right_add"
  match "main/deleterights" => "main#rights_delete"  , :via => :delete
  match "main/objet_share" => "main#objet_share"
  match "main/description" => "main#description" , :format => :json
  match "main/:id/objet" => "main#objet", :via => :post # Devrait remplacer les actions précédentes

  match "main/icone/:id" =>  "main#icone"
  match "main/markers/folders" => "main#markers_folders", :format => :json
  match "main/markers/gallery" => "main#markers_gallery"
   
  match "main/filter_activate" =>  "main#filter_activate"
  match "main/nofilter" =>  "main#nofilter"
  match "main/filter_edit" =>  "main#filter_edit"  , :format => :js
  match "main/filter_add" =>  "main#filter_add"  , :format => :js
  match "main/filter_save" =>  "main#filter_save"  , :format => :js
  match "main/filter_test" =>  "main#filter_test"  , :format => :html

  match "main/filter_ui" =>  "main#filter_ui"  , :format => :json
  match "main/filter_eval" =>  "main#filter_eval"  , :format => :html
  match "main/filters_delete" =>  "main#filters_delete"

  match "main/filters_ui" =>  "main#filters_ui" , :format => :json
  
  

  match "main/vue_delete" =>  "main#vue_delete", :via => :delete
  match "main/vue_add" =>  "main#vue_add"
  match "main/vue_add_filter" =>  "main#vue_add_filter" , :via => :post
  match "main/vue_change_name" =>  "main#vue_change_name" , :via => :post
  match "main/vue_ui" =>  "main#vue_ui"  , :format => :json
  match "main/entities" =>  "main#entities" , :format => :json
  match "main/filtres" =>  "main#filtres" , :format => :json
  match "main/filtresfast" =>  "main#filtresfast"  , :format => :html
  match "main/show_mesrapports" =>  "main#show_mesrapports"  , :format => :html
  match "main/show_perspectives_contextuelles" =>  "main#show_perspectives_contextuelles"  , :format => :html
  match "main/vues" =>  "main#vues" , :format => :json
  match "main/notifications" =>  "main#notifications" , :format => :json
  match "main/vues_definition" =>  "main#vues_definition" , :format => :json
  match "main/vues_status"  =>  "main#vues_status" , :format => :json
  match "main/vue_reorderfilters" =>  "main#vue_reorderfilters"
  match "main/vue_reorder" =>  "main#vue_reorder"
  match "main/vue_toggle" =>  "main#vue_toggle" , :format => :json

  match "version" => "main#version"
  match "main/scripts" => "main#scripts"  , :format => :json
  match "main/perspectives" => "main#perspectives"  , :format => :json
  match "main/composantes" => "main#composantes"

  match "entity/sideheader" =>  "entity#sideheader"  , :nolayout=> true
  match "entity/composantes" =>  "entity#composantes"  , :nolayout=> true
  match "entity/composantes_side" =>  "entity#composantes_side"  , :nolayout=> true
  match "entity/journal" =>  "entity#journal"  , :nolayout=> true
  match "entity/historiques" =>  "entity#historiques"  , :nolayout=> true
  
  match "entity/:id" =>  "entity#index"
  match "entity/:id/composantes" =>  "entity#composantes"
  
  
  match "entity/:id/historiques" =>  "entity#historiques"
  match "entity/:id/journal" =>  "entity#journal"
  match "entity/:id/node" =>  "entity#node"
  match "entity/:id/show" =>  "entity#show"
  match "entity/:id/valeurs" =>  "entity#valeurs"   , :format => :json
  match "entity/:id/samples" =>  "entity#samples"   , :format => :json
  match "entity/:id/evaluer" =>  "entity#evaluer"   , :format => :json
  match "entity/:id/valeursData" =>  "entity#valeursData"   , :format => :json
  match "entity/:id/logs" =>  "entity#logs"   , :format => :json
  match "entity/:id/update" =>  "entity#update"
  match "entity/:id/errors" => "entity#errors" , :format => :json
  match "entity/:id/gps" =>  "entity#gps"  , :via => :post

  match "details/:entity/:id" =>  "perspective#details"
  match "entity/:id/perspective" =>  "perspective#showPerspective"
  match "entity/:id/default" =>  "perspective#default"

  match "perspective/browser" => "perspective#browser"
  match "perspective/add" => "perspective#add"
  match "perspective/save" =>  "perspective#save" , :via => :post
  match "perspective/evaluer" =>  "perspective#evaluer" , :via => :post
  match "perspective/:id/compute/:entity" => "perspective#compute"
  match "perspective/:id/source" => "perspective#source"
  match "perspective/:id" => "perspective#get"
  match "perspective/:pid/export" =>  "perspective#export" 
  match "perspective/import" =>  "perspective#import" 
  
  match "rapports" =>  "rapports#index"  , :nolayout=> true
  
  match "rapports/rendermesrapports" =>  "rapports#rendermesrapports"
  match "rapports/sidebar" =>  "rapports#sidebar"  , :nolayout=> true
  match "rapports/:id/edit" =>  "rapports#edit"    , :format => :html
  match "rapports/:id/copy" =>  "rapports#copy"
  match "rapports/:id/delete" =>  "rapports#delete" , :via => :delete
  match "rapports/:id/columns" =>  "rapports#columns"
  match "rapports/:id/columns_order" =>  "rapports#columns_order"
  match "rapports/:id/outils" =>  "rapports#outils"
  match "rapports/:id/export" =>  "rapports#export"
  
  match "rapports/addcolumn" =>  "rapports#addcolumn" , :via => :post  , :format => :js
  match "rapports/maj" =>  "rapports#maj" , :via => :post 
  match "rapports/index" =>  "rapports#index"
  match "rapports/create" =>  "rapports#create", :via => :get
  match "rapports/new" =>  "rapports#new", :via => :post
  match "rapports/manage" =>  "rapports#manage"
  match "rapports/:id/data" =>  "rapports#data" , :format => :json
  match "rapports/:id" =>  "rapports#directlink" , :format => :html
  match "rapports/:id/show" =>  "rapports#show"


  match "notifications" => "notifications#index" , :format => :html
  match "notifications/sidebar" => "notifications#sidebar" , :format => :html
  match "notifications/add"  => "notifications#add"
  match "notifications/icone"  => "notifications#icone"
  match "notifications/list"  => "notifications#list"
  match "notifications/:id/save"  => "notifications#save"
  match "notifications/:id/toggle"  => "notifications#toggle"
  match "notifications/details/:nuid"  => "notifications#details"
  match "notifications/parameters"  => "notifications#parameters"  , :via => :put

  match "importation/index" =>  "importation#index"
  match "importation/uploadfile" =>  "importation#uploadfile"  , :via => :post  , :format => :js
  match "importation/import" =>  "importation#import"  , :via => :post  , :format => :js

  #id ici est la composante_id dans laquelle on ajoute la permission
  match "permissions/new/:id" =>  "permissions#new" , :via => :post 
  match "permissions/inherit/:id" =>  "permissions#inherit" , :via => :post
  
  match "permissions/delete" =>  "permissions#delete" , :via => :delete , :format => :js
  match "permissions/reorder" =>  "permissions#reorder" , :via => :put , :format => :js

  match "composantes/:id/historiques" => "composantes#historiques", :via => :delete
  match "composantes/:id/journal" => "composantes#journal", :via => :delete

  match "composantes/serveur/infos" =>  "composantes#serveurs_infos"
  match "composantes/serveur/:id/infos" =>  "composantes#serveur_infos"
  match "composantes/serveur/:id/stop" =>  "composantes#serveur_stop"
  match "composantes/serveur/:id/start" =>  "composantes#serveur_start"
  match "composantes/serveur/:id/actions" => "composantes#serveurs_actions" , :format => :json
  
  match "composantes/serveur/:id" =>  "composantes#serveur" , :via => :put , :format => :js, :as => "serveur"
  match "composantes/import" =>  "composantes#import" ,:format => :js
  match "composantes/uploadfile" =>  "composantes#uploadfile" , :via => :post  , :format => :js
  match "composantes/:id/permissions" =>  "composantes#permissions"
  match "composantes/setpermission" =>  "composantes#setpermission" , :via => :post , :format => :js, :as => "permission"
  match "composantes/move" =>  "composantes#move" , :via => :post , :format => :json
  match "composantes/:id/infos" =>  "composantes#infos" , :via => :get

  match "composantes/:id/inherited" =>  "composantes#setInheritedPermission" , :via => :post , :format => :js
  match "composantes/permission/:id" =>  "composantes#permission"
  match "composantes/delete" =>  "composantes#delete" , :via => :delete , :format => :js
  match "composantes/search" =>  "composantes#search" , :format => :json
  match "composantes/ismodifiable" =>  "composantes#ismodifiable"  , :format => :json





  match "composantes/add" =>  "composantes#add"  , :via => :post  , :format => :js
  match "composantes/node" =>  "composantes#node"
  match "composantes/edit" =>  "composantes#edit"
  resources :composantes

  

  # The priority is based upon order of creation:
  # first created -> highest priority.

  # Sample of regular route:
  #   match 'products/:id' => 'catalog#view'
  # Keep in mind you can assign values other than :controller and :action

  # Sample of named route:
  #   match 'products/:id/purchase' => 'catalog#purchase', :as => :purchase
  # This route can be invoked with purchase_url(:id => product.id)

  # Sample resource route (maps HTTP verbs to controller actions automatically):
  #   resources :products

  # Sample resource route with options:
  #   resources :products do
  #     member do
  #       get 'short'
  #       post 'toggle'
  #     end
  #
  #     collection do
  #       get 'sold'
  #     end
  #   end

  # Sample resource route with sub-resources:
  #   resources :products do
  #     resources :comments, :sales
  #     resource :seller
  #   end

  # Sample resource route with more complex sub-resources
  #   resources :products do
  #     resources :comments
  #     resources :sales do
  #       get 'recent', :on => :collection
  #     end
  #   end

  # Sample resource route within a namespace:
  #   namespace :admin do
  #     # Directs /admin/products/* to Admin::ProductsController
  #     # (app/controllers/admin/products_controller.rb)
  #     resources :products
  #   end

  # You can have the root of your site routed with "root"
  # just remember to delete public/index.html.
   root :to => 'main#accueil'

  # See how all your routes lay out with "rake routes"

  # This is a legacy wild controller route that's not recommended for RESTful applications.
  # Note: This route will make all actions in every controller accessible via GET requests.
  # match ':controller(/:action(/:id))(.:format)'
end
