#! /usr/bin/env python
# Recupere les infos de bases de zephir
#  + les zephir ID des != module


import os
import sys
import xmlrpclib

sys.path.append("%s/../zephir"% sys.path[0])
from tools import *

sUrlZephir='https://{APPCONFIG.ZEPHIR.login}:{APPCONFIG.ZEPHIR.password}@{APPCONFIG.ZEPHIR.host}:7080'

s_sVARIABLE_RNE='rne'
s_sVARIABLE_SERVEURMODULE='module_actuel'
s_sVARIABLE_MODULEID='id'
s_sVARIABLE_SERVEURID='id'



oProxy=xmlrpclib.ServerProxy(sUrlZephir)

# Construction de la correspondance ModuleId/Nom
oListModules=oProxy.modules.get_module()[1]
oListeModuleName={}
sys.stdout.write('#Liste des modules : ')
for oModule in oListModules:
    sServeurName=getServeurName(oModule['libelle'])
    oListeModuleName[oModule[s_sVARIABLE_MODULEID]]=sServeurName
    sys.stdout.write('#'+str(oModule[s_sVARIABLE_MODULEID])+'='+sServeurName+" ")
sys.stdout.write('\n\n')


# Recupere  les type d'etabs
oListTypes=oProxy.etabs.get_types()[1][0]

sys.stdout.write('#Recuperation des infos :\n ')
etabs=convert(oProxy.etabs.get_etab()[1])
serveurs_etabs=convert(oProxy.sentinelle.get_serveur_etab()[1])
liste=[]
for etab in etabs:
    ligne=etab[s_sVARIABLE_RNE].upper()+"|"   # Recuperation du code rne
    #if etab[s_sVARIABLE_RNE] != '0210000A':
    #	continue    

    # Recuperation des infos
    for cle,valeur in etab.items():
        #print cle+"%%"+str(valeur)
        if (cle=='rne'):
        	cle='uaj'
        	valeur=valeur.upper()
        if (cle=='type'):
            valeur=getEtabType(oListTypes[str(valeur)]) # Convertion du Type, en LYC,LP ou CLG
        ligne+=cle+"%%"+str(valeur).replace("\n","")+"|"

    # Recuperation des serveurs pour Rne
    serveursid={}
    #print ""
    oListServeurs=serveurs_etabs.get(etab[s_sVARIABLE_RNE], [])
    for serveur in oListServeurs:
        iIdDuModule=serveur[1]
        iIdDuServeur=serveur[0]
        sServeur=oListeModuleName[iIdDuModule]
        #print sServeur+" "+str(iIdDuServeur)
	if sServeur != "":
            if (not serveursid.has_key(sServeur)):
		#print "Nvle ref " + sServeur
		serveursid[sServeur]=[]
	    serveursid[sServeur].append(str(iIdDuServeur))
	#print serveursid

    for srv in ["HORUS_uids","AMON_uids","SCRIBE_uids"]:
        if not serveursid.has_key(srv):
            serveursid[srv]=[]; serveursid[srv].append("")


    # Liste des serveurs
    for serveur in serveursid:
	ligne+=(serveur+"%%"+",".join(serveursid[serveur])+"|")

    # Ajout des etabs dans la liste            
    liste.append( ligne)
    print(ligne)


