#!/usr/bin/python
# -*- coding: UTF-8 -*-

import xmlrpclib
import datetime
import traceback
from os import remove
from os.path import exists
import sys
import os
from glob import glob

sUrlZephir='https://{APPCONFIG.ZEPHIR.login}:{APPCONFIG.ZEPHIR.password}@{APPCONFIG.ZEPHIR.host}:7080'

tempdir='/tmp/zephir'
if not os.path.exists(tempdir):
    os.makedirs(tempdir)

# ===================================================
# Ajout cleon
# Charge les prefixes locaux (Agents locaux)
oLocalPrefixes={}
sys.path.append("%s/../zephir"% sys.path[0])
from configlocal import *

oDicPrefixes={}
for sPrefixe in oLocalPrefixes:
    oDicPrefixes[sPrefixe]=True
# ====================================================

#for path in glob('%s/*.conf'%tempdir):
#    remove(path)

oProxy=xmlrpclib.ServerProxy(sUrlZephir)

fullDict = eval(oProxy.sentinelle.get_all_for_sentinelle()[1])
for i in fullDict.keys():
    currentFile='%s/%s-current.conf' % (tempdir,i)
    lastFile='%s/%s-last.conf' % (tempdir,i)
    deltafile='%s/%s.conf' % (tempdir,i)
    outFic = open(currentFile, 'w')
    outFic.write('zeph_id,%s\n' % fullDict[i]['config_zephir']['id'])
    outFic.write("# RECUPERATION DE LA CONFIGURATION\n")
    outFic.write("# ========================================\n")
    for k, v in fullDict[i]['conf'].items():
        outFic.write('conf_%s;%s\n' % (k, v))
    outFic.write("# ========================================\n")
    outFic.write("# RECUPERATION DE ETAT ZEPHIR\n")
    outFic.write("# ========================================\n")
    for k, v in fullDict[i]['etats'].items():
        outFic.write('%s;%s\n' % (k, v))
    outFic.write("# ========================================\n")
    outFic.write("# ========================================\n")
    outFic.write("# RECUPERATION DES STATUS\n")
    for k, v in fullDict[i]['status'].items():
        outFic.write('%s;%s\n' % (k, v))
    if not fullDict[i]['status'].has_key('ead') and fullDict[i]['status'].has_key('ead_server') and fullDict[i]['status'].has_key('ead_web'):
        if int(fullDict[i]['status']['ead_server']) + int(fullDict[i]['status']['ead_web']) == 2:
            outFic.write('ead,1\n')
        else:
            outFic.write('ead,0\n')
    outFic.write("# ========================================\n")
    for k, v in fullDict[i]['server'].items():
        outFic.write('%s;%s\n' % (k, v))
    outFic.write("# ========================================\n")
    outFic.write("# RECUPERATION DES INFOS CONFIG ZEPHIR\n")
    for k, v in fullDict[i]['config_zephir'].items():
        outFic.write('zeph_%s;%s\n' % (k, v))
    outFic.write("# ========================================\n")
    outFic.write("# ========================================\n")
    outFic.write("# RECUPERATION DES MESURES\n")
    try:
        for k, v in fullDict[i]['measures'].items():
            outFic.write("#STATUS:[%s]\n" % k)
            for k2, v2 in v.items():
                sPrefixe=""
                if oDicPrefixes.has_key(str(k)):
                    sPrefixe=k+"_"
                if type(v2) == tuple:
                    v2 = '(%s)' % '| '.join([type(j) == int and str(j) or "'%s'" % j for j in v2])
                elif type(v2) == list:
                    v2 = v2[0]
                elif type(v2) == dict:
                    v2 = '[%s]' % k2
                elif k2[:4] == 'load':
                    v2 = int(100*float(v2))
                elif k2[:6] == 'in_eth' or k2[:7] == 'out_eth' or k2[:8] == 'in_ipsec' or k2[:9] == 'out_ipsec':
                    v2 = '%d|%d' % (v2*1024, fullDict[i]['measures']['sysinfo']['uptime'])
                outFic.write('%s%s;%s\n' % (sPrefixe,k2, v2))
    except:
        pass
    try:
        outFic.write('# ========================================\n')
        outFic.write('# Liste des paquets en maj\n')
        outFic.write('paquets_maj;%s\n' % '|'.join(fullDict[i]['paquets_maj']))[:150]
        outFic.write('# ========================================\n')
    except:
        pass
        #print fullDict[i]['config_zephir']['id']
    outFic.close()
    
    if os.path.exists(lastFile):
    	os.system("cat %s | sort > %s/%s-s1; cat %s | sort > %s/%s-s2" % (lastFile,tempdir,i,currentFile,tempdir,i) )
        os.system("diff %s/%s-s1 %s/%s-s2 | grep '>' | sed 's/> //g' > %s" % (tempdir,i,tempdir,i,deltafile) )
    else:
    	os.system("cp %s %s" % (currentFile,deltafile) )

print "#Récupération terminée"

