# -*- coding: utf-8 -*-
import time
# FIXE l'encodage en utf-8,
# car au lancement du service getpreferredencoding() ne récupère pas le bon encoding
charset='UTF-8'

def sentinellestatus2zephir(sValeur):
    if (sValeur == "ECHEC"):
        return 0
    if (sValeur == "OK"):
        return 1
    if (sValeur == "EN COURS"):
        return 2
    if (sValeur == "N/C"):
        return -2
    return 8

def getServeurName(p_sName):
    s=getServeurModuleName(p_sName)
    if s == "": return ""
    return s.upper()+'_uids'

def getServeurModuleName(p_sName):
    sName=p_sName.split("-")[0]
    return sName


def getEtabType(p_sName):
    sType=p_sName
    if p_sName.find('LYCEE PROFESSIONNEL')!=-1:
        sType="LP"
    elif p_sName.find('LYCEE')!=-1:
        sType="LYC"
    elif p_sName.find('COLLEGE')!=-1:
        sType="CLG"
    elif p_sName.find('IEN')!=-1:
        sType="IEN"
    elif p_sName.find('CIO')!=-1:
        sType="CIO"
    elif p_sName.find('SAIO')!=-1:
        sType="SAIO"
    elif p_sName.find('ECOLE MATERNELLE')!=-1:
        sType="MATERNELLE"
    elif p_sName.find('ECOLE DE NIVEAU ELEMENTAIRE')!=-1:
        sType="PRIMAIRE"


    return sType


def cast(objet):
    if type(objet) == int:
        objet=str(objet)
    if type(objet) == float:
        objet=str(objet)
    if type(objet) == unicode:
        objet=convert(objet)
    return objet

def convert(objet):
    """Transforme les objets unicode contenus dans un objet en chaines
    """
    if type(objet) == list:
        l = []
        for item in objet:
            l.append(convert(item))
        return l
    if type(objet) == tuple:
        l = []
        for item in objet:
            l.append(convert(item))
        return l
    if type(objet) == dict:
        dico={}
        for cle in objet.keys():
            dico[cle] = convert(objet[cle])
        return dico
    if type(objet) == unicode:
        string =  objet.encode(charset)
        return (string)
    if type(objet) == str:
        objet = (objet)
    return objet




def zephtime2seconds(sTime):
    if (sTime.find('-')!=-1):
        sFormat='%Y-%m-%d %H:%M:%S'
    else:
        sFormat='%a %b %d %H:%M:%S %Y'
    try:
        i=int(time.mktime(time.strptime(sTime,sFormat)))
    except:
        i=0
    return i

