# -*- coding: utf-8 -*-
class CreateComposantes < ActiveRecord::Migration
  def change
    create_table :composantes do |t|
      t.string :tag
      t.string :name
      t.text    :description
      t.string  :categorie
      t.integer :parent_id
      t.string  :icon
      t.string  :fullname
      t.boolean :flaguid
      # Messages
      t.string  :error_condition
      t.text    :error_message
      t.string  :change_message
      
      # Graphique
      t.string  :unit
      t.string  :legend
      t.string  :color
      t.boolean :marker
      t.string  :modele

      t.boolean :logall , :default => false

      t.boolean :expert
      t.integer :serveur_id
      t.references :user

      t.timestamps
    end
    
    create_table :serveurs do |t|
      t.references :composante
      t.boolean    :actif
      t.boolean    :inprogress
      t.boolean    :byetab
      t.integer    :tfrequence
      t.string     :tunit
      t.string     :modele
      t.string     :arguments
      t.timestamp  :laststart
      t.integer    :lastduration
      t.string     :laststatus
      t.integer    :percent
      t.string     :current  # uid en cours de traitement
      t.boolean    :canceled # Indique si l'arrêt d'éxécution à été demandé
      t.integer    :tries , :default => 0   # Nombre d'essais où le serveur était lock
      t.text       :commande
      t.integer    :maxseconds, :default => 60

      t.text       :actions # En placement de modele,commande,arguments, serialisation d'une Action
      t.references :user
      
      t.timestamps
    end

    create_table :values do |t|
      t.string :uid
      t.string :masteruid
      t.integer :etat
      t.integer :nberreurs
      t.text  :message
      t.text    :extra
      t.references :composante
      t.string   :valeur
      t.timestamps
    end

    create_table :value_histories do |t|
      t.string :uid
      t.string :masteruid
      t.integer :etat
      t.integer :nberreurs
      t.string  :source
      t.text     :message
      t.text    :extra
      t.references :composante
      t.string   :valeur
      t.string   :val4History
      t.timestamps
    end
    
    create_table :logs do |t|
      t.string :uid
      t.string :masteruid
      t.integer :etat
      t.integer :nberreurs
      t.string  :source
      t.text     :message
      t.text    :extra
      t.references :composante
      t.string   :valeur
      t.timestamps
    end

    create_table :filtres_composantes do |t|
      t.integer :filtre_id
      t.integer :composante_id
    end

    add_index :values , :composante_id
    add_index :values , [:uid,:composante_id]
    add_index :values , [:uid,:composante_id,:masteruid],:unique => true

    add_index :value_histories , [:uid,:composante_id,:created_at]


    add_index :composantes , :fullname

    execute <<-SQL
       ALTER TABLE value_histories DROP PRIMARY KEY ,
       ADD PRIMARY KEY (  id ,  created_at )
    SQL

    execute <<-SQL
      ALTER TABLE value_histories
      PARTITION BY RANGE( MONTH(created_at) )
      SUBPARTITION BY HASH( DAY(created_at) )
      SUBPARTITIONS 31 (
        PARTITION p0 VALUES LESS THAN (2),
        PARTITION p1 VALUES LESS THAN (3),
        PARTITION p2 VALUES LESS THAN (4),
        PARTITION p3 VALUES LESS THAN (5),
        PARTITION p4 VALUES LESS THAN (6),
        PARTITION p5 VALUES LESS THAN (7),
        PARTITION p6 VALUES LESS THAN (8),
        PARTITION p7 VALUES LESS THAN (9),
        PARTITION p8 VALUES LESS THAN (10),
        PARTITION p9 VALUES LESS THAN (11),
        PARTITION p10 VALUES LESS THAN (12),
        PARTITION p11 VALUES LESS THAN MAXVALUE
      );


    SQL

  end
  
  def self.down
    drop_table :composantes
    drop_table :values
  end
  
end
