class CreateUsers < ActiveRecord::Migration
  def change
    create_table :users do |t|
      t.string :uid
      t.string :nom
      t.string :prenom
      t.string :password
      t.string :mail
      t.boolean :actif
      t.text   :entities
      t.string :categorie
      t.boolean :special
      t.boolean :dynamic
      t.boolean :share , :default => false
      # Zephir
      t.string  :zephir_uid
      t.string  :zephir_password
      t.text    :zephir_profil
      
      t.boolean :guest
      t.timestamp :lastaction
      t.references :user
      t.references :filtre
      t.references :menu
      t.references :profile
      t.timestamps
    end

    create_table :profiles do |t|
      t.integer :perspective_entite
      t.integer :perspective_contextuelle
      t.text    :options
      t.text    :vues_order
      t.text    :vues_active
      t.text    :notifications_active , :default => nil
    end

    create_table :filtres_profiles do |t|
      t.integer :filtre_id
      t.integer :profile_id
    end
    
    create_table :groups_users do |t|
      t.integer :group_id
      t.integer :user_id
    end

    create_table :menus do |t|
      t.string     :nom
      t.string     :url
      t.string     :tag
      t.string     :famille
      t.references :menu
      t.references :user
      t.timestamps
    end
    add_index :menus , :tag

    create_table :menus_users do |t|
      t.integer :menu_id
      t.integer :user_id
    end

    add_index :groups_users, :group_id
    add_index :groups_users, :user_id 


    add_index :users, :user_id
    add_index :users, :uid
    

  end


  
  def self.down
    drop_table :users
    drop_table :groups_users
    drop_table :menus
    drop_table :menus_users
  end
  
  
end
