class AddSessionsTable < ActiveRecord::Migration
  def change
    create_table :sessions do |t|
      t.string :session_id, :null => false
      t.text :data , :limit => 4.megabytes
      t.timestamps
    end

    create_table :appconfigs do |t|
      t.string :key, :null => false
      t.string :value, :default => ""
      t.string :categorie, :default => "texte"
      t.string :desc , :default => ""
      t.string :groupe, :default => ""
      t.string :ssgroupe, :default => ""
      t.timestamps
    end
    
    

    add_index :sessions, :session_id
    add_index :sessions, :updated_at
  end
end
