class AddObjectTable < ActiveRecord::Migration
  def change
    create_table :objets do |t|
      t.string  :nom
      t.text    :description
      t.text    :data
      t.integer :contexte
      t.string  :categorie
      t.integer :owner_id
      t.integer :profile_id
      t.integer :position, :default => 0
      t.integer :mode
      t.references :evaluation
      t.references :filtre
      t.integer   :groupeby , :default => -1
      t.timestamps
    end

    create_table :rights do |t|
      t.integer :objet_id
      t.integer :user_id
      t.integer  :droit
    end


    create_table :filtres_vues do |t|
      t.integer :filtre_id
      t.integer :vue_id
    end

    create_table :evaluations do |t|
      t.text    :entities
      t.boolean :compiled, :default => false
      t.timestamps
    end

    create_table :icones do |t|
      t.string  :uid
      t.binary  :image , :limit => 10.kilobyte
      t.timestamps
    end
    #add_index :icones , :uid

  end



  def self.down
    drop_table :objets
    drop_table :filtres_vues
    drop_table :evaluations
    drop_table :icones
  end

end