class CreateMessages < ActiveRecord::Migration

  def change
    create_table :messages do |t|
      t.string  :entity
      t.string  :nuid
      t.string  :objet
      t.text    :message
      t.string  :categorie
      t.string  :icone
      t.string  :expression
      t.references :user
      t.references :notification
      t.timestamps
    end

    create_table :handlers do |t|
      t.string  :action
      t.text    :parameters
      t.string  :uid
      t.boolean :consumed , :default => false

      t.references :user
      t.timestamps
    end

    add_column :profiles, :notification_lastdate  , :datetime , :default => Time.now
    add_column :profiles, :notifiers  , :text
    add_column :users, :portable , :string , :default => ""
    add_column :users, :connected, :boolean , :default => false

  end

  def self.down
    drop_table :messages
    drop_table :handler
  end

end

