# encoding: UTF-8
# This file is auto-generated from the current state of the database. Instead
# of editing this file, please use the migrations feature of Active Record to
# incrementally modify your database, and then regenerate this schema definition.
#
# Note that this schema.rb definition is the authoritative source for your
# database schema. If you need to create the application database on another
# system, you should be using db:schema:load, not running all the migrations
# from scratch. The latter is a flawed and unsustainable approach (the more migrations
# you'll amass, the slower it'll run and the greater likelihood for issues).
#
# It's strongly recommended to check this file into your version control system.

ActiveRecord::Schema.define(:version => 20133108000000) do

  create_table "actions", :force => true do |t|
    t.boolean  "actif"
    t.integer  "script_id"
    t.integer  "serveur_id"
    t.text     "arguments"
    t.datetime "laststart"
    t.integer  "lastduration", :default => 0
    t.string   "laststatus",   :default => ""
    t.integer  "percent",      :default => 0
    t.string   "current",      :default => ""
    t.datetime "created_at",                   :null => false
    t.datetime "updated_at",                   :null => false
  end

  create_table "appconfigs", :force => true do |t|
    t.string   "key",                             :null => false
    t.string   "value",      :default => ""
    t.string   "categorie",  :default => "texte"
    t.string   "desc",       :default => ""
    t.string   "groupe",     :default => ""
    t.string   "ssgroupe",   :default => ""
    t.datetime "created_at",                      :null => false
    t.datetime "updated_at",                      :null => false
  end

  create_table "composantes", :force => true do |t|
    t.string   "tag"
    t.string   "name"
    t.text     "description"
    t.string   "categorie"
    t.integer  "parent_id"
    t.string   "icon"
    t.string   "fullname"
    t.boolean  "flaguid"
    t.string   "error_condition"
    t.text     "error_message"
    t.string   "change_message"
    t.string   "unit"
    t.string   "legend"
    t.string   "color"
    t.boolean  "marker"
    t.string   "modele"
    t.boolean  "logall",          :default => false, :null => false
    t.boolean  "expert"
    t.integer  "serveur_id"
    t.integer  "user_id"
    t.datetime "created_at",                         :null => false
    t.datetime "updated_at",                         :null => false
    t.boolean  "inherite_perm",   :default => false
  end

  add_index "composantes", ["fullname"], :name => "index_composantes_on_fullname"

  create_table "evaluations", :force => true do |t|
    t.text     "entities"
    t.boolean  "compiled",   :default => false
    t.datetime "created_at",                    :null => false
    t.datetime "updated_at",                    :null => false
  end

  create_table "filtres_composantes", :force => true do |t|
    t.integer "filtre_id"
    t.integer "composante_id"
  end

  create_table "filtres_profiles", :force => true do |t|
    t.integer "filtre_id"
    t.integer "profile_id"
  end

  create_table "filtres_vues", :force => true do |t|
    t.integer "filtre_id"
    t.integer "vue_id"
  end

  create_table "groups_users", :force => true do |t|
    t.integer "group_id"
    t.integer "user_id"
  end

  add_index "groups_users", ["group_id"], :name => "index_groups_users_on_group_id"
  add_index "groups_users", ["user_id"], :name => "index_groups_users_on_user_id"

  create_table "handlers", :force => true do |t|
    t.string   "action"
    t.text     "parameters"
    t.string   "uid"
    t.boolean  "consumed",   :default => false
    t.integer  "user_id"
    t.datetime "created_at",                    :null => false
    t.datetime "updated_at",                    :null => false
  end

  create_table "icones", :force => true do |t|
    t.string   "uid"
    t.binary   "image"
    t.datetime "created_at", :null => false
    t.datetime "updated_at", :null => false
  end

  create_table "logs", :force => true do |t|
    t.string   "uid"
    t.string   "masteruid"
    t.integer  "etat"
    t.integer  "nberreurs"
    t.string   "source"
    t.text     "message"
    t.text     "extra"
    t.integer  "composante_id"
    t.string   "valeur"
    t.datetime "created_at",    :null => false
    t.datetime "updated_at",    :null => false
  end

  create_table "menus", :force => true do |t|
    t.string   "nom"
    t.string   "url"
    t.string   "tag"
    t.string   "famille"
    t.integer  "menu_id"
    t.integer  "user_id"
    t.datetime "created_at", :null => false
    t.datetime "updated_at", :null => false
  end

  add_index "menus", ["tag"], :name => "index_menus_on_tag"

  create_table "menus_users", :force => true do |t|
    t.integer "menu_id"
    t.integer "user_id"
  end

  create_table "messages", :force => true do |t|
    t.string   "entity"
    t.string   "nuid"
    t.string   "objet"
    t.text     "message"
    t.string   "categorie"
    t.string   "icone"
    t.string   "expression"
    t.integer  "user_id"
    t.integer  "notification_id"
    t.datetime "created_at",      :null => false
    t.datetime "updated_at",      :null => false
  end

  create_table "objets", :force => true do |t|
    t.string   "nom"
    t.text     "description"
    t.text     "data"
    t.integer  "contexte"
    t.string   "categorie"
    t.integer  "position",                         :null => false
    t.integer  "owner_id"
    t.integer  "profile_id"
    t.integer  "mode"
    t.integer  "evaluation_id"
    t.integer  "filtre_id"
    t.integer  "groupeby"
    t.datetime "created_at",                       :null => false
    t.datetime "updated_at",                       :null => false
    t.text     "compiled"
    t.boolean  "good",          :default => false
    t.string   "composantes",   :default => ""
    t.string   "tag",           :default => ""
  end

  create_table "permissions", :force => true do |t|
    t.integer  "composante_id"
    t.integer  "user_id"
    t.integer  "droits"
    t.integer  "position"
    t.datetime "created_at",    :null => false
    t.datetime "updated_at",    :null => false
  end

  add_index "permissions", ["composante_id"], :name => "index_permissions_on_composante_id"
  add_index "permissions", ["user_id"], :name => "index_permissions_on_user_id"

  create_table "profiles", :force => true do |t|
    t.integer  "perspective_entite"
    t.integer  "perspective_contextuelle"
    t.text     "options"
    t.text     "vues_order"
    t.text     "vues_active"
    t.text     "notifications_active"
    t.datetime "notification_lastdate",    :default => '2013-01-16 04:13:53'
    t.text     "notifiers"
  end

  create_table "rights", :force => true do |t|
    t.integer "objet_id"
    t.integer "user_id"
    t.integer "droit"
  end

  create_table "serveurs", :force => true do |t|
    t.integer  "composante_id"
    t.boolean  "actif"
    t.boolean  "inprogress"
    t.boolean  "byetab"
    t.integer  "tfrequence"
    t.string   "tunit"
    t.string   "modele"
    t.string   "arguments"
    t.datetime "laststart"
    t.integer  "lastduration"
    t.string   "laststatus"
    t.integer  "percent"
    t.string   "current"
    t.boolean  "canceled"
    t.integer  "tries",         :default => 0,  :null => false
    t.text     "commande"
    t.integer  "maxseconds",    :default => 60, :null => false
    t.integer  "user_id"
    t.datetime "created_at",                    :null => false
    t.datetime "updated_at",                    :null => false
  end

  create_table "sessions", :force => true do |t|
    t.string   "session_id",                     :null => false
    t.text     "data",       :limit => 16777215
    t.datetime "created_at",                     :null => false
    t.datetime "updated_at",                     :null => false
  end

  add_index "sessions", ["session_id"], :name => "index_sessions_on_session_id"
  add_index "sessions", ["updated_at"], :name => "index_sessions_on_updated_at"

  create_table "users", :force => true do |t|
    t.string   "uid"
    t.string   "nom"
    t.string   "prenom"
    t.string   "mail"
    t.boolean  "actif",           :default => true
    t.text     "entities"
    t.string   "categorie"
    t.boolean  "special"
    t.boolean  "dynamic"
    t.boolean  "share",           :default => false, :null => false
    t.string   "zephir_uid"
    t.string   "zephir_password"
    t.text     "zephir_profil"
    t.boolean  "guest"
    t.datetime "lastaction"
    t.integer  "user_id"
    t.integer  "filtre_id"
    t.integer  "menu_id"
    t.integer  "profile_id"
    t.datetime "created_at",                         :null => false
    t.datetime "updated_at",                         :null => false
    t.string   "portable",        :default => ""
    t.boolean  "connected",       :default => false
    t.string   "avatar",          :default => ""
    t.string   "password_digest"
  end

  add_index "users", ["uid"], :name => "index_users_on_uid"
  add_index "users", ["user_id"], :name => "index_users_on_user_id"

  create_table "value_histories", :id => false, :force => true do |t|
    t.integer  "id",                            :null => false
    t.string   "uid"
    t.string   "masteruid"
    t.integer  "etat"
    t.integer  "nberreurs"
    t.string   "source"
    t.text     "message"
    t.text     "extra"
    t.integer  "composante_id"
    t.string   "valeur"
    t.datetime "created_at",                    :null => false
    t.datetime "updated_at",                    :null => false
    t.string   "val4History",   :default => ""
  end

  add_index "value_histories", ["uid", "composante_id", "created_at"], :name => "index_value_histories_on_uid_and_composante_id_and_created_at"

  create_table "values", :force => true do |t|
    t.string   "uid"
    t.string   "masteruid"
    t.integer  "etat"
    t.integer  "nberreurs"
    t.text     "message"
    t.text     "extra"
    t.integer  "composante_id"
    t.string   "valeur",        :limit => 2048
    t.datetime "created_at",                    :null => false
    t.datetime "updated_at",                    :null => false
  end

  add_index "values", ["composante_id"], :name => "index_values_on_composante_id"
  add_index "values", ["uid", "composante_id", "masteruid"], :name => "index_values_on_uid_and_composante_id", :unique => true

end
