#!/bin/bash

VERSION="1.0.1" # VERSION_HANDLER

L="$@"

# log:
# 1, log actif
# 0, log inactif
log=0
function logme()
{
    [[ $log ]] && echo "$1" >> /tmp/handler.log
}

logme ""
logme "HANDLER START"
logme "$L"

# Récupère l'action
ACTION=`echo $L | sed 's/sentinelle\:\/\///g' | sed 's/\/?/?/g' | cut -d\? -f1`
L=`echo $L | sed 's/sentinelle\:\/\///g'| sed 's/\%5E/^/g'  | cut -d\? -f2`

# Parse les paramètres url et uid ==================
INDEX=1
while [ true ] ; do
        param=`echo $L | cut -d\& -f$INDEX`
        if [ "$param" = "" ] ; then break; fi
        INDEX=`expr $INDEX + 1`
  logme "eval $param"
  eval "$param"
  if [ "$param" = "$L" ] ; then break; fi
done
# ==================================================


DIR=`dirname $0` 

if [ "$ACTION" == "handler" ] ; then
	logme "HANDLER:$url?uid=$uid"
    ACTION=""
	file=/tmp/handler-$uid
	wget --no-check-certificate "$url?uid=$uid" -O $file
	if [ $? -eq 0 ] ; then
		while read line
		do
			if [ "$ACTION" = "" ] ; then
				ACTION="$line"
			else
				logme "  EVAL:$line"
				eval "$line"
			fi
		done < $file
    else
        logme "Echec de récupération de la commande" 	
	fi
	rm -rf $file
fi


# Notify
if [ "$ACTION" = "notify" ] ; then

    # Parametres
    summary=${objet:-"Message"}
    message=${message:-"---"}
    delay=${delay:-2000}
    icon=${icon:-""}; I=""

    # Si l'icone commence par http, on va récupérer l'image
    if [[ $icon == http* ]]; then
        wget --no-check-certificate "$icon" -O /tmp/icone 
	    icon="/tmp/icone"
    fi

    if [ "$icon" != "" ] ; then
        I="-i $icon"	
    fi

    
    if [ "$message" != "---" ] ; then 
        logme "notify-send -t $delay $I  \"$summary\" \"$message\""
        notify-send -t $delay $I  "$summary" "$message"
    fi
fi


# avec gnome-terminal

if [ "$ACTION" = "putty" ] ; then
	password=`echo $L |  cut -d= -f5`
	echo  $passwd | xclip -selection c
	port=`echo $port | sed 's/%20/ /g' `
	notify-send  Message "$nom, mdp copié."
	${profile:-default}
	gnome-terminal -t "$nom" --window-with-profile=$profile -e "ssh -oStrictHostKeyChecking=no -X $user@$host"
fi

# Ping
if [ "$ACTION" = "ping" ] ; then
	gnome-terminal -t  "$host" -e "ping $host"
fi

# Telnet
if [ "$ACTION" = "telnet" ] ; then
        gnome-terminal -t  "$host" -e "telnet $host"
fi

# VNC
if [ "$ACTION" = "vnc" ] ; then
	vncviewer $host
fi

# Bureau à Distance
if [ "$ACTION" = "rdesktop" ] ; then
	rdesktop $host
fi

# SCP via SSHFS
if [ "$ACTION" = "winscp" ]  && [ "$user" = "root" ] ; then
	echo  $passwd >> ~/handler.log
	echo  $passwd | xclip -selection c
	notify-send  Message "Montage en cours, mdp copié."
	nautilus  sftp://$user@$host"$point"
fi

# Démontage SSHFS

if [ "$ACTION" = "winscp" ]  && [ "$user" = "dem" ] ; then
	port=`echo $port | sed 's/%20/ /g' `
#	notify-send  Message $L
	#fusermount -u ~/telemaintenance/"$port"
	gvfs-mount -u sftp://root@$host
	
fi
