#!/bin/bash

# Initialisation de la base de données
# Attention : cette procédure va écraser la base de données existante

clear
echo "======================================================================="
echo  "   Initialisation de la base de données Sentinelle"
echo "ATTENTION: Cette procédure va écraser la base de données existante"
echo "======================================================================="
echo ""
echo "Pour continuer taper oui"
read P

if [ "$P" != "oui" ] ; then
  echo "abandon de la procédure d'initialisation"
  exit
fi

echo ""
echo "Début de l'initialisation"


SENTINELLE_HOME="/home/sentinelle"
SENTINELLE_APP="$SENTINELLE_HOME/alizes"

source ~/.rvm/scripts/rvm

export RAILS_ENV=batches

[ ! -d $SENTINELLE_APP/public ] && mkdir $SENTINELLE_APP/public

# Roolback total, drop de la base + création d'une base toute neuve
rake db:drop && rake db:create && rake db:migrate
if [ $? -eq 0 ]; then
	rails r "load 'script/init.rb'"
else
  echo "Erreur lors de l'initialisation de la base de données"
fi

