### lib/date_overrides.rb
Date::MONTHS.replace({'Janvier' => 1, 'Fevrier' => 2, 'Mars' => 3, 'Avril' => 4, 'Mai' => 5, 'Juin' => 6, 'Juillet' => 7, 'Aout' => 8, 'Septembre'=> 9, 'Octobre' =>10, 'Novembre' =>11, 'Decembre' => 12})
Date::DAYS.replace({'Dimanche' => 0, 'Lundi' => 1, 'Mardi' => 2, 'Mercredi' => 3, 'Jeudi'=> 4, 'Vendredi' => 5, 'Samedi' => 6})
Date::ABBR_MONTHS.replace({'jan' => 1, 'fev' => 2, 'mar' => 3, 'avr' => 4, 'mai' => 5, 'juin' => 6, 'juil' => 7, 'aou' => 8, 'sep' => 9, 'oct' =>10, 'nov' =>11, 'dec' => 12})
Date::ABBR_DAYS.replace({'dim' => 0, 'lun' => 1, 'mar' => 2, 'mer' => 3, 'jeu' => 4, 'ven' => 5, 'sam' => 6})
Date::MONTHNAMES.replace [nil] + %w(Janvier Fevrier Mars Avril Mai Juin Juillet Aout Septembre Octobre Novembre Decembre )
Date::DAYNAMES.replace %w(Dimanche Lundi Mardi Mercredi Jeudi Vendredi Samedi)
Date::ABBR_MONTHNAMES.replace [nil] + %w(jan fev mar avr mai juin juil aou sep oct nov dec)
Date::ABBR_DAYNAMES.replace %w(dim lun mar mer jeu ven sam)


class Time
  alias :strftime_nolocale :strftime

  def strftime(format)
    format = format.dup
    format.gsub!(/%a/, Date::ABBR_DAYNAMES[self.wday])
    format.gsub!(/%A/, Date::DAYNAMES[self.wday])
    format.gsub!(/%b/, Date::ABBR_MONTHNAMES[self.mon])
    format.gsub!(/%B/, Date::MONTHNAMES[self.mon])
    self.strftime_nolocale(format)
    "ttt"
  end
end

# exemples de formats de date
Time::DATE_FORMATS[:fr_date] = '%d-%m-%y'
Time::DATE_FORMATS[:fr] = '%d-%m-%y %H:%M'
Time::DATE_FORMATS[:fr_long] = '%A %d %B %Y a %Hh%I'
Time::DATE_FORMATS[:frs] = '%d-%m-%y %H:%M:%s'