module Engine


  
  class Test
    
    def self.test
      entity=Kernel.entity
      t=Thread.start {
            $SAFE=1
            Engine::Kernel.class_eval("Kernel.entity='#{entity}';Infosetabs.libelle;")
       }
       t.value
    end
  end


  class Server
    

    
    def self.get(entity,serveur,composante_id)
      
    end
    
    def self.getFirst(serveur,composante_id)
      #puts Kernel.entity
      Value.all(:conditions => ["masteruid = ? and composante_id = ?",
                                 Thread.current[:entity],composante_id]).first.valeur 
    end
    
    def self.getAll(serveur,composante_id)
      Value.all(:conditions => ["masteruid = ? and composante_id = ?",
                                  Thread.current[:entity],composante_id]) 
    end
    
    
    
  end
  
  
  class Kernel
    
    def self.entity
      Thread.current[:entity]
    end
    def self.entity=(entity)
      Thread.current[:entity] = entity
    end
    
    def self.buildEntities
      Entities.getAll.first(5).each do |e|
        e=e.valeur
        puts e
        klass = Object.const_set("E"+e,Class.new)
        
      end
    end
    
    def self.value(id)
      value=Thread.current[:values].select { |v| v.composante_id == id }
      return Value::NOTEXIST if value==nil || value==[]
      value.last
    end
    
    # Méthod appleé lors de l'évaluation
    def self.b(id)
      value=Thread.current[:values].select { |v| v.composante_id == id }
      return Value::NOTEXIST if value==nil || value==[]
      #return Value::FORBIDDEN if ! value.first.composante.isReadable?
      if value.last.masteruid!=nil
        Thread.current["#{value.last.masteruid},#{id}"]=value.last.valeur
      end
      value.last.valeur
    end
    
    def self.nberreurs(id)
      v=Kernel.value(id)
      return 0 if  v.is_a? String
      if v.masteruid!=nil
        Thread.current["#{v.masteruid},#{id}"]=v.nberreurs
      end
      v.nberreurs
    end

    def self.statut(id)
      v=Kernel.value(id)
      return "?" if  v.is_a? String
      ret=(v.etat==0)?"off":"on"
      if v.masteruid!=nil
        Thread.current["#{v.masteruid},#{id}"]=ret
      end
      ret
    end

    def self.format(id,categorie,tag,unit="")
      v=Kernel.value(id)
      return "?" if  v.is_a? String

      case categorie
        when Composante::STATUT             then return Kernel.format_statut(v.valeur,false)
        when Composante::PING               then return Kernel.format_ping(v,tag)
        when Composante::NUMERIC            then return Kernel.format_numeric(v.valeur,unit)
        when Composante::CAPACITYDISK       then return Kernel.format_capacitydisk(v,false)

      end
      return v.valeur
      #ComposantesController.helpers.format_composante_valeur(categorie,v,false,tag)
    end

    def self.uniqueID
      rand(36**16).to_s(36)
    end

    def self.format_numeric(number,unit="")
      begin
        Float(number)
      rescue ArgumentError, TypeError
          return number
      end
      delimiter=" "
      separator="."
      parts = number.to_s.to_str.split('.')
      parts[0].gsub!(/(\d)(?=(\d\d\d)+(?!\d))/, "\\1#{delimiter}")
      parts.join(separator).html_safe + " #{unit}"
    end

    def self.format_statut(valeur,fullinfos)
      "<div class='composante value #{Value.to_bool(valeur)}' title='#{valeur}'>&nbsp;</div>"
    end

    def self.format_ping(value,tag)
      id=Kernel.uniqueID
      r="<ping id='#{id}' tag='#{tag}' min='#{value.attr(:min)}' max='#{value.attr(:max)}' avg='#{value.attr(:avg)}' lost='#{value.attr(:lost)}' samples='#{value.attr(:samples).join(" ")}'></ping>"
    end

    def self.format_capacitydisk(value,fullinfos)
      #dateTime = Time.new
      #id= dateTime.to_time.to_i+rand(1000)
      #"<div id='yy'>&nbsp;</div>"
      id=Kernel.uniqueID
      r="<div id='#{id}' style='display:inline;'></div>"
      r<<"<script>gauge.add(document.getElementById('#{id}'),"
      r<<" {colors:['#66ff66','#ff0000'],width:130, height: 25, gradient: true,limit:true , values:[#{value.getExtra[:used]},#{value.getExtra[:capacity]}]})</script>"

      if fullinfos
        r<<"&nbsp;<div style='width:30px;vertical-align:top; display:inline-block;'>#{value.getExtra[:percent]}%</div> #{value.getExtra[:format]}&nbsp; #{value.getExtra[:used]}/#{value.getExtra[:capacity]}Mo "

      end
      r
    end

    def self.human(id,categorie,tag,unit="")

      v=Kernel.value(id)
      return 0 if  v.is_a? String
      case categorie


        when Composante::STATUT             then
          return "#{(Value.to_bool(v.valeur))?"OK":"ECHEC"}"

        when Composante::RATEbps       then
          valeur=v.getExtra[:rate].to_i
          return "#{(valeur/(1000*1000.0)).round(3)} Mbits/s"  if  valeur >= 1000*1000
          return "#{(valeur/1000.0).round(3)} Kbits/s"  if  valeur >= 1000
          return "#{valeur} bits/s"

        when Composante::NUMERIC       then
          valeur=v.valeur.to_i
          return "#{(valeur/(1000*1000.0)).round(3)} M#{unit}"  if  valeur >= 1000*1000
          return "#{(valeur/1000.0).round(3)} K#{unit}"  if  valeur >= 1000
          return "#{valeur} #{unit}"

      end

      return v.valeur.to_i
    end

    def self.bps(id)
      v=Kernel.value(id)
      return 0 if  v.is_a? String

    end

    # Retourne depuis combien de temps (en secondes) la valeur a été modifiée
    def self.since(id)
      t=Kernel.updated(id)
      (Time.now()-Time.at(t))
    end
    
    def self.updated(id)
      v=Kernel.value(id)
      return 0 if  v.is_a? String
      t=v.getUpdated.to_i

      if v.masteruid!=nil
        Thread.current["#{v.masteruid},#{id}"]=t
      end
      t
    end
    
    def self.extra(id,key)
      #puts "GetExtra #{id} #{key}"
      v=Kernel.value(id)
      return 0 if  v.is_a? String

      ex=v.getExtra

      return "n/a" if  ! ex.include? key.to_sym

      ex=ex[key.to_sym]
      return 0 if ex==nil

      
      if v.masteruid!=nil
        Thread.current["#{v.masteruid},#{id}"]=ex
      end
      ex
    end
    

    
    def self.buildServeurs()
      
      
      Master.allServeursWithMaster.each do |s| 
	      klass = Engine::Kernel.const_set(s.tag.capitalize,Class.new)

        klass.class_eval do
          
          k=self
          
          define_singleton_method(:[]) do |entity|
            Kernel.entity=entity
            #Server.new(s.tag,entity)
            klass
          end
          
          Composante.all(:conditions => [ "serveur_id = ?",s.id  ]).each do |c|
            
             
             Server.send(:define_singleton_method,c.tag) do
                 Server.getFirst(s.tag,c.id)  
             end
             
             
             # Methodes de class
             define_singleton_method(c.tag) do
                Server.getFirst(s.tag,c.id)  
             end
             
             define_singleton_method(c.tag+"S") do
                Server.getAll(s.tag,c.id)  
             end
              
                
          end

        end
        
      end  
      Engine::Kernel
    end
    
    def self.get(serveur,entity)
      Server.new(serveur,entity)
      #puts "#{Kernel.entity} #{serveur}.#{tag}"
    end
    
    def g(options)
      # Est-ce qu'il y a un entité dans les options ?
      #if options[:e]
      #  entity=options[:e]
      #else
        entity=@entity
      #end
      
      # Récupération de la composante
      composante=Composante.getComposanteFromFullname(options)
      return "" if composante==nil
      
      all=Value.all(:conditions =>["composante_id=? AND masteruid= ?" ,
                 composante.id,
                 entity])
                 
      return "--" if all.empty?
      return all.last.valeur
      #@entity+options[:s]+options[:c]
    end
    
    def self.render(entity,input)
       input=input.gsub('{','#{g("').gsub('}','")}')
       #puts input
       oRender=Haml::Engine.new(input)
       oRender.render(Engine::Kernel.new(entity)).gsub("\n","")
    end
    
    def initialize(entity)
      @entity=entity
    end
  
  end
  
  
  
end
