module Entities

  include Rapports
  
  @@entities={}

  class Entity

    attr_accessor :uid, :libelle,:lat, :lon,:latApprox,:lonApprox

    def initialize(uid, libelle,lat,lon,latApprox,lonApprox,hasGps)
      @uid = uid
      @libelle=libelle
      @lon = lon
      @lat=lat
      @hasGps=hasGps
      @lonApprox = lonApprox
      @latApprox=latApprox
    end

    def uaj
      @uid
    end

    def coord(gpsMode)
      return (gpsMode == Profile::GPS_APPROX )?approx():precis()
    end

    def approx
      [lonApprox, latApprox]
    end

    def precis
      [lon, lat]
    end

    def to_s
      "#{libelle} (#{@uid})"
    end
    
    def empty?
      (!@hasGps) || @libelle==nil || @libelle.empty?  || @libelle == Value::NOTEXIST
    end

    def get(composante)
      Master.get(@uid,composante)
    end

    def set(composante,valeur)
      Master.set(@uid,composante,valeur)
    end

    def setResultat(result)
      setResult(result)
    end

    def getResultat()
      getResult
    end

    def setResult(result)
      batch=Batch.find_by_tag(Batch.current)
      return if !batch

      set(batch.getComposante.fullname,result)

    end

    def getResult()
      batch=Batch.find_by_tag(Batch.current)
      return if !batch

      get(batch.getComposante.fullname)

    end

    def export(composantes)
      FiltreData.evaluation(uid,composantes.map { |c| "{#{c}}"}.join(";"))
    end

  end

  MARKER_PATH="/assets/markers/"

  # Retourne tous les étalisstements
  def self.getAll()
    masterkey=Master.composanteKey
    return [] if masterkey==nil
    Value.all(:select => "valeur,extra,updated_at",:conditions => ["composante_id = ?",masterkey.id])
  end
  
  # Retourne que les établissements de User.curent
  def self.getCurrents()
    User.current.entitiesFilter
  end
  
  def self.first()
    currents=Entities.getCurrents
    return "" if currents.empty?
    currents.first
  end
  
  def self.clear(uid)
    @@entities.delete(uid)
    self.get(uid)
  end

  def self.clearAll()
    @@entities={}
  end


  def self.get(uid)
    if ! @@entities.include? uid
      lat=Master.getLat uid
      lon=Master.getLon  uid
      latApprox=Master.getLatApprox uid
      lonApprox=Master.getLonApprox  uid
      libelle=Master.getLibelle  uid
      e=Entity.new(uid,libelle,lat,lon,latApprox,lonApprox,Master.hasGps(uid))
      @@entities[uid]=e
    else
      e=@@entities[uid]
    end
    e
  end
  
  def self.evaluerTousLesFiltres
    alls=Filtre.getAll
    alls.each do |f|
      puts "Calcule du filtre #{f.nom}"
      f.clear
      Entities.computeFilter2(f)
      #puts "Nb entities: #{f.evaluation.count}"
    end    
  end

  # Evaluation d'une expression du bac a sable
  def self.evalExpression(expression,entity)
    
    # Copilation du filtre
    data=Rapports::FiltreData.compile(expression)
    
    # Est-ce une expression valide ?
    if ! data[:valid]
      return nil 
    end
    
    # Récupération dans la base des valeurs                  
    values=Value.all(conditions: [ "composante_id in (?) AND masteruid = ? ",
                     data[:composantes],entity]) 
    
    valeur=Rapports::FiltreData.evaluer(entity,data[:compiled],values).value

    valeur
    
  end
  
  
  def self.computeFilter2(filtre)
    

    # On va récupérer toutes les composantes (compilation dans la foulée du filtre)
    filtre.composantes=filtre.data.composantes2()

    # Récupération dans la base de toutes les valeurs                  
    allValues=Value.all(conditions: [ "composante_id in (?)",filtre.composantes])
    
    # Toutes les entités
    entities=Entities.getAll()

    #puts "entities:computeFilter2 filtre:#{filtre.expression}, entities=#{entities.count} conditions: [ composante_id in (#{filtre.composantes}) ] "
    bOk=false
    # Evaluation du filtre pour toutes les entités
    entities.each do |entity|
        a=[]
        #puts "entities:computeFilter2 entities.each |#{entity.valeur}|"
        values=allValues.select { |x| x.masteruid == entity.valeur } # Sélection des valeurs pour l'entité courrante
        if filtre.compute(entity.valeur,values,false) == nil # si le retourn de compute est nil , cela signifie que le filtre est invalide
         # puts "entities:computeFilter2 filtre.compute a retourne nil pour #{entity.valeur}"
          next
        end
      bOk=true
    end

    # SI pas OK et au moins une entité, on signale que l'evaluation a echoue, et on retourne
    if ! bOk && entities.count!=0
      puts "L evaluation a echouee pour toute les entites"
      return
    end

    filtre.evaluation.compiled=true
    filtre.evaluation.save if filtre.id
    
  end
  

  def self.computeFilter(filtre)
    puts "Calcule du filtre #{filtre.expression}"
    values=Entities.getAll()
    values.each do |value|
      if filtre.evaluer(value.valeur,true,false)==nil
        puts("Erreur lors du calcul du filtre #{filtre.nom}(#{filtre.data.error})")
        break;
        #filtre.data.error="Erreur"
        #return;
      end
    end
    #puts("BBREAK")
    filtre.evaluation.compiled=true
    filtre.evaluation.save if filtre.id
     

  end

  def self.determineGpsMode(zoom)
    m=User.gps_mode
    if User.current.profile.gpsAuto?
      m=((zoom!=nil) && (zoom.to_i>12))?(Profile::GPS_PRECIS):(Profile::GPS_APPROX)
    end
    m
  end
  
  # Retourne les markers au format json
  # Interpretables par mapstraction
  def self.getMarkers(gpsMode,logger=nil)
    array=[]

    #Rails.logger.level = 3
    #logger.error("#{Time.now}:Tous les filtres et vues")
    # Tous les filtres et vues
    filtres=User.current.profile.getFiltres
    vues=Vue.currents

    visibleEntities={}
    visibleFilters=[]

    bSetGps=Value.to_bool(User.set_gps)
    
    #logger.info("#{User.current.profile.id}  #{filtres}")
    #logger.error("#{Time.now}:START ENTITY")
    values=self.getCurrents()
    logger.info("entities.getMarkers #entities=#{values.count}")
    values.each do |uid|
      #value.valeur contient les uid des entités
      # Pour chaque valeur on récupère les informations du Master
      e=Entities.get(uid)
      next if e.empty? && !bSetGps

      firstEntity=true

      # Vérifie la correspondance des filtres ==============
      b=filtres.empty?
      bModeOu=User.current.filtreModeOU
      filtres.each do |filtre|
        # Vérification si le filtre est valide si 1er entité
        filtre.checkValidity() if firstEntity
        # Filtre invalide => On n'en tient pas compte
        next if ! filtre.data.valid?
        visibleFilters<<filtre.id   if firstEntity
        if filtre.evaluer(uid)
           b=true
           break if bModeOu
        elsif !bModeOu
          b=false
          break 
        end
      end
      if !b # Filtre ne match pas on passe au suivant
        #puts("#{uid} ne correspond pas aux filtres")
        next
      end
      # ======================================================

      icones=[]
      stop=false
      uidicone="|"
      sfilters=""
      # Calcule les vues
      vues.each do |vue|
        next if !vue.actif?
        vue.filtres.each do |filtre|
          sfilters<<"#{filtre}|"
          # Vérification si le filtre est valide si 1er entité
          filtre.checkValidity() if firstEntity
          # Filtre invalide => On n'en tient pas compte
          next if ! filtre.data.valid?
          break if stop
          next  if ! filtre.selected?
          visibleFilters<<filtre.id   if firstEntity
          if (filtre.pique? && icones.empty?)  || filtre.evaluer(uid)
            icones<<filtre
            uidicone<< "#{filtre.id}|"
            if filtre.exclusif?   # Si il est exclusif, on ne regarde pas les autres
              stop=true
              break 
            end
          end
        end
      end

      if icones.empty?
        #puts("#{uid} ne correspond pas aux vues, #{sfilters}")
        icone="#{MARKER_PATH}/default.png"
        next
      elsif icones.size==1
        icone="#{MARKER_PATH}/#{icones.first().pictogramme}"
      else
        ico=Icone.find_by_uid(uidicone)
        if ico==nil
          ico=Icone.createFromFilters(uidicone,icones)
        end
        icone=ico.path
      end

      visibleEntities[uid]=true

      firstEntity=false
      array<< {type: "Feature",
             title: "#{uid}",
             description: " #{e.libelle}",
             id: uid,
             geometry: {type: "Point", coordinates: e.coord(gpsMode)},
             icon: icone,
             icon_size: [24,24],
             properties: {prop0: "value0",  infoBubble: "Contents of bubble",}
             } 
      
    end
    #logger.error("#{Time.now}:END ENTITY")


    User.current.visibleEntitiesAndFilters(visibleEntities,visibleFilters)
    #User.current.profile.set(Profile::VISIBLE_ENTITIES,visibleEntities)
    #User.current.profile.save

    filtres.each do |filtre|
      filtre.evaluation.compiled=true
      filtre.evaluation.save if filtre.evaluation.updated?
    end

    vues.each do |vue|
      vue.filtres.each do |filtre|
        next if ! filtre.selected?
        filtre.evaluation.compiled=true
        filtre.evaluation.save if filtre.evaluation.updated?
      end
    end
    
    array
  end


end
