# -*- coding: utf-8 -*-

module Importations

  include Utils
  require 'open-uri'
  
  PATH="data/importations/"
  
  def self.perspective(filename)
    data = File.read(filename)
    Perspective.import(data)  
  end

   
  # Récupération des composantes dans une entête de fichier CSV
  # Retourne la composantekey, sa position et les composantes
  def self.getComposantes(columns,sep)
    puts "Recherche de composantes avec "
    puts " =>#{columns}"
    composantes=[]
    ckey=nil # La composante servant d'identifiant, on prend la première trouvée
    index_ckey=-1  # Indice
    a=columns.split(sep)
    (0..a.size-1).each do |i|
      #c=Composante.find_by_fullname(a[i])
      c=Composante.getComposanteFromFullname(a[i])
      composantes<<c
      if c==nil
        puts "[#{a[i]}] introuvable"
        next
      end
      
      ckey=c if c.flaguid? and ckey==nil
      index_ckey=i if c.flaguid? and index_ckey==-1
    end
    return ckey,index_ckey,composantes

  end

  def self.distance(a, b)
    rad_per_deg = Math::PI/180  # PI / 180
    rkm = 6371                  # Earth radius in kilometers
    rm = rkm * 1000             # Radius in meters

    dlon_rad = (b[1]-a[1]) * rad_per_deg  # Delta, converted to rad
    dlat_rad = (b[0]-a[0]) * rad_per_deg

    lat1_rad, lon1_rad = a.map! {|i| i * rad_per_deg }
    lat2_rad, lon2_rad = b.map! {|i| i * rad_per_deg }

    a = Math.sin(dlat_rad/2)**2 + Math.cos(lat1_rad) * Math.cos(lat2_rad) * Math.sin(dlon_rad/2)**2
    c = 2 * Math.asin(Math.sqrt(a))

    rm * c # Delta in meters
  end

  def self.getGpsFromAdressePostale

    ActiveRecord::Base.logger = ::Logger.new(nil)

    return false if ! User.A

    key="ABQIAAAAw1SSDc7JV6sSVqFi6ucGqRTwM0brOpm-All5BF6PoaKBxRWWERSg4XiNEMo6heDdYyHlus-Ex7OQ4g"
    url="http://maps.google.com/maps/geo?language=fr&output=json&key=#{key}&q="
    require 'open-uri'
    require 'json'
    require 'uri'

    latref=Appconfig.GPS_LAT_REF.to_f
    lonref=Appconfig.GPS_LON_REF.to_f

    if latref==0 || lonref==0
      puts "ATTENTION: Les coordonnées GPS de référence ne sont pas positionnés"
      puts "Utilisation par défaut du point 0,0"
    end

    puts "Les points au dela de 1000km du point de référence ne seront pas traités"

    Entities.getAll.each do |value|
      uaj=value.valeur

      # Déja positioné on ne fait rien
      lon=_get(uaj,Master::LON_PRECIS.fullname)
      next if lon != nil

      adresse=_get(uaj,"infosetabs.adresse")
      next if adresse==nil

      cp=_get(uaj,"infosetabs.cp")
      next if cp==nil

      ville=_get(uaj,"infosetabs.ville")
      next if ville == nil

      puts "#{uaj}: #{adresse} #{cp} #{ville}"

      uri="#{url}#{URI.escape(adresse)},#{cp.gsub(' ','%20')}%20#{URI.escape(ville)}"
      open uri, :read_timeout => 15  do |io|
        json=io.read
        data = JSON.parse json
        code=data["Status"]["code"]

        if code != 200
          puts "Erreur dans la récupératon code=#{code}"
          next
        end

        #if data["Placemark"].count > 0
        #  puts "Plusieurs points trouvés"
        #  next
        #end

        resultat=[]
        coord=nil
        data["Placemark"].each  do |place|
          c=place["Point"]["coordinates"]
          co=[c[0],c[1]]
          d=self.distance [lonref,latref],c
          next if d>1000*1000

          plus=nil
          if place["AddressDetails"]["Country"]["AdministrativeArea"]
            if place["AddressDetails"]["Country"]["AdministrativeArea"]["SubAdministrativeArea"]
              plus=place["AddressDetails"]["Country"]["AdministrativeArea"]["SubAdministrativeArea"]["SubAdministrativeAreaName"]
            end
          #plus=place["AddressDetails"]["Country"]["AdministrativeArea"]["SubAdministrativeArea"]
          end

          resultat << {distance: d,coord: co,addr: place['address'],country: place['CountryName'],plus: plus}

          #if d>1000*1000
          #  puts "LOIN: #{place['address']} distance=#{(d/1000.0).ceil}Km"
          #  next
          #else
          #end
        end


        if resultat.count>1
          resultat.sort! { |x,y| x[:distance] <=> y[:distance] }
          puts "Plusieurs possibilités"
          c=0
          resultat.each  do |place|
            puts "   #{c}: #{place[:addr]},#{place[:country]} #{place[:plus]} distance=#{(place[:distance]/1000.0).ceil}Km"
            c=c+1
          end
          choix=[(print 'Votre choix (rien pour passer cet établissement): '), gets.rstrip][1]
          next if choix.strip.empty?
          choix=choix.to_i
          next if choix<0 || choix>=resultat.count
          coord=resultat[choix][:coord]
        end

        if resultat.count==1
          place=resultat[0]
          puts " -> #{place[:addr]},#{place[:country]} #{place[:plus]} distance=#{(place[:distance]/1000.0).ceil}Km"
          coord=resultat[0][:coord]
        end

        if resultat.count==0
          puts "Aucune position trouvée"
          puts ""
          next
        end


        next if coord==nil

        #coord=data["Placemark"][0]["Point"]["coordinates"]
        a=_set(uaj,Master::LON_PRECIS.fullname,coord[0])
        b=_set(uaj,Master::LON_APPROX.fullname,coord[0])
        c=_set(uaj,Master::LAT_PRECIS.fullname,coord[1])
        d=_set(uaj,Master::LAT_APPROX.fullname,coord[1])
        if ! (a && b && c && d)
          puts " -> Echec"
        end
        Appconfig.setEntityToRefresh(uaj)
        puts ""
        #puts coord
      end

      #return

    end
  end

  # Fonction permettant de créer la base d'un serveur
  def self.CreateModuleEole(type,script,delay)
    serveur=Master.createServeur(type,"Serveur #{type}")
    Composante.create(:tag => 'zeph_id', :name => 'Identifiant zephir',:parent_id => serveur.id,:flaguid => true)
    Composante.create(:tag => 'libelle', :name => 'Libellé',:parent_id => serveur.id)
    Composante.create(:tag => 'modulename', :name => 'Nom du module',:parent_id => serveur.id)
    Composante.create(:tag => 'zeph_variante', :name => 'Nom de la variante',:parent_id => serveur.id)
    Composante.create(:tag => 'zeph_module_actuel', :name => 'Identifiant du module',:parent_id => serveur.id)
    conf=Composante.create(:tag => 'configuration', :name => 'Configuration', :parent_id => serveur.id, :categorie => Composante::FOLDER)

    serveur.serveurTask.update_attributes(:commande=>"#{script.id}",:arguments => "{#{type}.zeph_id}",
                                          :tfrequence=>delay,:tunit=>Serveur::MINUTE, :byetab => true )

    Importations::sentinellev2("data/importations/include/STATUS_#{type}.xml",serveur)
    Importations::dicos("data/importations/dicos/#{type}",conf)
    conf.permission(Group.admin,Permission::WRITE)
    conf.permission(Group.find_by_uid("@ZENREGISTREMENT"),Permission::MODIFY)
    conf.permission(Group.all,Permission::DENY)

    serveur.permission(Group.find_by_uid("@ZREAD"),Permission::READ)
    serveur.permission(Group.all,Permission::DENY)

    script.serveurs << serveur
    script.save

    serveur
  end


  # Parsing individuel : Utilisé par une action dont le script est "Par Serveur"
  # Cette méthode s'attend donc a voir en paramètre l'identifiant et le serveur
  # Les composantes peuvent être passées avec le format court, 
  # Si masteruid est null, la méthode va récupérer le masteruid dans Master.uid_<serveur>
  # Chaque ligne doit avoir le format  : <tag>;<valeur>
  def self.parseIndividual(identifiant,composante,input,serveur,masteruid=nil)

    source="<serveur>'#{serveur.composante.name}'</serveur>"
    count=0
    Value.transaction do
      ckey=composante.composanteKey
      lines=input.split("\n")
      lines.each do |line|
        line.strip!
        break if serveur.checkCanceled
        # Commence par un # on ne traite pas
        next if line.first == "#"
        # Si il n'y a pas de valeur après un ; on met --- afin que le split suivant retour 2 éléments
        line=line+"---" if   line.last == ";"
        values=line.split(";")
        next if values.count < 2

        # Verifie si la composante est de la forme nom_<composante_fullname>
        arrC=values[0].split("_")
        if arrC.count >= 2
          c=Composante.getComposanteFromFullname(arrC[1])
          # Oui c'est une composante valide, on l'utilise donc
          if c!=nil
            values[0]=arrC[1]
          end
        end

        # Est-ce que c'est une composante valide ?
        c=composante.getComposante(values[0])
        if c==nil
          c=Composante.getComposanteFromFullname(values[0])
        end
        next if c==nil
        
        valeur=values[1].strip
        count=count.next
        begin
          response=Value.setValue(ckey: ckey, ckeyvalue: identifiant,
                       composante: c, value: valeur, source:source,masteruid: masteruid)
          if response.error?
            puts "\n\t\tECHEC: ckey: #{ckey}, ckeyvalue: #{identifiant},composante: #{c.fullname}, value:  #{valeur} => #{response.message}"
          end
        rescue => msg
          puts "/!\\ ### ERREUR lors du traitement de la ligne #{line} /!\\ (#{msg})"
          msg.backtrace.each { |errorline| puts errorline }
        end
                                 
                       
      end
      # Moins de 5 lignes, peut etre une erreur
      if lines.count < 5 || count == 0
        puts"\n Output < 5 lignes"
        puts "----contenu de l'entréé---"
        puts "#{input}"
        puts "-----------fin------------"

      end
      puts "=> Nb:#{count}/#{lines.count}"
      puts ""
    end

  end


  def self.parseGlobal(serveur,input,serveurTask)
      print  "\tParsing global :"
      #ckey=serveur.composanteKey
      ckey=Master.serveur.composanteKey
      lines=input.split("\n")
      total=lines.count
      i=0
      source="<serveur>'#{serveurTask.composante.name}'</serveur>"
      print "---%"
      lines.each do |line|
        line.strip!
        i=i+1
        next if line.first == "#"
        values=line.split("|")
        entity=values.delete_at 0
        e=Entities.get(entity)
        #Value.setValue(ckey: ckey, ckeyvalue: uid,composante:)
        break if serveurTask.reload.checkCanceled
        serveurTask.update_attributes({:current => "#{e}",:percent => ((i*100)/total).to_i() })
        print "\b\b\b\b"
        print "#{(i*100/lines.count).to_s.rjust(3, ' ')}%"
        #puts("====================================")
        Value.transaction do
          values.each do |value|
            keyval= value.split("%%")
            tag=keyval[0]
            valeur=keyval[1]
            begin
            Value.setValue(ckey: ckey, ckeyvalue: entity,
                           composante: serveur.getComposante(tag), 
                           value: valeur,source: source)
            rescue => msg
              puts "/!\\ ### ERREUR lors du traitement global ligne:#{i} [#{line}] value=[#{value}] /!\\ (#{msg})"
              msg.backtrace.each { |errorline| puts errorline }
            end
          end
        end
        #puts("====================================")
    end
    print "\b\b\b\b"
    puts "100%"

  end
  
  def self.script(filename,nom,description,byserver=false,serveurs=[])
    script=Script.create
    script.nom=nom
    script.description=description
    script.byserver=byserver
    script.serveurs=serveurs
    
    File.open(filename, "r") do |aFile|
      lines=aFile.readlines
      script.data.script= lines.join("") 
      script.data.findLanguage(lines[0]) 
    end
    script.save
    script
  end
  
  def self.sentinellev2_subsystem(element,parent)
    

    #puts "Importation d'un subsystem dans #{parent.fullname}"
    
    return if ! parent.isWritable? 
    
    libelle=element.attributes["libelle"]
    icon=element.attributes["icon"]
    tag=element.attributes["type"]
    
    return if tag=="ACTION"
    
    if parent.children.exists? :tag => tag
        folder=parent.getComposante( tag )
    else
        folder=Composante.create(:tag => tag, 
                                 :name => libelle,:parent_id => parent.id, 
                                 :categorie => Composante::FOLDER)
    end
    
    element.elements.each("subsystem") do  |element| 
      sentinellev2_subsystem(element,folder)
    end
    
    element.elements.each("service") do |service|
      sentinellev2_service(service,folder)  
    end

    element.elements.each("include") do |include|
      file=include.attributes["file"]
      sentinellev2(PATH+file,folder) 
    end

  end
  
  def  self.sentinellev2_service(element,parent)
  
    #puts "Importation d'un service dans #{parent.fullname}"
    return if ! parent.isWritable?   
    
    libelle=element.attributes["libelle"]
    tag=element.attributes["tag"]
    
    value=nil
    element.elements.each("value") do |v|
      value=v  
    end
    return if value==nil
    
    type=value.attributes["type"]
    
    if parent.children.exists? :tag => tag
          c=parent.getComposante( tag )
          c.name=libelle
          c.description=libelle
          c.categorie=type
          c.save
    else
          c=Composante.create(:tag => tag, 
                              :name => libelle,
                              :description =>libelle,
                              :categorie => type,
                              :parent_id => parent.id)
   end
    
  end
  
  
  def  self.sentinellev2(filename,parent)
  
    if ! File.exist?(filename)
      puts " => Fichier #{filename} introuvable, on ne fait rien"  
      return 
    end
  
    puts "Importation dun modèle Sentinelle v2 : #{filename} dans #{parent.fullname}"
  
    if ! parent.isWritable? 
      puts "Composante non accessible en écriture"
      return
    end

    require "rexml/document"
    
    file = File.new( filename )
    doc = REXML::Document.new file
    
    
    doc.elements.each("subsystem") do  |element| 
      sentinellev2_subsystem(element,parent)
    end
    
    doc.elements.each("service") do |service|
      sentinellev2_service(service,parent)  
    end
    
    doc.elements.each("include") do |include|
      file=include.attributes["file"]
      sentinellev2(PATH+file,parent) 
    end
    
     doc.elements.each("composantes/subsystem") do  |element| 
      sentinellev2_subsystem(element,parent)
    end
    
    doc.elements.each("composantes/service") do |service|
      sentinellev2_service(service,parent)  
    end
    
    doc.elements.each("composantes/include") do |include|
      file=include.attributes["file"]
      sentinellev2(PATH+file,parent) 
    end
    
    
  end 
  
  
  def  self.sentinelleValues(composante,url)
    composante.children.each do |c|
      Importations::sentinelleValues(c,url)  
    end
    if composante.isLeaf?
      puts " => #{composante.fullname}"
      source="#{url}?tag=#{composante.fullname}"
      url = URI.parse(source)  
      open(url) do |f|
        
        Value.transaction do
            f.each_line do |valeur|
              a=valeur.strip().split("|")  
              next if a.count != 3
              #puts valeur
              t=a[0];u=a[1];v=a[2]
              Value.setComposanteValue(uid: u,
                                       composante: composante,
                                       valeur: v, source: "SentinelleV2")
           end
        end 
         
      end  
    end
  end
  
  
  def  self.sentinelleHistory(entity,composante,url)
    if composante==nil
      puts "Composante non trouve"
      return
    end
    
    # Récupération de uid du serveur en fonction de son TAG
    cuid=Master.serveurUidsForComposante(composante)
    vuid=Value.getValue(entity,cuid)
    if vuid!=nil
      uid=vuid.toutesLesValeurs().first  # On prende le premier
    else
      puts("Aucun serveur trouvé pour la composante #{composante.fullname}")
      return
    end

    

    # Ouverture de l'URL
    source="#{url}?tags=#{entity}@#{composante.fullname}&end=-1&start=-1"
    
    puts "#{source}"
    
    require 'open-uri'
    url = URI.parse(source)
    count=0
    # On y va
    open(url) do |f|
      
      Value.transaction do
      
        f.each_line do |valeur|
          count=count+1
          a=valeur.strip().split("|")
          t=a[0]
          v=a[1]
          vh=ValueHistory.new(uid: uid, masteruid: entity,etat:Value::OK,nberreurs:0,
                              source: "SentinelleV2",
                              message:"",
                              valeur:v)
                              
          vh.composante=composante
          vh.created_at=Time.at(a[0].to_i/1000)
          vh.save
         end
         
      end
      
      puts " => #{count} valeurs importées"
      
      #puts "response: #{response.inspect}"
    end
  end
  
  
  def  self.dicos(dir,parent)
    
    if ! File.directory?(dir)
      puts " => #{dir} n'est pas un dossier, on ne fait rien"  
      return  
    end
    
    puts "Importation du dossier de dicos : #{dir} dans #{parent.fullname}" 
    
    @files = Dir.glob("#{dir}/*.xml").sort_by {|s| s}
    for file in @files
      dico(file,parent)
    end
    
    
  end
  
  
  def  self.dico(filename,parent)
    
    if ! File.exist?(filename)
      puts " => Fichier #{filename} introuvable, on ne fait rien"  
      return 
    end
    
    #puts "Importation du dico : #{filename} dans #{parent.fullname}" 
    
    if ! parent.isWritable? 
      puts "Composante non accessible en écriture"
      return
    end
    
    require "rexml/document"
    
    file = File.new( filename )
    doc = REXML::Document.new file
    doc.elements.each("creole/variables/family") do  |element| 
      
      # Si caché on ne les intègre pas
      # next if element.attributes["hidden"]=='True'
       
      expert=element.attributes["mode"] == "expert"
      
      familly=element.attributes["name"]
      if parent.children.exists? :tag => familly
        folder=parent.getComposante( familly )
      else
        folder=Composante.create(:tag => familly,:expert => expert, 
                                 :name => familly,:parent_id => parent.id, 
                                 :categorie => Composante::FOLDER)
      end
      
      element.elements.each("variable") do |variable|
        # Si caché on ne les intègre pas
        next if variable.attributes["hidden"]=='True' 
        
        tag="conf_"+variable.attributes["name"]
        expert=variable.attributes["mode"] == "expert"
        #puts tag
        
        type=variable.attributes["type"]
        if parent.children.exists? :tag => tag
          c=parent.getComposante( tag )
          c.name=tag
          c.description=variable.attributes["description"]
          c.expert=expert
          c.categorie=type
          c.save
        else
          c=Composante.create(:tag => tag, 
                              :name => tag,
                              :description => variable.attributes["description"],
                              :expert => expert,:categorie => type,
                              :parent_id => folder.id)
        end
        
      end
      
      
    end
      
   #User.current=Group.admin;include Importations ; Importations::dico("data/importations/30_amon.xml",Composante.find_by_tag("infosetabs"))
    
    
    
    
  end


  def self.csv (file,sep=";",columns="",firstHasHeader=false,checkIfKeyExiste=false)

    if ! User.current.admin?
      resp=Utils::Response.new
      resp.error "Vous n'êtes pas autorisé à effectuer cette action"
      return resp
    end

    if ! File.exist?(file)
      resp=Utils::Response.new
      resp.error "#{file} n'existe pas"
      return resp
    end

    bNewEtabAdded=false

   Value.transaction do

    puts "Importation de #{file}"
    puts "Colmuns: /#{columns}/"

    ckey,index_ckey,composantes=getComposantes(columns,",")  if  columns!=""
    puts composantes
    puts "key: #{ckey} indice:#{index_ckey}"

    resp=Utils::Response.new


    File.open(file, "r") do |aFile|

          ckey,index_ckey,composantes=getComposantes(aFile.readline.strip!,sep)  if  composantes==nil
          if ckey==nil
            resp.error "Pas de Composante principale trouvée"
            puts "Pas de Composante principale trouvée"
            break
          end

          source="Import CSV de <user>#{User.current.uid}</user>"


          ligne=1
          # Chaque ligne
          aFile.each_line do |line|
            line.strip!

            # 1ere ligne contient le header, on ne traite pas
            if ligne==1 and firstHasHeader
               ligne=2
              next
            end

            ligne=ligne+1
            values=line.split(sep)
            masteruid=nil

            values[index_ckey].strip!

            # Mémorisation du masteruid, si la clef est dans Master
            if ckey.inMaster?
              masteruid= values[index_ckey]
            end

            # Pour chauqe colonnes
            (0..values.size-1).each do |i|

              vE=Value.find_by_uid_and_composante_id(values[index_ckey] , ckey.id)

              if  checkIfKeyExiste  and vE == nil
                err="L'entrée #{ckey.fullname}=[#{values[index_ckey]}] ligne(#{ligne}) n'a pas été trouvée"
                puts err
                resp.error err
                break
              end

              # Si nouvelle valeur
              bNewEtabAdded=true if vE==nil

              resp=Value.setValue(ckey: ckey, ckeyvalue: values[index_ckey],
                                       composante: composantes[i], value: values[i],source: source, masteruid:masteruid )
              
              if  resp==nil || resp.error?
                m=resp.message
                resp.message="Ligne #{ligne} (#{line})"
                break
              end
            end # End each

            break if  resp.error?

          end # End each line
    end # End File.open

   end # End transaction

    if ! resp.error?
      include Entities
      Entities::clearAll()
      if  bNewEtabAdded
        resp.code=Response::NEW_KEY
      end

    end

    resp


  end



end
