# -*- coding: utf-8 -*-
module Notifications

  include Rapports

  class NotificationData
    attr_accessor :expression,:days,:hour_first,:hour_last,:frequence_in_minutes ,  :actif ,:groupedSize,:individual,:lastCheck

    def initialize()
      self.actif=false
      self.expression="false"
      self.days=[Time.new.wday.to_s]
      self.hour_first=0
      self.hour_last=23
      self.frequence_in_minutes=60
      self.groupedSize=3
      self.individual=true
      self.lastCheck=nil
      @notifiers={}
    end

    def now?

      now=Time.new
      return :not_day if ! days.include? now.wday.to_s  # est-ce le jour ?

      return :not_hour if hour_first >now.hour or hour_last<=now.hour  # Dans la bonne heure ?

      now=now.utc
      percent=0
      # lastCheck est en UTC
      if lastCheck!=nil
         percent = ( (now-lastCheck) /  (frequence_in_minutes * 60)  )
         return "not_frequence  #{percent}" if   percent  <= 0.9
      end

      puts "yes, is for now p=#{percent.round(3)} lastCheck=#{lastCheck} now=#{now} fq=#{frequence_in_minutes} diff=#{now-lastCheck}"    if lastCheck


      return :ok

    end


    def notifiers
      @notifiers
    end

    def setNotifier(notifier)
      @notifiers[notifier.type.to_sym]=notifier
    end

    def getNotifier(type)
      return @notifiers[type.to_sym] if @notifiers.include? type.to_sym
      return Notifier.new
    end

    def initMessages(notification)
      @notifiers.each do |type,notifier|
        next if !  notifier.userActif?
        notifier.initMessage(notification)
      end
    end

    def buildMessages(entity,erb)
      @notifiers.each do |type,notifier|
        next if !  notifier.userActif?
        notifier.buildMessage(entity,erb)
      end
    end

    def notify()
      @notifiers.each do |type,notifier|
        next if !  notifier.userActif?
        notifier.notify()
      end
    end

  end

  # Collector ==================================
  class Collector
    def initialize(notification,data)
      @data=data
      @notification=notification
    end

    def createMessage
      m=Message.new(:entity => entity,
                     :objet  => objet,
                     :message=> message,
                     :nuid   => @notification.notificationuid,
                     :expression =>  @notification.data.expression,
                     :categorie=> eval("Message::#{type.upcase}") )
      m.user=User.current
      m.notification=@notification
      m.save
      m
    end

    def get(p)
      return @data[p] if  @data.include? p
      return ""
    end

    def type
      get "type"
    end

    def objet
      get "objet"
    end

    def message
      get "message"
    end

    def entity
      get "entity"
    end

  end
  # ===============================================

  class Notifier

    attr_accessor :parameters

    def initialize(*params)
      @parameters={}
    end

    def userActif?
      User.current.profile.hasNotifier? type
    end

    # Initiatisation des compilations des parametres
    def initMessage(notification)
      @compiled={}
      @evaluated={}
      @notification=notification
      @all=[]
      @parameters.each do |key,value|
        result=Rapports::FiltreData.compile(value.gsub('"',"'"),false)
        #puts "#{key} #{result}"
        @compiled[key]=result
      end
      #puts "-------------"
    end

    # Evaluation des parametres
    def buildMessage(entity,erb)
      #puts "E-------------"
      evaluated={"entity" => entity}
      @parameters.each do |key,value|
        evaluated[key]=Rapports::FiltreData.evaluation(entity,"",nil,@compiled[key],erb)
        #puts "#{key} #{evaluated[key]}"
      end
      @all<< Collector.new(@notification,evaluated)
      #puts "-------------"
    end


    def notify()
      return if !actif?

      # Création de l'objet qui sera capable de traiter le notifier
      begin
        o=Notifications.const_get(type.capitalize+"Sender").new
      rescue
        puts "No object to #{type.capitalize}Sender"
        return
      end

      o.send(self,notification.data.groupedSize.to_i<all.size)

    end

    def notification
      @notification
    end

    def all
      @all
    end

    def setParameters(params)
      @parameters=params
    end

    def actif?
      Value.to_bool(@parameters["actif"])
    end


    def get(p)
      return @parameters[p] if  @parameters.include? p
      return ""
    end

    def type
      get "type"
    end

    def objet
      get "objet"
    end

    def message
      get "message"
    end

    def script
      get "script"
    end

    def args
      get "args"
    end


  end


  class AbstractSender

    def init(notifier)
      @notifier=notifier
    end



  end

  # MAIL ========================================
  class MailSender  <  AbstractSender

    def mail(objet,message,copy=nil)
      puts "----------------------------------"
      puts "Sujet:#{objet}"
      #puts "Message:#{message}"
      puts "----------------------------------"
      UserMailer.notify(objet,message,@notifier.notification,copy)
    end

    def send(notifier,grouped=false)
      init(notifier)

      if grouped && notifier.get("cc").empty?

        message="Voici les notifications groupées <br><br>"
        entities=[]
        notifier.all.each do |collector|
          message<<"<div style='padding:5px; border:1px solid black; margin:5px; border-radius:5px; -moz-border-radius:5px;'>"
          message<<"<b>Sujet:</b> #{collector.objet}<br>"
          message<<"<b>Message:</b> <br>#{collector.message}"
          message<<"</div>"
          entities<< collector.entity
        end
        m=notifier.all.first.createMessage()
        m.message=message
        m.entity= entities.join(",")
        m.objet=m.entity
        m.save
        #UserMailer.notify(m.objet,message).deliver
        mail(m.objet,message)

      else

        notifier.all.each do |collector|
          collector.createMessage()
          mail(collector.objet,collector.message,collector.get("cc"))
          #UserMailer.notify(collector.objet,collector.message).deliver
        end

      end




    end


  end
  # ===============================================


  # Script ========================================

  class ScriptSender  <  AbstractSender


     # A FAIRE
    def launch(id,script,args)

      scriptname="data/scripts/notification-#{id}"
      File.open(scriptname, "w") do |f|
        f.write(script)
      end

      inperpreteur=ScriptData.getInterpreteur(src.split("\n").first)
      cmd=[inperpreteur, "#{scriptname}"]
      cmd.concat(args.split(";"))
      cmd<< " 2>&1"
      cmd=cmd.join(" ")
      output=IO.popen(cmd,"w+").read
      output.encode!('UTF-8', 'UTF-8', :invalid => :replace)
      output
    end

    def send(notifier,grouped=false)
      init(notifier)

      # Que les gens qui sont admin ont le droit de mettre en place des scripts
      if  ! notifier.notification.owner.admin?
        return
      end

      notifier.all.each do |collector|
        m=notifier.all.first.createMessage()
        script= collector.script
        output=launch(notifier.notification.id,script,args)
        m.message=output
        m.save

      end

    end


  end
  # ==============================================================



  # Popup =========================================
  class PopupSender  <  AbstractSender

    def popup(objet,message)
      puts "----------------------------------"
      puts "Sujet:#{objet}"
      puts "Message:#{message}"
      puts "----------------------------------"
    end

    def send(notifier,grouped=false)
      init(notifier)

      if grouped


        message=""
        entities=[]
        notifier.all.each do |collector|
          message<<"#{collector.message}"
          message<<"\n"
          entities<< collector.entity
        end


        # Si c'est un group on envoi un popup pour chaque User
        if User.current.group?
          theUser=User.current
          groupe=Group.find(theUser.id)
          groupe.users.each do |u|
            User.current=u
            m=notifier.all.first.createMessage()
            m.message=message
            m.entity= entities.join(",")
            m.objet=m.entity
            m.save
          end
          User.current=theUser
        else
          m=notifier.all.first.createMessage()
          m.message=message
          m.entity= entities.join(",")
          m.objet=m.entity
          m.save
        end
      else

        notifier.all.each do |collector|
          # Si c'est un group on envoi un popup pour chaque User
          if User.current.group?
            theUser=User.current
            groupe=Group.find(theUser.id)
            groupe.users.each do |u|
              User.current=u
              message=collector.createMessage()
            end
            User.current=theUser
          else
            message=collector.createMessage()
          end
        end

      end

    end


  end

  # ===============================================


end