# -*- coding: utf-8 -*-
# encoding: utf-8

module Rapports
  
  include Engine
  include ActionView::Helpers::NumberHelper
  require 'erb'

  class Data

    def initialize(v)
      @value=v
    end

    def value
      @value
    end


  end

  # Data ==========================
  class BatchData

    STOPED=:STOPED
    RUNNING=:RUNNING
    PENDING=:PENDING


    attr_accessor :message , :started_at, :ended_at ,:etat  ,:percent,:statut,:filtre,:count,:filtreid,:colonnes,:hidden

    def initialize()
      self.message=""
      self.started_at=nil
      self.ended_at=nil
      self.etat=STOPED
      self.percent=0
      self.filtre="true"
      self.statut={}
      self.filtreid=-1
      self.hidden=false
    end

    def setCurrent(etab)
      self.message=etab.to_s
    end

    def setPercent(percent)
      self.percent=percent
    end

    def start
      self.started_at=Time.now
      #self.message="Démarrer...."
      self.etat=RUNNING
      self.percent=0
    end

    def stop
      self.ended_at=Time.now
      self.etat=STOPED
      #self.message="Arreté le #{self.ended_at}"
      self.percent=0
    end

    def break
      self.etat=PENDING
      #self.message="Stop demandé le #{Time.now}"
    end


  end
  # ===========================================


  # Script ============================================
  class ScriptData
    attr_accessor :language, :usage, :script 
    attr_accessor :serveurs, :byserver
    
    PYTHON="python"
    SHELL="shell"
    LANGUAGES=[SHELL,PYTHON]

    def initialize()
      self.language=SHELL
      self.usage=""
      self.script=""
      self.serveurs=[]
      self.byserver=false
    end
    

    
    def findLanguage(line)
      self.language= ScriptData.getLanguage(line)
    end
    
    # Retourne l'interpreteur d'un script
    # la 1er ligne d'un script commence par #!
    # Ex: #!/bin/sh
    def self.getInterpreteur(line)
      line.gsub("#!","")  
    end

    def self.getLanguage(line)

      LANGUAGES.each do |l|
        if line.include? l
          return l
          break
        end
      end
    end
    
  end
  # ====================================================
  
  
  class FiltreData
    
    attr_accessor :selected, :pictogramme, :expression , :groupe, :composantes 

    def initialize()
      self.selected=true
      self.pictogramme="MapMarker/MapMarker_Marker_Outside_Azure.png"
      self.expression="true"
      self.groupe="Tous"
      @error=""
    end
    
    def error?
      @error != "" 
    end
    
    def error=(s)
      @error=s
    end
    
    def error
      @error
    end

    # ===========================================================
    # Retourne toutes les composantes du filtre
    def self.compile(expression,bQuote=true)
      compiled=expression
      ret=[]
      valid=false
      a=expression.scan(/{([0-9,A-Z,a-z,.,-,_,:,~,\/]*)}/)
      valid=true if a.count==0
      a.each do |c|

        comp=Composante.getComposanteFromFullname(c[0],true)
        if comp==nil || !comp.isReadable?
          puts "'#{c[0]}' composante invalide #{comp}"
          next
          #return {composantes: [],compiled: "'#{c[0]}' composante invalide", valid: false}
        end
        valid=true
        rep='#{Engine::Kernel.b('+"#{comp.id}" + ')}'
        if c[0] =~ /.*:.*/
          # Exemple : SCRIBE./home:available
          func=c[0].split(":")[1]
          # Example : func=available

          # Fonctions specifiques
          if func=="nberreurs" || func=="updated"  || func=="statut" || func=="since"
            rep='#{Engine::Kernel.' + "#{func}" +   '('+"#{comp.id}" + ')}'   # Ex: Engine::kernel.since(comp.id)
          elsif  func=="tag"  || func=="name"
            rep=comp.tag if func=="tag"
            rep=comp.name if func=="name"
          elsif func=="format" || func=="human"
            rep='#{Engine::Kernel.' + "#{func}" +   '('+"#{comp.id}" + ',"'+  "#{comp.categorie}" + '","'+  "#{comp.tag}" + '","'+  "#{comp.unit}"   + '")}'

          # Traitement par défaut si ce n'est pas une valeur spécifiques
          # va donc récupérer 'l'extra" dans la base de données
          else
            rep='#{Engine::Kernel.extra('+"#{comp.id}"+','+ "'#{func}'" +  ')}'
          end

        end
        
        #if ! comp.default.is_a? String
        #   rep='"#{Engine::Kernel.b('+"#{comp.id}" + ')}".to_i'  
        #end

        if bQuote
          compiled=compiled.gsub('"{'+c[0]+'}"','"'+rep+'"')
          compiled=compiled.gsub('{'+c[0]+'}','"'+rep+'"')
        else
          compiled=compiled.gsub('{'+c[0]+'}',rep)
        end
        compiled=compiled.gsub("[%","<%").gsub("%]","%>")

        ret<<comp
      end

      # Unification des composantes
      mapComposantes=[]
      ret.each do |c|
        mapComposantes<<c.id if ! mapComposantes.include?(c.id)
      end

      {composantes: mapComposantes,compiled: compiled, valid: valid}
    end

    
    
    def composantes2
      data=FiltreData.compile(expression)
      @compiled=data[:compiled]
      @valid=data[:valid]
      @composantes=data[:composantes]
      @values={}
      return data[:composantes]
    end
    
    def self.boxEval(uid,compiled,values,bCheckReadable=true,erb=false)
      u=User.current
      t=Thread.start {
               User.current=u
              if bCheckReadable
                Thread.current[:values]=values.delete_if { |v| v.composante==nil || !v.composante.isReadable?}
              else
                Thread.current[:values]=values
              end
              Thread.current[:entities]={}
              Thread.current[:entities][uid]={}
              r=compiled
              $SAFE=5
              begin
                e=eval(r)
                e=false if e==nil

              rescue Exception => exc
                begin
                   e=exc.to_s + compiled
                rescue
                   e= exc.to_s
                end
              end
              e
               #output
       }
      if erb
        begin
          renderer = ERB.new(t.value)
          return Rapports::Data.new(renderer.result())
        rescue Exception =>exc
          return Rapports::Data.new(exc.to_s)
        end
      else
        t
      end
       
    end


    def self.getValues(entity,composantes)
      data=composantes.map{ |x| "{#{x}}" }
      data=data.join "|"
      return FiltreData.evaluation(entity,data).split("|")

    end


    def self.evaluation(entity,data,uid=nil,result=nil,erb=false)
      #Compilation
      result=FiltreData.compile(data.gsub('"',"'"),false)  if result==nil
      if result.empty?
        return "ERROR"
      end

      if ! result[:valid]
        return result[:compiled]
      end

      if  result[:composantes].empty?
        return result[:compiled]
      end

      # Récupérations des composantes
      #mapComposantes=[]
      #result[:composantes].each do |c|
      #  mapComposantes<<c.id if ! mapComposantes.include?(c.id)
      #end

      # Récupération dans la base de toutes les valeurs
      conditions=[ "composante_id in (?) AND masteruid = ? ",result[:composantes],entity ]
      #conditions=[ "composante_id in (?) AND masteruid = ? AND uid = ? ",mapComposantes,entity,uid ] if uid != nil
      values=Value.all( :conditions=> conditions)
      t=FiltreData.boxEval(entity,'"'+result[:compiled]+'"',values,true,erb)

      return t.value
    end
        
      
    
    def self.evaluer(uid,compiled,values,bCheckReadable=true)
       FiltreData.boxEval(uid,compiled,values,bCheckReadable)
    end

    
    def compute(uid,values,bCheckReadable=true)
       #puts "FiltreData:compute entities.each #{uid} #values=#{values.count}"
       t=FiltreData.evaluer(uid,@compiled,values,bCheckReadable)
       t.value
       #puts "FiltreData:end compute"

       if t.value.is_a? String
          @error=t.value
          return nil
       else
         @error=""
         t.keys.each do  |k|
          @values[k]=t[k] if  k[0, uid.length] == uid
         end
         return t.value
       end
      
    end
    
    def values
      @values
    end

    def valid?
      @valid
    end
    
    def compiled
      @compiled
    end

    def compiled=(compiled)
      @compiled=compiled
    end

    def composantes=(composantes)
      @composantes=composantes
    end

    def valid=(valid)
      @valid=valid
    end
    
    
    #===============================================================

    def evaluer(entity_uid)

      if compiled == nil
        return FiltreData.evaluation(entity_uid,expression)
      end

      # TODO CODE : A VALIDER
      # Récupération dans la base de toutes les valeurs
      #puts "COMPILED:#{compiled} composantes:#{composantes}"
      conditions=[ "composante_id in (?) AND masteruid = ? ",composantes,entity_uid ]
      values=Value.all( :conditions=> conditions)
      #puts "VALUES:#{values.first.valeur}" if !  values.empty?
      t=FiltreData.boxEval(entity_uid,''+compiled+'',values)
      return t.value


     # return FiltreData.evaluation(entity_uid,expression)

      # A priori le code ci-dessous n'est plus nécessaire si la ligne au dessus est validée
      r=expression
      a=expression.scan(/{([0-9,A-Z,a-z,.,-,_,:,~,\/]*)}/)
      a.each do |c|
          #valeur=Value.getValue(entity_uid,Composante.getComposanteFromFullname(c[0]))
          value=Value.getValueFromFullname(entity_uid,c[0])
          if value == nil
            return false #Value::NOTEXIST
          elsif (value.is_a? String) && (value == Value::FORBIDDEN || 
                                         value == Value::NOTFOUND || 
                                         value == Value::NOTEXIST)
            return value
          end
          
          r=RapportColumn.remplacer(r,c[0],value)

           
      end
      
      #puts ("==== ==== EVALUER #{expression} => #{r} ")
       
         t=Thread.start {
              $SAFE=4
              begin
                e=eval(r)
                return false if e==nil

              rescue Exception => exc
                e=exc.to_s 
              end
              e
         }
       
       return false if t.value==nil
       #puts "#{expression} => #{r} = #{t.value} #{t.value.methods}"
       if t.value.is_a? String
          #puts "OO"
          @error=t.value
          #puts "#{expression} => #{r} = #{t.value} [#{@error}]"
          return nil
       else
         @error=""
         return t.value  
       end
       
       
       #puts "#{expression} => #{r} = #{t.value}"
       #t.value
       
    end
    
  end
  
  # ====================================================================================
  # Classe permettant de gérer les colonnes d'un rapport 
  class RapportColumn
    attr_accessor :nom, :format, :id


    TAG_SYNTAX=/{([0-9,A-Z,a-z,.,-,_,:,~,\/]*)}/

    # Le format est une composante accessible en modification
    def editable?
      if format =~ /^"?{[0-9,A-Z,a-z,.,-,_,:,~,\/]*}"?$/
        a=format.scan(TAG_SYNTAX)
        composante=Composante.getComposanteFromFullname(a[0][0],true)
        return false if composante==nil
        return composante.isModifiable?
      end
      false
    end
    
    def compiled
      @compiled
    end
    
    def valid?
      @valid
    end


    def compute2(entity,values)
      t=FiltreData.boxEval(entity,compiled,values,false)
      t.value
    end

    def composantes2
      # Compilation
      #.gsub(/^"{/,"{").gsub(/}"$/,"}").gsub('"',"'")
      result=FiltreData.compile(format,true)
     # FiltreData.compile(data.gsub('"',"'"),false)
      if result.empty?
        self.compiled="Erreur lors de la compilation"
        puts "Erreur lors de la compilation de [#{format}]"
        @valid=false
        return []
      end

      puts "Compilation de #{format} => #{result}"

      @valid=true
      @compiled=result[:compiled]
      return result[:composantes]
    end
    
    # Retourne toutes les composantes de la colonne
    def composantes

      @compiled=format
      @valid=false
      ret=[]
      a=format.scan(/{([0-9,A-Z,a-z,.,-,_,:,~,\/]*)}/)
      @valid=true if a.count==0
      a.each do |c|
        comp=Composante.getComposanteFromFullname(c[0],true)
        if comp==nil || !comp.isReadable?
          return []
        end
        @valid=true
        @compiled=@compiled.gsub("{"+c[0]+"}",'#{a('+"#{comp.id}" + ')}')
        ret<<comp
      end
      ret
    end
    
    # Méthod appleé lors de l'évaluation
    #def a(id)
    #  value=Thread.current[:values].select { |v| v.composante_id == id }
    #  return Value::NOTEXIST if value==nil || value==[]
    #  value.last.valeur
    #end

    # Calcule la colonne
    #def compute(values)
    #  begin
    #      Thread.current[:values]=values
    #      return      eval(@compiled)
    #    rescue Exception => exc
    #      return "n/a<hidden>#{exc}</hidden>"
    #  end
    #end
    
    def composante
      if format =~ /^"?{[0-9,A-Z,a-z,.,-,_,:,~,\/]*}"?$/
        a=format.scan(TAG_SYNTAX)
        composante=Composante.getComposanteFromFullname(a[0][0])
        return composante
      end
      nil
    end

    #def formater(entity_uid)
    #  RapportColumn.formater(entity_uid,format)
    #end
    
    
    #def self.formater2(entity_uid,format,evaluer=true,composante=nil,currentValue=nil,masteruid=nil)
    #   Engine::Kernel.render(entity_uid,format)
    #end
    
   

    def self.formater(entity_uid,format,evaluer=true,composante=nil,currentValue=nil,masteruid=nil)

     #puts "FORMAT:#{format} "

      if format.first=="="
        format = format[1..-1]
        evaluer=true
      end

      r=format
      a=format.scan(TAG_SYNTAX)
      a.each do |c|

        if c[0].first=="~"
          c[0] = c[0][1..-1]
          appformatter=true
        end

        value=Value.getValueFromFullname(entity_uid,c[0],composante,currentValue,masteruid)
       
        if appformatter
          if value!=nil && value.is_a?(Value)
            r=RapportColumn.remplacer(r,"~"+c[0],value.format())
          else
            r=RapportColumn.remplacer(r,"~"+c[0],value)
          end
        else
          r=RapportColumn.remplacer(r,c[0],value)
        end

      end
      # Demande d'évaluation de l'expression
      if evaluer
        begin
          t=Thread.start {
            $SAFE=4

            eval(r)
          }
          #puts "#{format} => #{r} = #{t.value}"
          r=t.value
        rescue Exception => exc
          puts "#{format} => #{r}"
          return false
        end 
      end # Fin d'évaluation
      
      r

    end

    def self.remplacer(r,sujet,value)
      
      if value == nil
        v=Value::NOTEXIST
      elsif value.is_a? String
        v=value
      elsif value.is_a? Integer
        v=value.to_s
      else
        v=value.valeur
      end
      ret=r.gsub("{"+sujet+"}",v)
      #puts "[#{r}] /s{#{sujet}} /r[#{v}] =>[#{ret}]"
      
      ret
    end

  end
  # ===========================================================================




end