module Zephir
  
    class << self
    
    def getUserRights(user,logger)
      logger.info ("ZEPHIR RIGHT start at #{Time.now}")
      cmd=["python","data/zephir/connect.py",
           "#{Appconfig.ZEPHIR_HOST}:#{Appconfig.ZEPHIR_API_PORT}",
           Appconfig.ZEPHIR_LOGIN,
           Appconfig.ZEPHIR_PASSWORD,user.zephir_uid]
      output=IO.popen(cmd,"w+").read
      
      groupes=[]
      entities=[]
      
      # Parse la sortie
      output.split("\n").each do |line|
        line.strip!
        next if line.first == "#"   
        if line =~ /addgroup:/
          groupes<< line.split(":")[1] 
        end
        if line =~ /rne=/
          entities=line.split(",") 
        end  
      end

      logger.info ("ZEPHIR RIGHT end at #{Time.now}")

      # --
      {groupes: groupes,entities: entities}

      
    end

  end
  
  
  def self.defaultProfil
    {groupes: [], entities: []} 
  end 
  

end