#!/bin/bash
# Version 1.0.0

SENTINELLE_HOME="/home/sentinelle"
SENTINELLE_APP="$SENTINELLE_HOME/alizes"
SENTINELLE_APP_LOCAL=$SENTINELLE_APP"-local"

RUBY_VERSION="2.0.0"

grep "~/.profile"  $SENTINELLE_HOME/.bash_profile
if [ $? -ne 0 ] ; then
    echo "source ~/.profile" >> $SENTINELLE_HOME/.bash_profile
fi

APT="sudo apt-get -q -y "


clear
echo "# ==============================================================="
echo "# Installation de Sentinelle On Rails (pour ubuntu >= 12.04)"
echo "# =============================================================== "
echo ""

function erreur
{
    echo "$1"
    exit
}

# Mise en place d'un dossier local (parametrage local)
if [ ! -d $SENTINELLE_APP_LOCAL ]; then
    mkdir $SENTINELLE_APP_LOCAL
    mkdir $SENTINELLE_APP_LOCAL"/config"
fi

# ===============================================================
echo "° Mise à jour des dépôts"
$APT  install curl pwgen >/dev/null


# Génération d'un mot de passe aléatoire pour mysql
# Evite a mysql de poser la question du choix de mot de passe root
MY=1
if [ ! -e /etc/init.d/mysql ]; then
  password=`pwgen 10 1`
  sudo debconf-set-selections <<< 'mysql-server-<version> mysql-server/root_password password $password'
  sudo debconf-set-selections <<< 'mysql-server-<version> mysql-server/root_password_again password $password'
  export DEBIAN_FRONTEND=noninteractive
  MY=0
fi


$APT  update > /tmp/update 2>&1
[ $? -ne 0 ] && erreur "La mise à jour des dépôts a échoué, plus de détails dans /tmp/update"
# ===================================================================

# ===================================================================
echo "° Installation des paquets (peut être long)"
$APT  install curl gawk libgdbm-dev libffi-dev build-essential openssl libreadline6 libreadline6-dev curl git-core\
 zlib1g zlib1g-dev libssl-dev libyaml-dev libsqlite3-dev sqlite3 libxml2-dev libxslt-dev\
 autoconf libc6-dev ncurses-dev automake libtool bison subversion\
 mysql-server libmysqld-dev imagemagick libmagick++-dev libsasl2-dev pwgen\
  libcurl4-openssl-dev apache2-prefork-dev apache2-mpm-worker >/tmp/install 2>&1
[ $? -ne 0 ] && erreur "L'installation des paquets a échoué, plus de détails dans /tmp/install"

if [ $MY -eq 0 ] ; then
 echo " -> Le mot de passe root de mysql a été stocké dans ~/.mysql_root_password"
 echo "$password" > ~/.mysql_root_password
fi

echo ""
# ===================================================================

# ===================================================================
# Installation de RVM: Ruby Version Manager
which rvm
if [ $? -ne 0 ] ; then
 echo "° Installation des RVM avec ruby $RUBY_VERSION (Le mot de passe root peut être demandé) "
 echo progress-bar >> ~/.curlrc
 curl -L get.rvm.io | bash -s stable  --ruby=$RUBY_VERSION  > /tmp/rvm
 [ $? -ne 0 ] && erreur "L'installation de rvm a échoué, plus de détails dans /tmp/rvm"
fi

source ~/.rvm/scripts/rvm && rvm requirements
echo ""
# ===================================================================

# ===================================================================
# Utilisation de ruby
echo "° Installation de ruby et rubygems"
rvm install $RUBY_VERSION --with-readline-dir=$SENTINELLE_HOME/.rvm/usr > /tmp/ruby
[ $? -ne 0 ] && erreur "L'installation de ruby a échoué, plus de détails dans /tmp/ruby"
rvm use $RUBY_VERSION --default  >/dev/null
rvm rubygems current  >/dev/null
# ===================================================================


# ===================================================================
echo "° Installation du bundler"
gem install bundler  >/tmp/bundler 2>&1
[ $? -ne 0 ] && erreur "l'installation du gem bundler a échoué, plus de détails dans /tmp/bundler"

# ===================================================================
echo "° bundle de Sentinelle (peut être long)"
cd $SENTINELLE_APP
bundle install  >/tmp/bundle 2>&1
[ $? -ne 0 ] && erreur "Le bundle de Sentinelle a échoué, plus de détails dans /tmp/bundle"

# ===================================================================
# Installation de passenger
echo "° Compilation de passenger pour apache2 (long)"
gem install passenger  >/tmp/gem_passenger
[ $? -ne 0 ] && erreur "Erreur lors de l'installation du Gem passenger, plus de détails dans /tmp/gem_passenger"

r=`rvm-prompt | sed 's/ruby-//g'`
p=`passenger-config  --version`

~/.rvm/gems/ruby-$r/gems/passenger-$p/bin/passenger-install-apache2-module -a  > /tmp/passenger.log 2>&1
#passenger-install-apache2-module -a  > /tmp/passenger.log 2>&1
if [ $? -ne 0 ] ; then
  echo "Echec de l'installation du module passenger"
  echo "consulter le log /tmp/passenger.log pour plus de détails"
  exit
fi

# ================================================================
# Génération d'une base de données
# ================================================================

sudo sed -i  's/skip-external-locking/skip-external-locking\ninnodb_file_per_table/' /etc/mysql/my.cnf


echo "[mysqld]
max_connections=400
innodb_file_per_table

" > /tmp/sentinelle.cnf
sudo cp /tmp/sentinelle.cnf /etc/mysql/conf.d/sentinelle.cnf

sudo service mysql restart   >/dev/null 2>&1

user="rails"
password=`pwgen 10 1`
sudo mysql --defaults-file=/etc/mysql/debian.cnf mysql -e "CREATE USER $user@localhost IDENTIFIED BY  '$password';" >/dev/null 2>&1
sudo mysql --defaults-file=/etc/mysql/debian.cnf mysql -e "GRANT ALL PRIVILEGES ON $user.* TO  $user@localhost IDENTIFIED BY  '$password' WITH GRANT OPTION MAX_QUERIES_PER_HOUR 0 MAX_CONNECTIONS_PER_HOUR 0 MAX_UPDATES_PER_HOUR 0 MAX_USER_CONNECTIONS 0 ;"
sudo mysql --defaults-file=/etc/mysql/debian.cnf mysql -e "CREATE DATABASE IF NOT EXISTS  $user;"

echo "production:
            adapter: mysql2
            pool: 200
            database: $user
            username: $user
            password: $password
            socket: /var/run/mysqld/mysqld.sock
            encoding: utf8

batches:
            adapter: mysql2
            pool: 10
            database: $user
            username: $user
            password: $password
            socket: /var/run/mysqld/mysqld.sock
            encoding: utf8

" > $SENTINELLE_APP"/config/database.yml"
cp $SENTINELLE_APP"/config/database.yml" $SENTINELLE_APP_LOCAL"/config/database.yml"

# =================================================================
# FICHERS DE CONFIGURATION
# =================================================================

# Génération de la configuration d'apache

PASSENGER=`passenger-config  --root`
MODULE=`passenger-config --includedir | sed 's/ext$//'`"buildout/apache2/mod_passenger.so"
RUBY=`passenger-config --ruby-command | grep "PassengerRuby" | grep wrappers | cut -d: -f2`
sudo bash <<EOF
echo "LoadModule passenger_module $MODULE" > /etc/apache2/conf.d/passenger.conf
echo "PassengerRoot $PASSENGER" >> /etc/apache2/conf.d/passenger.conf
echo "$RUBY"  >> /etc/apache2/conf.d/passenger.conf
EOF


# Génération de /etc/apache2/sites-available/sentinelle si non Eole
if [ ! -e /etc/eole/config.eol ] ; then
sudo echo "
PassengerMaxPoolSize 30
PassengerMaxInstancesPerApp 5
PassengerPoolIdleTime 3600
#RailsAutoDetect off
<VirtualHost *:443>
      ServerName sentinelle

      SSLEngine on
      SSLCertificateFile    /etc/ssl/certs/ssl-cert-snakeoil.pem
      SSLCertificateKeyFile /etc/ssl/private/ssl-cert-snakeoil.key

      DocumentRoot $SENTINELLE_APP/public
      <Directory   $SENTINELLE_APP/public>
         AllowOverride all
         Options -MultiViews
         PassengerUser sentinelle
         AddOutputFilterByType DEFLATE text/html text/css application/x-javascript application/javascript application/json
         <FilesMatch \"\\.(ico|pdf|flv|jpg|jpeg|png|gif|js|css|swf)\$\">
                ExpiresDefault \"access plus 10 years\"
         </FilesMatch>

      </Directory>

      <LocationMatch \"^/assets/.*$\">
          Header unset Last-Modified
          Header unset ETag
          FileETag None
          ExpiresActive On
          ExpiresDefault \"access plus 1 year\"
          Options +MultiViews +FollowSymLinks
       </LocationMatch>

      RailsBaseURI /

</VirtualHost>
" > /tmp/sentinelle
sudo cp /tmp/sentinelle /etc/apache2/sites-available/sentinelle
fi


sudo /usr/sbin/a2enmod  headers expires ssl >/dev/null
sudo chown -R sentinelle.www-data $SENTINELLE_APP
chmod -R 774 .

sudo rm -rf /var/www
sudo ln -s  $SENTINELLE_APP/doc /var/www
sudo chown -R sentinelle.www-data /var/www

chmod +x $SENTINELLE_APP/script/sentinelle

sudo /etc/init.d/apache2 restart   >/dev/null 2>&1
IP=`/sbin/ifconfig|grep inet|head -1|sed 's/\:/ /'|awk '{print $3}'`
echo ""
echo "Merci, pour cette installation"
echo "Veuillez consulter la documentation à cette adresse"
echo "   http://$IP "
echo "pour terminer l'installation et configurer Sentinelle"
echo ""

