# -*- coding: utf-8 -*-

include Importations
require 'openssl'
OpenSSL::SSL::VERIFY_PEER = OpenSSL::SSL::VERIFY_NONE

User.current=Group.admin
urlValuesSentinelleV2="https://172.31.185.246/sentinelle/interfaces/values4V3.php"
dossierImport="data/importations/include/reunion"
dsi3=Group.create(:nom => "", :prenom => "DSI3", :uid => "@DSI3", :dynamic => true )
dsi5=Group.create(:nom => "", :prenom => "DSI5", :uid => "@DSI5", :dynamic => true )

# Création du serveur Antivirus ========================================================
antivirus=Master.createServeur("officeScan","Antivirus")
antivirus.permission(Group.admin,Permission::WRITE)
antivirus.permission(dsi3,Permission::READ)
antivirus.permission(dsi5,Permission::READ)
antivirus.permission(Group.all,Permission::DENY)
Importations::sentinellev2("#{dossierImport}/antivirus.xml",antivirus)
c=Composante.find_by_fullname("officeScan.ipaddr")
c.flaguid=true; c.save
script=Importations::script("#{dossierImport}/scripts/officescan.sh",
                            "officescan.sh",
                            "Récupération des informations des serveurs Antivirus")
antivirus.serveurTask.update_attributes(:commande=>"#{script.id}",
                                        :tfrequence=>5,
                                        :tunit=>Serveur::MINUTE )
Importations::csv("#{dossierImport}/csv/officescanId.csv")
# ========================================================================================


# Création du routeur Equant =============================================================
obs=Master.createServeur("obs","OBS")
obs.permission(Group.admin,Permission::WRITE)
obs.permission(dsi3,Permission::READ)
obs.permission(dsi5,Permission::READ)
obs.permission(Group.all,Permission::DENY)
Importations::sentinellev2("data/importations/include/reunion/obs.xml",obs)
c=Composante.find_by_fullname("obs.id")
c.flaguid=true; c.save
script=Importations::script("data/importations/include/reunion/scripts/statsobs.sh",
                            "statsobs.sh",
                            "Récupération des informations des routeurs Equant")
obs.serveurTask.update_attributes(:commande=>"#{script.id}",
                                        :tfrequence=>5,
                                        :tunit=>Serveur::MINUTE )
Importations::csv("#{dossierImport}/csv/obsId.csv")
# ========================================================================================


# Serveur qui testera les connexions====================================================================
connexion=Master.createServeur("connexion","Connexion")
connexion.permission(Group.admin,Permission::WRITE)
connexion.permission(Group.all,Permission::READ)
Composante.create(:tag => 'id', :name => 'id',:parent_id => connexion.id, :flaguid => true)
tunnels =  Composante.create(:tag => 'tunnels', :name => 'Etat des tunnels',:parent_id => connexion.id, :categorie => Composante::FOLDER)
Composante.create(:tag => 'tunneladm', :name => 'Tunnel Administratif',:parent_id => tunnels.id, :categorie => Composante::STATUT)
Composante.create(:tag => 'tunnelpeda', :name => 'Tunnel Pédagogique',:parent_id => tunnels.id, :categorie => Composante::STATUT)
script=Importations::script("data/importations/include/reunion/scripts/connexions.sh",
                            "connexions.sh",
                            "Récupération de l'état des tunnels")
connexion.serveurTask.update_attributes(:commande=>"#{script.id}",
                                        :tfrequence=>5,
                                        :tunit=>Serveur::MINUTE ,
                                        :byetab => true,
                                        :arguments => "{AMON.conf_adresse_ip_eth1};{AMON.conf_adresse_ip_eth2}")                                       
# ========================================================================================


# Importations des composantes infosetabs de la V2
Importations::sentinellev2("data/importations/include/reunion/infosetabs.xml",Master.serveur)
# Récupération des dernières valeurs
puts "Récupération des valeurs de Sentinelle v2"
#Importations::sentinelleValues(Master.serveur,urlValuesSentinelleV2) 

Appconfig.GEN_ALLOW_GUEST="true"

Appconfig.CAS="true"
Appconfig.CAS_URL="https://seshat.ac-reunion.fr:8443"
Appconfig.CAS_ATTRIBUTE_GROUPE="groupe,profils"

Appconfig.CAS_USER_ONTHEFLY="true"
Appconfig.CAS_ATTRIBUTE_MANDATORY_NAME="source"
Appconfig.CAS_ATTRIBUTE_MANDATORY_VALUE="ACADEMIQUE"
Appconfig.CAS_ATTRIBUTE_NAME="nom"
Appconfig.CAS_ATTRIBUTE_FIRSTNAME="prenom"
Appconfig.CAS_ATTRIBUTE_MAIL="mail"


#Exemple de réponse CAS
#<cas:authenticationSuccess>
#<cas:groupe>DSI3</cas:groupe>
#<cas:displayName>Leon Christophe</cas:displayName>
#<cas:rne>9740049K</cas:rne>
#<cas:source>ACADEMIQUE</cas:source>
#<cas:user>cleon</cas:user>
#<cas:profils>National_7</cas:profils>
#<cas:mail>Christophe.Leon@ac-reunion.fr</cas:mail>
#<cas:auth>PASSWORD</cas:auth>
#</cas:authenticationSuccess>
#</cas:serviceResponse>


# Création d'autres utilisateurs
#r=User.create(:nom => "ROCHEFEUILLE", :prenom => "Florence", :uid => "frochefeuille")
#d=User.create(:nom => "DEROUETTE", :prenom => "Philippe", :uid => "derou007")
#s=User.create(:nom => "SOUNE-SEYNE", :prenom => "Nelly", :uid => "nsoune-seyne")
amon=Composante.find_by_fullname("AMON.AMON")
horus=Composante.find_by_fullname("HORUS.HORUS")
scribe=Composante.find_by_fullname("SCRIBE.SCRIBE")



c=Composante.find_by_fullname("infosetabs.PWD_SYSTEME")
c.permission(dsi3,Permission::MODIFY)
c.permission(Group.all,Permission::DENY)

c=Composante.find_by_fullname("infosetabs.PWD_AMON")
c.permission(dsi3,Permission::MODIFY)
c.permission(Group.all,Permission::DENY)

c=Composante.find_by_fullname("infosetabs.PWD_HORUS")
c.permission(dsi3,Permission::MODIFY)
c.permission(Group.all,Permission::DENY)

c=Composante.find_by_fullname("infosetabs.PWD_SCRIBE")
c.permission(dsi5,Permission::MODIFY)
c.permission(Group.all,Permission::DENY)


a=User.create(:nom => "AUBERVAL", :prenom => "Florent", :uid => "fauberval")
a.groups<<Group.manager

g=Group.create(:nom => "STJO",  :uid => "@STJO" )
g.users<<a
g.save

eple=Group.create(:nom => "EPLE", :uid => "@eple")
eple.groups<<Group.guest
eple.save

# =======================================================================


# Bassin d'éducation
ident =  Composante.find_by_fullname("infosetabs.identite")
Composante.create(:tag => 'bassin', :name => 'Bassin',
                  :description => "Bassin d'éducation et de formation", :parent_id => ident.id)


Importations::csv("data/importations/reunion_eple.csv")



Importations::sentinellev2("data/importations/include/reunion/AMONAgentsLocaux.xml",amon)

#Importation de l'historique de Sentinelle ====================================
url="https://172.31.185.246/sentinelle/interfaces/historiques4V3.php"

listeDesComposantesARecuperer=[
  "AMON.configlocal_pinger_195_98_232_10_avg","AMON.configlocal_pinger_195_98_232_10_min","AMON.configlocal_pinger_195_98_232_10_max","AMON.configlocal_pinger_195_98_232_10_loss",
  "AMON.configlocal_pinger_bull_avg","AMON.configlocal_pinger_bull_min","AMON.configlocal_pinger_bull_max","AMON.configlocal_pinger_bull_loss",
  "AMON.configlocal_pinger_metr_avg","AMON.configlocal_pinger_metr_min","AMON.configlocal_pinger_metr_max","AMON.configlocal_pinger_metr_loss",
  "AMON.configlocal_debitsadsl"
]

listeDesComposantesARecuperer.each do |c|
  c=Composante.find_by_fullname(c)
  #Importations::sentinelleHistory("9740001H",c,url)
  #Importations::sentinelleHistory("9741236A",c,url)
  #Importations::sentinelleHistory("9740069G",c,url)
  #Importations::sentinelleHistory("9740952S",c,url)
end

# ==============================================================================

# Création de filtres/vues  ===============================================

gAll=Group.all

puts "Création des vues"

vue=Vue.create
vue.nom= "Type d'établissements"
filtre=Filtre.create
filtre.nom= "Collèges"
filtre.expression='"{infosetabs.type}" == "CLG"'
filtre.pictogramme="MapMarker/MapMarker_Marker_Outside_Azure.png"
vue.filtres<<filtre
gAll.profile.filtres<<filtre

filtre=Filtre.create
filtre.nom= "Lycées"
filtre.expression='"{infosetabs.type}" == "LYC"'
filtre.pictogramme="MapMarker/MapMarker_Marker_Outside_Pink.png"
vue.filtres<<filtre
gAll.profile.filtres<<filtre

filtre=Filtre.create
filtre.nom= "Lycées Pro"
filtre.expression='"{infosetabs.type}" == "LP"'
filtre.pictogramme="MapMarker/MapMarker_Marker_Outside_Chartreuse.png"
vue.filtres<<filtre
gAll.profile.filtres<<filtre


gAll.profile.vues_active=[vue.id]
gAll.profile.save
vue.addRight(gAll,Permission::READ)

vue.save!
# ===========================================================================

puts "Création des filtres : BASSINS"

["EST","NORD","OUEST","SUD-EST","SUD-OUEST"].each do |b|
  puts "Bassin #{b}"
  filtre=Filtre.create(groupe: "Bassin" , nom: "Bassin #{b}", expression:"\"{infosetabs.bassin}\" == \"#{b}\"" )
  filtre.addRight(Group.all,Permission::READ)
end

#f=Filtre.create(groupe: "Type" , nom: "Collèges", expression:"\"{infosetabs.type}\" == \"CLG\"" )
#f.addRight(gAll,Permission::READ)

#f=Filtre.create(groupe: "Type" , nom: "Lycées", expression:"\"{infosetabs.type}\" == \"LYC\"" )
#f.addRight(gAll,Permission::READ)

#f=Filtre.create(groupe: "Type" , nom: "Lycées Pro.", expression:"\"{infosetabs.type}\" == \"LP\"" )
#f.addRight(gAll,Permission::READ)

# EPLE: Collèges, Lycées et Lycées Pro
feple=Filtre.create(groupe: "Type" , nom: "EPLE", expression:'"{infosetabs.type}" == "LYC" || "{infosetabs.type}" == "CLG" || "{infosetabs.type}" == "LP"' )


#fStDenis=Filtre.create(groupe: "Ville" , nom: "SAINT-DENIS", expression:"\"{infosetabs.ville}\" == \"SAINT-DENIS\"" )
#fPossession=Filtre.create(groupe: "Ville" , nom: "LA POSSESSION", expression:"\"{infosetabs.ville}\" == \"LA POSSESSION\"" )

# EPlE comme filtre par défaut
Appconfig.GEN_GUEST_FILTER=feple.id


#User.current=a
#Filtre.create(groupe: "Ville" , nom: "LES AVIRONS", expression:"\"{infosetabs.ville}\" == \"LES AVIRONS\"" )

