#!/bin/bash
# Version 1.0
# Script à lancer lors d'une mise a jour de l'appli
# TODO: tempaltiser config/database.yml

export RAILS_ENV=production
ALIZES=`pwd`
LOCAL=" $ALIZES-local"
GROUP="www-data"

function hook {
    SCRIPT="$LOCAL/scripts/$1.sh"
    [ -e $SCRIPT  -a -x  $SCRIPT   ] &&  $SCRIPT || true
}



hook "preUpdate"


echo "° Vérification des modules"
hook "preBundle"
bundle install >/tmp/modules
if [ $? -ne 0 ] ; then
   echo "Echec de l'installation des modules"
   echo "Plus d'info dans /tmp/modules"
   exit
fi
hook "postBundle"

sudo chown -R $USER.$GROUP $ALIZES
sudo chmod -R 774 .

echo "° Arrêt du serveur apache"
sudo /etc/init.d/apache2 stop >/dev/null 2>&1
sudo service mysql restart >/dev/null 2>&1

rm -rf public/*
rm -rf tmp/*
rm -rf log/*

if [ -e $LOCAL/config/database.yml ] ; then
   cp  $LOCAL/config/database.yml  $ALIZES/config/database.yml
fi

#ALTER TABLE  `rails`.`values` DROP INDEX  `index_values_on_uid_and_composante_id` ,
# ADD UNIQUE  `index_values_on_uid_and_composante_id` (  `uid` ,  `composante_id` ,  `masteruid` )

if [ ! -e $ALIZES/config/database.yml ] ; then
    echo "======================================================================================="
    echo "/!\\  Génération d'une configuration de base de données par défaut /!\\ "
    echo "Cette configuration par défaut ne correspond sans doute pas à votre environnement"
    echo "Veuillez donc editer et adapter $ALIZES/config/database.yml"
    echo "======================================================================================="
    echo "
    #Configuration par défaut, pensez à modifier les paramètres de connexion a votre base de données
    development:
      adapter: mysql2
      pool: 200
      database: rails
      username: rails
      password: rails
      socket: /var/run/mysqld/mysqld.sock
      encoding: utf8

    batches:
      adapter: mysql2
      pool: 10
      database: rails
      username: rails
      password: rails
      socket: /var/run/mysqld/mysqld.sock
      encoding: utf8

    production:
      adapter: mysql2
      pool: 200
      database: rails
      username: rails
      password: rails
      socket: /var/run/mysqld/mysqld.sock
      encoding: utf8
    " > $ALIZES/config/database.yml
fi

[ -e $LOCAL/config/database.yml  ] &&  cp -f $LOCAL/config/database.yml  $ALIZES/config/database.yml

hook "preCompileAssets"

echo "° Génération des ressources (peut être long)"
bundle exec rake assets:precompile >/tmp/compile 2>&1
if [ $? -ne 0 ] ; then
   echo "Echec de la compilation des assets"
   echo "Plus d'info dans /tmp/compile"
   exit
fi

ln -s  $ALIZES/doc/guide  $ALIZES/public/assets/guide
ln -s  $ALIZES/doc/installation  $ALIZES/public/assets/installation
# Copie du dossier handler dans l'arbo de la doc utilisateur
cp -r $ALIZES/doc/handler  $ALIZES/public/assets/guide

hook "preMigrateDatabase"

echo "° Migration des données"
rake db:migrate

hook "postMigrateDatabase"

sudo chown -R $USER.$GROUP $ALIZES
sudo chmod -R 774 $ALIZES
sudo chown $USER $ALIZES/config/environment.rb
sudo chown $USER $ALIZES/config.ru
sudo chmod -R g+s  $ALIZES/public
sudo chmod -R g+s  $ALIZES/tmp

sudo /etc/init.d/apache2 start


hook "postUpdate"
