
    // récupération de la lib Highcharts
	var highchartsOptions
	if (typeof(Highcharts) == "undefined" )
	{
		versionHC="3.0.2"
		urlHC="https://cdnjs.cloudflare.com/ajax/libs/highcharts/"+versionHC
		$.getScript( urlHC+"/highcharts.js",function( data, textStatus, jqxhr ) {
			$.getScript( urlHC+"/modules/exporting.js")
			$.getScript( urlHC+"/modules/data.js")
			$.getScript( urlHC+"/modules/annotations.js")
			InitialisationHighcharts();
		})
	} else
	{
	   InitialisationHighcharts();	
	}
    

    var mapSerieUnit=new Hashtable();
    var mapSerieString=new Hashtable();
    
    function InitialisationHighcharts()
    {
        Highcharts.theme=highchartsTheme
        Highcharts.setOptions({
              global : {
                  useUTC : false
              }
          });
        highchartsOptions = Highcharts.setOptions(Highcharts.theme);
    }

    function getComposantesGraphValues(url,composantes,dstart,dend,callback,exclude)
    {
    	var series=[]
        var yaxes=[]
        
        var composanteid="";
        if (typeof(composantes) == "string" )
        {
        	composanteid=composantes	
        } else
        {
        	composanteid=""
        	for (i=0;i<composantes.length;i++)
        	{
        		composanteid+="|"+composantes[i].composante;	
        	}	
        }
       
        datas={composanteid: composanteid,dstart:dstart,dend:dend}
        if (exclude != undefined)
        {
        	datas.exclude=exclude.join("|");	
        }

         $.ajax({
            url: url  ,
            data: datas,
            type: 'GET',
            success: function( json )
            {
            	
            	hYAxes=new Hashtable();
            	// Parcours toutes les séries
             	for (i=0;i<json.length;i++)
             	{
             		jsonserie=json[i];
             		data=[];strings=new Hashtable();
             		for (z=0;z<jsonserie.data.length;z++)
             		{
             			d=jsonserie.data[z]
             			data.push({x: d.timestamp,y: d.valeur, name: d.string});
						strings.put(d.timestamp,d.string)
             		}
             		mapSerieString.put(jsonserie.nom,strings);
             		
					// On renseigne la série
             		serie={name: jsonserie.nom,unit:jsonserie.unit ,type: jsonserie.type, color: jsonserie.color,  data: data}
             		series.push(serie);
             		mapSerieUnit.put(jsonserie.nom,jsonserie.unit);
             		
             		// Cet axe n'existe pas encore (Aucun axe correspondant a l'unité)
             		if (!hYAxes.containsKey(jsonserie.unit)) 
             		{
             			y={ 
	                		labels: { formatter: function() { return this.value +jsonserie.unit;},
	                    			  style: {color: '#89A54E'}
	                    			},
	                    	title: {text: jsonserie.legend,style: {color: '#89A54E'}},
	                		opposite: hYAxes.size()>1,
	                		plotBands: []
	            		};
	             		yaxes.push(y);
	            		hYAxes.put(jsonserie.unit,y)
	            	}
	            	
	            	if (jsonserie.plotband != undefined)
	            	{
	            		y=hYAxes.get(jsonserie.unit)
	            		y.minorGridLineWidth=0
                		y.gridLineWidth=0
	            		y.labels= {formatter: function() { return ""}}
	            		y.plotBands.push(jsonserie.plotband)
	            	} else
	            	{
	            		y=hYAxes.get(jsonserie.unit)
	            		y.min=0
	            	}
	            	
             	} // Fin du parcours des series
             	
             	callback(json,yaxes,series);
            }
        });
    }
    
    
    
    
    
    function RenderGraph(conteneur,titre,yaxes,series,options,loadedCallback)
    {
    	if ($("#"+conteneur).length==0) return;
        UIUnBlock(conteneur)
    	parametres={
            chart: {
                renderTo: conteneur,
                type: 'spline',
                marginRight: 20,
                zoomType: 'x',    
                spacingRight: 20,
                marginBottom: 25,
                animation: false,
                events: {
                	load: loadedCallback
            	}  
            },
            title: {
                text: titre,
                x: -20 //center
            },
            subtitle: {
                text:options.source ,
                x: -20
            },
            xAxis: {
                type: 'datetime',
                maxZoom: 1 * 1 * 3600000, // fourteen days
                title: {text: ""}
            },
            yAxis: yaxes,
            series: series,
            tooltip: {
                formatter: function() {
                		date=new Date(this.x);
                		valeur=mapSerieString.get(this.series.name).get(this.x);
                        return '<b>'+ this.series.name +'</b><br/>'+
                        '['+(date.format("dd/mm/yy HH:MM")) +']<br>'+ valeur + mapSerieUnit.get(this.series.name);
                }
            },
            credits: {
                enabled: false
            },
            plotOptions: {
            	scatter : {
                    pointWidth: 1,
                    lineWidth: 1,
            		dataLabels: {enabled: true,
            					 formatter: function() {
            					 	valeur=mapSerieString.get(this.series.name).get(this.x)
            					 	return valeur;	
            					  }
            				     }
            	},

                areaspline: {
                    fillOpacity: 0.5,
                    lineWidth: 1,
                    marker: {
                        enabled: false,
                        
                    }/*,states: {
                            hover: {
                                enabled: true
                            }
                     }   */
                },

                column: {
                    dataLabels: {
                        enabled: true
                    },
                    pointWidth: 30,
                    color:'#F00'
                },

                area: {
                    stacking: 'normal',
                    lineWidth: 1,
                    marker: {
                        enabled: false,
                       
                    },
                    shadow: false,
                   
                } ,
                line: {
                    lineWidth: 1,
                    marker: {
                        enabled: false,

                    }
                }
            },
            legend: {
 				layout: 'vertical',
                align: 'right',
                //x: 120,
                verticalAlign: 'top',
                y: 0,
                floating: true,
                backgroundColor: '#FFFFFF'
            },
             navigation: {
	            buttonOptions: {
	            	align: 'left',
	                height: 20,
	                width: 20,
	                symbolSize: 8,
	                symbolX:11,
	                symbolStrokeWidth: 1
	            }
        	},
            exporting: {
            	enabled: true,
            	 buttons: {
                	exportButton: {
                    	x: 2,y:2
                	},
                	printButton: {
                    	x: 24,y:2
                	}
            }
        	}
            
        };
        
        if (options.legende != undefined)
        {
        	parametres.legend.enabled=	options.legende;
        }
    	
    	
    	
    	
    	
    	chart = new Highcharts.Chart(parametres);
        return chart;
      }
      

	

