var markersArray = [];

function mapIsInitialized()
{
    return map!=null;
}

function addMarker(marker) {
  if (!mapIsInitialized()) return ;

  marker.setMap(map);
  markersArray.push(marker);
    google.maps.event.addListener(marker, 'dblclick', function(event) {
    	clearTimeout(update_timeout);
        onDblClickMarker(marker);
    });
    
    google.maps.event.addListener(marker, 'click', function(event) {
    	update_timeout = setTimeout(function(){
        	onClickMarker(marker);
    	}, 200); 
        
    });
    
    google.maps.event.addListener(marker, 'dragend', function() {
        onDragMarker(marker);
    });
}
/*
function removeMarker(marker) {
	marker.setMap(null);
	var i=markersArray.indexOf(marker);
	if (i!=-1) markersArray.remove(i);
}
*/
// Removes the overlays from the map, but keeps them in the array
function clearOverlays() {
  if (!mapIsInitialized()) return ;
  if (markersArray) {
    for (i in markersArray) {
      markersArray[i].setMap(null);
    }
  }
}

function nbMarker()
{
    return markersArray.length
}

// Shows any overlays currently in the array
function showOverlays() {
  if (!mapIsInitialized()) return ;
  if (markersArray) {
    for (i in markersArray) {
      markersArray[i].setMap(map);
    }
  }
}

// Deletes all markers in the array by removing references to them
function deleteOverlays() {
    if (!mapIsInitialized()) return ;
    if (markersArray) {
    for (i in markersArray) {
      markersArray[i].setMap(null);
    }
    markersArray.length = 0;
  }
}

function fitToAll()
{
    if (!mapIsInitialized()) return ;

    var bound = new google.maps.LatLngBounds();
    for(var i in markersArray)
    {
        bound.extend(markersArray[i].getPosition());
    }
    map.fitBounds(bound);
    map.setZoom( Math.min(16,map.getZoom()) );
}

function getZoom()
{
    if (!mapIsInitialized()) return 0;
    return map.getZoom();
}

function resizeMap()
{
    google.maps.event.trigger(map, 'resize');
}

function recenterMap()
{
    if (!mapIsInitialized()) return ;
	var bound = map.getBounds();
	if (bound == undefined) return 
	for(var i in markersArray)
    {
    	if (bound.contains(markersArray[i].getPosition()))
    	{
    		return;
    	}
    }
    fitToAll();

}

var timerMapZoomChanged=null;
function addZoomHandler()
{
    if (!mapIsInitialized()) return ;
    google.maps.event.addListener(map, 'zoom_changed', function() {
        // 3 seconds after the center of the map has changed, pan back to the
        // marker.

        if (timerMapZoomChanged!=null) return

        timerMapZoomChanged=setTimeout(function() {
            timerMapZoomChanged=null
            OnMapZoomChanged()
        }, 500);
    });
}
