. /usr/lib/eole/ihm.sh

MOUNT_DIR='/mnt/sauvegardes'
BACULA_DB='/var/lib/bacula/bacula.db'
BACULA_DB_SAV='/var/lib/bacula/bacula.db.sav'

if [ "$(CreoleGet activer_bacula_dir)" = "oui" ]; then
    #(re)generation du catalog
    rep=0
    if [ -e $BACULA_DB ]
    then
        Question_ouinon "La régénération du catalogue de bacula va écraser l'ancienne base, confirmez-vous ?" "$interactive" 'non' 'warn'
        rep=$?
    fi
fi

if [ "$rep" = "0" ]; then
        echo
        echo "## Régénération du catalogue Bacula (bacula.db)##"
        CreoleService bacula-director stop
        CreoleService bacula-sd stop
        CreoleService bacula-fd stop
        if [ -e $BACULA_DB ]; then
                mv -f $BACULA_DB $BACULA_DB_SAV
        fi
        # le script make_tables n'utilise pas le bon nom "db_name"
        rm -f /var/lib/bacula/XXX_DBNAME_XXX.db
        touch /var/lib/bacula/XXX_DBNAME_XXX.db
        /usr/share/bacula-director/make_sqlite3_tables
        mv -f /var/lib/bacula/XXX_DBNAME_XXX.db $BACULA_DB
        chown bacula: $BACULA_DB
        echo "Régénération du catalogue terminée"
        echo "Suppression des anciens rapports d'état."
        sleep 5
        rm -f /var/lib/bacula/*.state
        CreoleService bacula-director start
        CreoleService bacula-sd start
        CreoleService bacula-fd start
        echo "Anciens rapports d'état supprimés et services redémarrés."
fi
