# coding: utf-8
# from .action import describe as _describe, submit as _submit
from pyeole.bareos import bareos_active_dir, bareos_configured
from pyeole.lock import is_locked


def _verify_backupstate():
    if not bareos_active_dir():# bareos est inactif
        return {'message': {'text': 'Les sauvegardes Bareos sont désactivées dans le dictionnaire',
                'type': 'error'}}

    elif not bareos_configured(): # bareos n'est pas configuré
        return {'message': {'text': "Pensez à configurer Bareos avant toutes sauvegardes",
                'type': 'error'}}

    elif is_locked(name='eolesauvegarde', level='system'):
            # sauvegarde en cours
        return {'message': {'text': "Programmation de la sauvegarde impossible, une sauvegarde est en cours",
                'type': 'error'}}


def describe(*args, **kwargs):
    ret = _verify_backupstate()
    if ret is not None:
        return ret
    return __action__.describe(*args, **kwargs)


def submit(*args, **kwargs):
    ret = _verify_backupstate()
    if ret is not None:
        return ret
    return __action__.submit(*args, **kwargs)
