#!/usr/bin/python3
# -*- coding: utf-8 -*-
"""Restauration du catalogue de bareos (attention il faut savoir ce que l'on fait !)"""
from pyeole.bareosrestore import extract_bareos_files, bareos_restore_dump, \
        restore_file
from creole.loader import load_store
from sys import exit
from creole.client import CreoleClient
from pyeole.bareos import test_bareos_support


client = CreoleClient()


def execute(option, opt_str, value, parser, jobid, test_jobs=False):
    """catalog helper
    never test jobs
    """
    if client.get_creole('module_instancie') == 'non':
        print("Le serveur doit être instancié pour lancer cette commande")
        print("Peut-être voulez-vous utiliser l'option --configeol ?")
        exit(1)
    try:
        print("Test du support de sauvegarde")
        status, comment = test_bareos_support()
        if not status:
            print("Problème avec le support de sauvegarde détecté :")
            print(comment)
            exit(1)
    except Exception as err:
        print("Erreur à l'accès au support de sauvegarde")
        print(str(err))
        exit(1)
    if len(parser.rargs) > 0:
        option = parser.rargs[0]
        if option == 'pre':
            pre()
        elif option == 'post':
            post()
        else:
            print("Attention, il ne faut plus spécifier le nom du directeur Bareos")
            exit(1)
    else:
        job(jobid)

def pre():
    print("pre catalog")

def post():
    print("post catalog")

def job(jobid):
    print("Restauration du catalogue")
    try:
        extract_bareos_files()
        bareos_restore_dump()
    except Exception as e:
        print(e)
        exit(1)

priority=0

