# coding: utf-8
# from .action import describe as _describe, submit as _submit
from pyeole.bareos import bareos_active_dir, bareos_configured
from pyeole.lock import is_locked


def _verify_backupstate():
    if not bareos_active_dir():# bareos est inactif
        return {'message': {'text': 'Les sauvegardes Bareos sont désactivées',
                'type': 'error'}}

    elif not bareos_configured(): # bareos n'est pas configuré
        return {'message': {'text': "Configurer le support de sauvegarde de Bareos avant toutes sauvegardes",
                'type': 'error'}}

    elif is_locked(name='eolesauvegarde', level='system'):
            # sauvegarde en cours
        return {'message': {'text': "Sauvegarde en cours, programmation de la sauvegarde impossible",
                'type': 'error'}}


def describe(*args, **kwargs):
    ret = _verify_backupstate()
    if ret is not None:
        return ret
    __action__.form.append({'key': 'backuponce.sauvegarde.type',
                            'displayed': {'now': 'Sauvegarder maintenant',
                                          'later': 'Programmer une sauvegarde unique'}})
    __action__.form.append({'key': 'backuponce.sauvegarde.option',
                            'displayed': {'Full': 'Totale',
                                          'Differential': 'Différentielle',
                                          'Incremental': 'Incrémentale'}})
    return __action__.describe(*args, **kwargs)


def submit(*args, **kwargs):
    ret = _verify_backupstate()
    if ret is not None:
        return ret
    return __action__.submit(*args, **kwargs)
