# coding: utf-8
from glob import glob as _glob
from os.path import join as _join
from json import dumps as _dumps
from creole.client import CreoleClient as _CreoleClient

from pyeole.schedule import SCHEDULE_DIR as _SCHEDULE_DIR


def describe(*args, **kwargs):
    client = _CreoleClient()
    remoteclients = client.get_creole('bareos_dir_remote_fd_name')
    for remoteclient in remoteclients:
        __action__.form.append({'key': 'bareosremoteclient.job_{0}.job_type_{0}.job_type_{0}'.format(remoteclient),
                                'displayed': {"weekly": "hebdomadaire",
                                              "daily": "journalière",
                                              "monthly": "mensuelle"}})
        __action__.form.append({'key': 'bareosremoteclient.job_{0}.job_type_{0}.day_{0}'.format(remoteclient),
                                'displayed': {"1": "de dimanche à lundi",
                                              "2": "de lundi à mardi",
                                              "3": "de mardi à mercredi",
                                              "4": "de mercredi à jeudi",
                                              "5": "de jeudi à vendredi",
                                              "6": "de vendredi à samedi",
                                              "7": "de samedi à dimanche"}})
        __action__.form.append({'key': 'bareosremoteclient.job_{0}.job_type_{0}.end_day_{0}'.format(remoteclient),
                                'displayed': {"1": "de dimanche à lundi",
                                              "2": "de lundi à mardi",
                                              "3": "de mardi à mercredi",
                                              "4": "de mercredi à jeudi",
                                              "5": "de jeudi à vendredi",
                                              "6": "de vendredi à samedi",
                                              "7": "de samedi à dimanche"}})
        __action__.form.append({'key': 'bareosremoteclient.job_{0}.job_type_{0}.level_{0}'.format(remoteclient),
                                'displayed': {"Full": "totale",
                                              "Incremental": "incrémentale",
                                              "Differential": "différentielle"}})
    print(__action__.form)
    return __action__.describe(*args, **kwargs)


def submit(*args, **kwargs):
    return __action__.submit(*args, **kwargs)
