# Le variables suivantes sont a votre disposition : 
#
# SRC_APPS        : Répertoire des sources de l'application
# SRC_APPS_PLUGIN : Répertoires des plugins pour l'application
# SRC_APPS_LANG   : Répértoires des traductions
#

# Répertoires de destination

ifeq ($(PKGAPPS),oui)
#################
# Sanity checks #
#################
test -d $(SRC_APPS) || $(error $$(PKGAPPS) is enable but $$(SRC_APPS)='$(SRC_APPS)' does not exist)

APPS_DEST   := $(DESTDIR)/var/www/html/$(SOURCE)
LANG_DEST   := $(APPS_DEST)/lang
PLUGIN_DEST := $(APPS_DEST)/plugin
endif

install-apps-dirs:
ifeq ($(PKGAPPS),oui)
	test ! -d $(SRC_APPS)           || $(INSTALL_DIRECTORY) $(APPS_DEST)
	test ! -d $(SRC_APPS_LANG)      || $(INSTALL_DIRECTORY) $(LANG_DEST)
	test ! -d $(SRC_APPS_PLUGIN)    || $(INSTALL_DIRECTORY) $(PLUGIN_DEST)
endif

install-apps: install-apps-dirs
ifeq ($(PKGAPPS),oui)
	# Installation de l'application
	$(INSTALL_RECURSIVE) $(SRC_APPS)/* $(APPS_DEST)

	# Installation des répertoires de plugins
	$(call fc_install_file,$(INSTALL_RECURSIVE),$(SRC_APPS_PLUGIN),$(PLUGIN_DEST))

	# Installation des répertoires de traductions (lang)
	$(call fc_install_file,$(INSTALL_RECURSIVE),$(SRC_APPS_LANG),$(LANG_DEST))
endif


.PHONY: install-apps install-apps-dirs
