# -*- coding: UTF-8 -*-
#from os.path import join as os.path.join
import os, sys
sys.path.append('/usr/share/eole/client')

from twisted.python import log
from xml.etree import ElementTree as ET
from lxml import etree

#from creole import parsedico

import machines
from fnmatch import fnmatch
XMLDIR = "/home/esu/Base"

OS_XP = 252

WINOS = {
    'Lin22': 1024,  # Profile-eole 2.2
    'Win95': 128,  # Windows 95
  # 'Win98': 64,   # Windows 98
  # 'WinMe': 32,   # Windows Me
    'WinNT': 16,   # Windows NT4
    'Win2K': 8,    # Windows 2000
    'WinXP': 4,    # Windows XP
    'Vista': 2,    # Vista
    'Win2K3': 4    # Windows 2003
}

REG_TYPES = {
    'DWORD': 'REG_DWORD',
    'STRING': 'REG_SZ',
    'BOOLEAN': 'REG_DWORD',
}


def get_ffproxy(nom, value, vartype):
    return ((nom, 'network.proxy.backup.ftp', value, vartype),
    (nom, 'network.proxy.backup.gopher', value, vartype),
    (nom, 'network.proxy.backup.socks', value, vartype),
    (nom, 'network.proxy.backup.ssl', value, vartype),
    (nom, 'network.proxy.ftp', value, vartype),
    (nom, 'network.proxy.gopher', value, vartype),
    (nom, 'network.proxy.socks', value, vartype),
    (nom, 'network.proxy.ssl', value, vartype)
     )

def get_ffproxyports(nom, value, vartype):
    return  ((nom, 'network.proxy.backup.ftp_port', value, vartype),
            (nom, 'network.proxy.backup.gopher_port', value, vartype),
            (nom, 'network.proxy.backup.socks_port', value, vartype),
            (nom, 'network.proxy.backup.ssl_port', value, vartype),
            (nom, 'network.proxy.ftp_port', value, vartype),
            (nom, 'network.proxy.gopher_port', value, vartype),
            (nom, 'network.proxy.http_port', value, vartype),
            (nom, 'network.proxy.socks_port', value, vartype),
            (nom, 'network.proxy.ssl_port', value, vartype))

#CREOLE_VARS = dict([(i.upper(),j) for i,j in parsedico.parse_dico().items()])

class test_logon:
    def __init__(self):
        self.sid = 'SID_TEST_ESU'
        self.ip = '1.1.1.1'
        self.groups = ['eleves']
        self.user = 'test_eleve'
        self.userlname = 'Élève de test'

class ESU:
    def __init__(self, logon=None):
        self._prefs_js = []
        self._regedit = []
        self._inifile = []
        self._privileges = []
        self._acl_fichier = []
        self._acl_registre = []
        self.logon = logon

        self.sid = self.logon.sid
        self.ip = self.logon.ip
        self.groupes = self.logon.groups
        self.user = self.logon.user
        self.userlname = self.logon.userlname

        self.nom_machine = machines.get_nom(self.ip)
        self.os_type = machines.get_os(self.nom_machine)
        self.os = WINOS[self.os_type]

        # cherche le groupe de machines et le dossier correpondant
        filename = os.path.join(XMLDIR, "ListeGM.xml")
        self.machine_esu_groupe, self.gestionnaires_liste = self.searchComputerGroup(filename)
        if not self.machine_esu_groupe:
            self._esu_dict = None
        else:
            dirname = os.path.join(XMLDIR, self.machine_esu_groupe)
            self.user_esu_groupe = self.searchUserGroup(dirname, self.user, self.groupes)

            # Charge les options du domaine
            self.loadDomainConfig()

            # Charge les options de la machine
            self.loadMachineConfig(dirname)

            # Charge les options selon le groupe
            self.loadUserConfig(dirname)

            # Charge toutes les listes dans un grand dictionnaire
            self.loadEsuDict()
            ################
#            file('/tmp/esu_dict','w').write('%s'%self._esu_dict)

    def loadEsuDict(self):
        self._esu_dict = { 'esu_dict' : self._esu_vars_dict,
                           'machine_dict' : self._gm_dict,
                           'user_dict' : self._gu_dict }

    def loadDomainConfig(self):
        """Charge les variables ESU_*
        """
        filename = os.path.join(XMLDIR, "DomainConf.xml")
        xml = ET.parse(filename)
        pdc = xml.find('Reseau').find('Domaine').find('NomPDC').text
        domaine = xml.find('Reseau').find('Domaine').find('NomDomaine').text
        part_icones = xml.find('Reseau').find('StockageData').find('Chemin_AccesEcriture_RACCOURCIS').text
        lect_icones = xml.find('Reseau').find('StockageData').find('LecteurReseau_RACCOURCIS').text
        proxy_t = xml.find('Internet').find('Proxy').find('Serveur')
        host, port  = proxy_t.get('host'), proxy_t.get('port')
        proxy_bypass = xml.find('Internet').find('Proxy').find('ByPass').text
        self._esu_vars_dict = {'ESU_PROXY_HOST': host,
                               'ESU_PROXY_PORT': port,
                               'ESU_PROXY_BYPASS': proxy_bypass,
                               'ESU_PDC': pdc,
                               'ESU_DOMAINE': domaine,
                               'ESU_OS': self.os_type,
                               'ESU_PARTAGE_ICONES': part_icones,
                               'ESU_LECTEUR_ICONES': lect_icones,
                               'ESU_GU': self.user_esu_groupe,
                               'ESU_GM': self.machine_esu_groupe,
                               'USERNAME': self.user,
                               'USERLNAME': self.userlname,
                               'GROUPES': self.groupes,
                               'SID': self.sid,
                               'IP': self.ip,
                               'GESTIONNAIRES': self.gestionnaires_liste}
#        self._esu_vars_dict.update(CREOLE_VARS)

    def loadMachineConfig(self, dirname):
        machine_filename = os.path.join(dirname, "_Machine.xml")
        self._gm_dict = self.loadConfig(machine_filename)

    def loadUserConfig(self, dirname):
        user_filename = os.path.join(dirname, "%s.xml"%self.user_esu_groupe)
        f_bckgrnd = os.path.join(dirname, "%s.bgd"%self.user_esu_groupe)
        if os.path.isfile(f_bckgrnd): bckgrnd_msg = file(f_bckgrnd).read()
        else: bckgrnd_msg = '%USERLNAME%\nBureau : %ESU_GU%\nGroupe de machines : %ESU_GM%\nPoste : %COMPUTERNAME%'
        self._gu_dict = self.loadConfig(user_filename)
        self._gu_dict['bckgrnd_msg'] = bckgrnd_msg

    def loadConfig(self, filename):
        """
        Charge des regles depuis un fichier XML.
        """
        dico = { 'reg': [],
                 'ini': [],
                 'js': [],
                 'acl_reg': [],
                 'acl_fich': [],
                 'privileges': [] }
        if not os.path.isfile(filename): return dico
        xml = ET.parse(filename)
        for chemin in xml.find('Regles').getiterator('Chemin'):
            nom = chemin.get('nom')
            for variable in chemin.getiterator('Variable'):
                self.readRule(nom, variable, dico)
        return dico

    def readRule(self, nom, variable, dico):
        # Filtre sur la version de l'OS
        os = int(variable.get('OS'))
        if not (os & self.os):
            return
        try:
            varnom = variable.get('nom')
            vartype = variable.get('type')
            value = variable.findtext('.')
            if not nom: return dico
            if nom.startswith("REG://"):
                reg = self.regedit("%s\\%s" % (nom[6:], varnom), vartype, value)
                dico['reg'].append(reg)
            elif nom.startswith("INI://"):
                filename, section = nom[6:].split("?section=", 1)
                ini = (filename, section, varnom, value, vartype)
                dico['ini'].append(ini)
            elif nom.startswith("JS://"):
                js = (nom[5:], varnom, value, vartype)
                dico['js'].append(js)
                if varnom == 'network.proxy.http':
                    for js in get_ffproxy(nom[5:], value, vartype):
                        dico['js'].append(js)
                if varnom == 'network.proxy.http_port':
                    for js in get_ffproxyports(nom[5:], value, vartype):
                        dico['js'].append(js)
            elif nom == "ACLREGISTRE":
                dico['acl_reg'].append((varnom, value))
            elif nom == "ACLFICHIER":
                dico['acl_fich'].append((varnom, value))
            elif nom == "PRIVILEGE":
                dico['privileges'].append((varnom, value))
            else:
                log.err("UNKNOWN ACTION : %s"%nom)
        except Exception, e:
            log.err('%s %s'%(e, [nom, varnom, vartype, value]))
        return dico

    def regedit(self, key, keytype, value):
        keytype = REG_TYPES[keytype]
        # a\b\c\d\e => a, b\c\d, e
        hkey, keypath = key.split("\\", 1)
        hkey = hkey.strip('/').strip('\\')
        if hkey == "HKEY_CURRENT_USER":
            hkey = "HKEY_USERS"
            keypath = "%s\\%s" % (self.sid, keypath)
        keypath, keyname = keypath.rsplit("\\", 1)
        keyname = keyname.strip("\\")
        key = key.rstrip("\\")


        reg = {
            'hkey': hkey,
            'keypath': keypath,
            'keyname': keyname,
            'keytype': keytype,
            'value': value,
        }
        return reg

    def searchComputerGroup(self, filename):
        """
        Cherche le groupe qui matche le nom de la machine.
        Caractères spéciaux pour matcher le nom : *, ?, [ et ].
        Voir http://docs.python.org/lib/module-fnmatch.html
        * Ajoute la liste des gestionnaires généraux et du groupe de machines

        Utilise le fichier XML "ListeGM.xml".
        """
        xml = etree.parse(filename)
        gest_liste = [i.text for i in xml.xpath('/ESU_LGM/ListeGestionnaires/Gestionnaire')]
        xml = ET.parse(filename)
        log.msg('Nom de la machine %s'%self.nom_machine.lower())
        for group in xml.getiterator('GM'):
            for machine in group.find('ListeMachines').findall("Machine"):
                motif = machine.text
                if not motif: continue
                if not fnmatch(self.nom_machine.lower(), motif.lower()): continue
                if group.find('ListeGestionnaires'):
                    for gestionnaire in group.find('ListeGestionnaires').findall('Gestionnaire'):
                        if gestionnaire.text not in gest_liste:
                            gest_liste.append(gestionnaire.text)
                log.msg('Groupe de machines ESU trouve : %s (%s)'%(group.get('nom'), self.nom_machine.lower()))
                return group.get('nom'), gest_liste
        log.err('Aucun groupe de machines ESU trouve pour %s'%self.nom_machine.lower())
        return None, None

    def searchUserGroup(self, dirname, user, groupes):
        """
        Cherche le nom du fichier XML selon les groupes de l'utilisateur
        """
        log.msg('Utilisateur "%s"; groupes %s'%(user.lower(), groupes))
        filename = os.path.join(dirname, "_ListeUtilisateurs.xml")
        xml = ET.parse(filename)
        for groupe in xml.getiterator('GU'):
            nom = groupe.get('nom')
            groupes_lower = [ i.lower() for i in groupes]
            if nom.lower() in groupes_lower or nom.lower() == user.lower():
                log.msg("Groupe d'utilisateur ESU : %s (%s)"%(nom, user.lower()))
                return nom
        log.err("Aucun groupe d'utilisateur ESU trouve pour %s"%user.lower())
        return None

#def get_drives_type(user, sid, ip, groups):
#    l = test_logon
#    l.user = user
#    l.sid = sid
#    l.ip = ip
#    l.groups = groups
def get_drives_type(l):
    nodrives, noviewondrive = '0', '0'
    for i in ESU(l)._esu_dict['user_dict']['reg']:
        if i['keyname'].lower() == 'nodrives': nodrives = i['value']
        if i['keyname'].lower() == 'noviewondrive': noviewondrive = i['value']
    return nodrives, noviewondrive

def main():
    ESU(None)

if __name__ == "__main__":
    main()

