# _*_ coding: iso-8859-1 _*_
#Boa:FramePanel:BlocReseau
##iso-8859-1
import wx
import wx.lib.mixins.listctrl as listmix
import imgs

import fonctions, sys, os, traceback
from encodage import utftoiso

from pbgest import CliPB
C = CliPB()
getrootobject, disconnect = C.getrootobject, C.disconnect

[wxID_BLOCRESEAU, wxID_BLOCRESEAUBLOCBTN, wxID_BLOCRESEAUBLOCMACHBTN, 
 wxID_BLOCRESEAUBTNACTU, wxID_BLOCRESEAUCHOICEENDBLOC, 
 wxID_BLOCRESEAUCHOICEGRP, wxID_BLOCRESEAUCHOICETYPEBLOC, 
 wxID_BLOCRESEAULISTCTRLUSERS, wxID_BLOCRESEAURADIOBTN0, 
 wxID_BLOCRESEAURADIOBTN1, wxID_BLOCRESEAURADIOBTN2, wxID_BLOCRESEAURADIOBTN3, 
 wxID_BLOCRESEAURADIOUORM0, wxID_BLOCRESEAURADIOUORM1, 
 wxID_BLOCRESEAUSTATICTEXTBLOC, wxID_BLOCRESEAUSTATICTEXTFIN, 
 wxID_BLOCRESEAUSTATICTEXTGRP, wxID_BLOCRESEAUSTATICTEXTLECT, 
 wxID_BLOCRESEAUSTATICTEXTTYPE, wxID_BLOCRESEAUSTATICTXTMACH, 
] = [wx.NewId() for _init_ctrls in range(20)]

class BlocReseau(wx.Panel, listmix.ColumnSorterMixin):
    def _init_coll_listCtrlUsers_Columns(self, parent):
        # generated method, don't edit

        parent.InsertColumn(col=0, format=wx.LIST_FORMAT_LEFT,
              heading='El\xe8ves', width=130)
        parent.InsertColumn(col=1, format=wx.LIST_FORMAT_LEFT,
              heading=u'Blocage', width=258)

    def _init_ctrls(self, prnt):
        # generated method, don't edit
        wx.Panel.__init__(self, id=wxID_BLOCRESEAU, name='BlocReseau',
              parent=prnt, pos=wx.Point(442, 431), size=wx.Size(740, 420),
              style=wx.TAB_TRAVERSAL)
        self.SetClientSize(wx.Size(732, 386))
        self.SetBackgroundColour(wx.Colour(255, 255, 209))
        self.SetBackgroundStyle(wx.BG_STYLE_COLOUR)

        self.staticTextGrp = wx.StaticText(id=wxID_BLOCRESEAUSTATICTEXTGRP,
              label='Liste des groupes', name='staticTextGrp', parent=self,
              pos=wx.Point(150, 10), size=wx.Size(115, 16), style=0)
        self.staticTextGrp.SetFont(wx.Font(10, wx.SWISS, wx.NORMAL, wx.BOLD,
              False, 'Tahoma'))

        self.staticTxtMach = wx.StaticText(id=wxID_BLOCRESEAUSTATICTXTMACH,
              label=u'Liste des machines', name=u'staticTxtMach', parent=self,
              pos=wx.Point(150, 39), size=wx.Size(122, 16),
              style=wx.ALIGN_CENTRE)
        self.staticTxtMach.SetFont(wx.Font(10, wx.SWISS, wx.NORMAL, wx.BOLD,
              False, u'Tahoma'))
        self.staticTxtMach.Show(False)

        self.radioUorM0 = wx.RadioButton(id=wxID_BLOCRESEAURADIOUORM0,
              label='Utilisateurs', name=u'radioUorM0', parent=self,
              pos=wx.Point(24, 24), size=wx.Size(81, 13), style=wx.RB_GROUP)
        self.radioUorM0.Bind(wx.EVT_RADIOBUTTON, self.OnRadioUorM0Radiobutton,
              id=wxID_BLOCRESEAURADIOUORM0)

        self.radioUorM1 = wx.RadioButton(id=wxID_BLOCRESEAURADIOUORM1,
              label='Machines', name=u'radioUorM1', parent=self,
              pos=wx.Point(24, 48), size=wx.Size(81, 13), style=0)
        self.radioUorM1.Bind(wx.EVT_RADIOBUTTON, self.OnRadioUorM1Radiobutton,
              id=wxID_BLOCRESEAURADIOUORM1)

        self.choiceGrp = wx.Choice(choices=[], id=wxID_BLOCRESEAUCHOICEGRP,
              name='choiceGrp', parent=self, pos=wx.Point(110, 34),
              size=wx.Size(192, 24), style=0)
        self.choiceGrp.SetFont(wx.Font(10, wx.SWISS, wx.NORMAL, wx.NORMAL,
              False, 'Tahoma'))
        self.choiceGrp.Bind(wx.EVT_CHOICE, self.OnChoiceGrpChoice,
              id=wxID_BLOCRESEAUCHOICEGRP)

        self.listCtrlUsers = wx.ListCtrl(id=wxID_BLOCRESEAULISTCTRLUSERS,
              name='listCtrlUsers', parent=self, pos=wx.Point(24, 76),
              size=wx.Size(408, 244), style=wx.LC_REPORT)
        self._init_coll_listCtrlUsers_Columns(self.listCtrlUsers)

        self.staticTextType = wx.StaticText(id=wxID_BLOCRESEAUSTATICTEXTTYPE,
              label=u'Type de blocage', name=u'staticTextType', parent=self,
              pos=wx.Point(524, 36), size=wx.Size(105, 16), style=0)
        self.staticTextType.SetFont(wx.Font(10, wx.SWISS, wx.NORMAL, wx.BOLD,
              False, 'Tahoma'))

        self.staticTextBloc = wx.StaticText(id=wxID_BLOCRESEAUSTATICTEXTBLOC,
              label=u'Blocage r\xe9seau', name='staticTextBloc', parent=self,
              pos=wx.Point(533, 76), size=wx.Size(87, 16), style=0)
        self.staticTextBloc.SetFont(wx.Font(10, wx.SWISS, wx.NORMAL, wx.NORMAL,
              False, u'Tahoma'))

        self.choiceTypeBloc = wx.Choice(choices=[],
              id=wxID_BLOCRESEAUCHOICETYPEBLOC, name='choiceTypeBloc',
              parent=self, pos=wx.Point(460, 100), size=wx.Size(248, 24),
              style=0)
        self.choiceTypeBloc.SetFont(wx.Font(10, wx.SWISS, wx.NORMAL, wx.NORMAL,
              False, 'Tahoma'))

        self.staticTextLect = wx.StaticText(id=wxID_BLOCRESEAUSTATICTEXTLECT,
              label='Lecteurs r\xe9seaux', name='staticTextLect', parent=self,
              pos=wx.Point(532, 148), size=wx.Size(97, 16), style=0)
        self.staticTextLect.SetFont(wx.Font(10, wx.SWISS, wx.NORMAL, wx.NORMAL,
              False, u'Tahoma'))

        self.radioBtn0 = wx.RadioButton(id=wxID_BLOCRESEAURADIOBTN0,
              label=u'Par d\xe9faut', name='radioBtn0', parent=self,
              pos=wx.Point(460, 168), size=wx.Size(81, 13), style=wx.RB_GROUP)
        self.radioBtn0.SetValue(True)

        self.radioBtn1 = wx.RadioButton(id=wxID_BLOCRESEAURADIOBTN1,
              label=u'Par d\xe9faut + partage "devoirs" (Y:)',
              name=u'radioBtn1', parent=self, pos=wx.Point(460, 192),
              size=wx.Size(280, 13), style=0)
        self.radioBtn1.SetValue(False)

        self.radioBtn2 = wx.RadioButton(id=wxID_BLOCRESEAURADIOBTN2,
              label='Aucun lecteur', name=u'radioBtn2', parent=self,
              pos=wx.Point(460, 216), size=wx.Size(152, 13), style=0)
        self.radioBtn2.SetValue(False)

        self.radioBtn3 = wx.RadioButton(id=wxID_BLOCRESEAURADIOBTN3,
              label=u'Seulement le partage "devoirs" (Y:)', name=u'radioBtn3',
              parent=self, pos=wx.Point(460, 240), size=wx.Size(280, 13),
              style=0)
        self.radioBtn3.SetValue(False)

        self.staticTextFin = wx.StaticText(id=wxID_BLOCRESEAUSTATICTEXTFIN,
              label='Fin du blocage', name='staticTextFin', parent=self,
              pos=wx.Point(536, 272), size=wx.Size(91, 16), style=0)
        self.staticTextFin.SetFont(wx.Font(10, wx.SWISS, wx.NORMAL, wx.BOLD,
              False, 'Tahoma'))

        self.choiceEndBloc = wx.Choice(choices=[],
              id=wxID_BLOCRESEAUCHOICEENDBLOC, name='choiceEndBloc',
              parent=self, pos=wx.Point(460, 296), size=wx.Size(248, 24),
              style=0)
        self.choiceEndBloc.SetFont(wx.Font(10, wx.SWISS, wx.NORMAL, wx.NORMAL,
              False, 'Tahoma'))

        self.blocBtn = wx.Button(id=wxID_BLOCRESEAUBLOCBTN,
              label='Appliquer le blocage', name='blocBtn', parent=self,
              pos=wx.Point(304, 344), size=wx.Size(136, 24), style=0)
        self.blocBtn.SetFont(wx.Font(10, wx.SWISS, wx.NORMAL, wx.NORMAL, False,
              'Tahoma'))
        self.blocBtn.Bind(wx.EVT_BUTTON, self.OnBlocBtnButton,
              id=wxID_BLOCRESEAUBLOCBTN)

        self.blocMachBtn = wx.Button(id=wxID_BLOCRESEAUBLOCMACHBTN,
              label='Appliquer le blocage', name=u'blocMachBtn', parent=self,
              pos=wx.Point(304, 344), size=wx.Size(136, 24), style=0)
        self.blocMachBtn.SetFont(wx.Font(10, wx.SWISS, wx.NORMAL, wx.NORMAL,
              False, 'Tahoma'))
        self.blocMachBtn.Bind(wx.EVT_BUTTON, self.OnBlocMachBtnButton,
              id=wxID_BLOCRESEAUBLOCMACHBTN)

        self.btnActu = wx.Button(id=wxID_BLOCRESEAUBTNACTU, label=u'Actualiser',
              name=u'btnActu', parent=self, pos=wx.Point(24, 324),
              size=wx.Size(60, 19), style=0)
        self.btnActu.SetFont(wx.Font(8, wx.SWISS, wx.NORMAL, wx.NORMAL, False,
              u'Tahoma'))
        self.btnActu.Bind(wx.EVT_BUTTON, self.OnBtnActuButton,
              id=wxID_BLOCRESEAUBTNACTU)

    def __init__(self, parent, id, pos, size, style, name):
        self.drives_f = os.path.join(os.path.dirname(sys.executable), 'lecteurs.txt')
        self._init_ctrls(parent)
        # initialisation du tri (de)croisant des colonnes de la liste
        # fleches sur les en-tetes de liste
        self.il = wx.ImageList(16, 16)
        self.sm_up = self.il.Add(imgs.SmallUpArrow.GetBitmap())
        self.sm_dn = self.il.Add(imgs.SmallDnArrow.GetBitmap())
        self.listCtrlUsers.SetImageList(self.il, wx.IMAGE_LIST_SMALL)
##        self.itemDataMap = {}
        listmix.ColumnSorterMixin.__init__(self, 3)
        self.init_interface__()

    def GetListCtrl(self):
        return self.listCtrlUsers

    def GetSortImages(self):
        return (self.sm_dn, self.sm_up)
    
    def init_interface__(self):
        """initialise les combo et le bouton
        """
        self.blocBtn.Disable()
        self.choiceGrp.Clear()
        self.listCtrlUsers.DeleteAllItems()
        self.init_combo_time()
        self.cur_groupe = None
        self.mode = 0
        self.ActiveUserMod()
        # tri par dfaut sur la premire colonne, ordre croissant
        self.SortListItems(0, 1)
    
    def init_combo_time(self):
        """Affichage des limites de temps du blocage dans un format "humain"
        """
        self.hd = ( ('15 minutes', 15),
               ('30 minutes', 30),
               ('45 minutes', 45),
               ('1 heure', 60),
               ('1 heure 15', 75),
               ('1 heure 30', 90),
               ('1 heure 45', 105),
               ('2 heures', 120),
               ('2 heures 15', 135),
               ('2 heures 30', 150),
               ('2 heures 45', 165),
               ('3 heures', 180),
               ('4 heures', 240),
               ('5 heures', 300),
               ('6 heures', 360),
               ('7 heures', 420),
               ('8 heures', 480),
               ('9 heures', 540),
               ('10 heures', 600),
               ('11 heures', 660),
               ('12 heures', 720),
               ('13 heures', 780),
               ('14 heures', 840),
               ('1min', 1)
            )
        for i, j in self.hd:
            self.choiceEndBloc.Append(i, j)
        self.choiceEndBloc.SetSelection(0)

#########################
# Evnements graphiques #
#########################
    def OnBtnActuButton(self, event):
        self.switch_mod(force=True)

    def OnRadioUorM0Radiobutton(self, event):
        """Par utilisateurs
        """
        self.switch_mod()
        
    def OnRadioUorM1Radiobutton(self, event):
        """Par machines
        """
        self.switch_mod()
        
    def OnChoiceGrpChoice(self, event):
        self.cur_groupe = self.choiceGrp.GetStringSelection()
        self.init_liste_eleves()
        self.blocBtn.Enable()

    def OnBlocBtnButton(self, event):
        """Clique appliquer le blocage aux users
        """
        users = list()
        type = self.choiceTypeBloc.GetSelection()
        duree = self.choiceEndBloc.GetClientData(self.choiceEndBloc.GetSelection())
        partage = self.get_partage_mod()
        for i in range(self.listCtrlUsers.GetItemCount()):
            if not self.listCtrlUsers.IsSelected(i): continue
            eleve = self.itemDataMap[self.listCtrlUsers.GetItemData(i)][0]
            users.append((eleve, type, partage, duree))
        if len(users) == 0: return
        self.bloc_users(users)

    def OnBlocMachBtnButton(self, event):
        """Clique appliquer le blocage aux machines
        """
        machines = list()
        type = self.choiceTypeBloc.GetSelection()
        duree = self.choiceEndBloc.GetClientData(self.choiceEndBloc.GetSelection())
        for i in range(self.listCtrlUsers.GetItemCount()):
            if not self.listCtrlUsers.IsSelected(i): continue
            mach = self.itemDataMap[self.listCtrlUsers.GetItemData(i)][0]
            machines.append((mach, type, duree))
        if len(machines) == 0: return
        self.bloc_machines(machines)

    def get_partage_mod(self):
        drives = self.get_drives_perso()
        # 0:par dfaut, 1: Dfaut+devoirs(Y:), 2: Aucun, 3: Seulement devoirs
        for i in range(4): #[self.radioBtn0, self.radioBtn1, self.radioBtn2, self.radioBtn3]:
            if getattr(self, 'radioBtn%s'%i).GetValue() == True:
                break
        return (i, drives)
    
    def get_drives_perso(self):
        """rcupre la liste des lecteurs  NE PAS masquer dans "lecteurs.txt"
        """
        abcd = [chr(i) for i in range(97,123)]
        try:
            l = file(self.drives_f).readline().strip().split(',')
            for i in l:
                if i.lower() not in abcd: return None
            return l
        except: return None

#################################
# Bascule Utilisateurs/Machines #
#################################
    def switch_mod(self, force=False):
        mode = self.get_switch_mod()
        if mode == self.mode and not force: return
        self.mode = mode
        if mode == 0:d = self.ActiveUserMod()
        elif mode == 1:d = self.ActiveMachMod()
##        d.addCallback(lambda r: self.SortListItems(self._col, self._colSortFlag[self._col]))
        
    def get_switch_mod(self):
        """Utilisateurs = 0, Machines = 1
        """
        for i in range(2): #[self.radioUorM0, self.radioUorM1]:
            if getattr(self, 'radioUorM%s'%i).GetValue() == True:
                break
        return i
    
    def ActiveUserMod(self):
        self.choiceGrp.Show()
        self.staticTextGrp.Show()
        self.staticTxtMach.Hide()
        self.blocBtn.Show()
        self.blocMachBtn.Hide()
        self.changeColumnLabel(0, 'El\xe8ves')
        self.radioBtn0.Enable()
        self.radioBtn1.Enable()
        self.radioBtn2.Enable()
        self.radioBtn3.Enable()
        return self.init_liste_eleves()
        
    def ActiveMachMod(self):
        self.choiceGrp.Hide()
        self.staticTextGrp.Hide()
        self.staticTxtMach.Show()
        self.blocBtn.Hide()
        self.blocMachBtn.Show()
        self.radioBtn0.Disable()
        self.radioBtn1.Disable()
        self.radioBtn2.Disable()
        self.radioBtn3.Disable()
        self.changeColumnLabel(0, 'Machines')
        return self.init_liste_machines()

    def changeColumnLabel(self, col, label):
        item = self.listCtrlUsers.GetColumn(col)
        item.SetText(label)
        self.listCtrlUsers.SetColumn(col, item)
        self.listCtrlUsers.ClearColumnImage(col)
        
###############################
# Gestion des appels distants #
###############################
    def init_combo_bloc(self, parent):
        """Initialisation de la liste des type de blocage rseau
        """
        # rcupration du parent
        self.parent = parent
        self.statusBar1 = self.parent.statusBar1
        # rcupration de la liste des groupes
        d = getrootobject()
        d.addCallback(lambda obj: obj.callRemote("get_bloc_list"))
        d.addCallback(self.return_blist)
        d.addErrback(self.serv_err,("Impossible de rcuprer la liste des types de blocages"))
        return d

    def return_blist(self, bd_list):
        """Fonction Callback, remplie la liste des type de blocages rseau
        """
        disconnect()
        self.bloc_dict = bd_list
        for i in bd_list['reseau'].keys():
            self.choiceTypeBloc.Insert(bd_list['reseau'][i], i)
        self.choiceTypeBloc.SetSelection(0)
##        for i in bd_list['partages'].keys():
##            self.choiceBlocPart.Insert(bd_list['partages'][i], i)
##        self.choiceBlocPart.SetSelection(0)
        self.init_groupes()

# Par Utilisateurs #
    def init_groupes(self):
        """Appel  la mthode "remote_classes"
        """
        d = getrootobject()
        d.addCallback(lambda obj: obj.callRemote('classes_et_groupes'))
        d.addErrback(self.serv_err,("Rcupration de la liste des groupes impossible"))
        d.addCallback(self.return_groupes)
        
    def return_groupes(self, liste_groupes):
        """Affiche la liste des classes dans le premier comboBox
        """
        disconnect()
        if liste_groupes is None :
            fonctions.red_alert("Erreur lors de la rcupration de la liste des groupes")
            return
        self.groupes = liste_groupes
        self.groupes.append('eleves')
        self.choiceGrp.AppendItems(self.groupes)
        self.choiceGrp.Enable()
        self.choiceGrp.SetFocus()

    def init_liste_eleves(self):
        """dclench lorsqu'une classe a t slectionne
        """
        self.listCtrlUsers.DeleteAllItems()
        # viter le 1er clic
        if not self.cur_groupe:
            return
        # rcupration de la liste des connectes sur le serveur
        d = getrootobject()
        d.addCallback(lambda obj: obj.callRemote('users_bloc_mod', (self.cur_groupe)))
        d.addErrback(self.serv_err,("Rcupration de la liste des utilisateurs impossible"))
        d.addCallback(self.return_eleves)
        return d

    def return_eleves(self, bdict):
        """gere le retour de la fonction "remote_users_bloc_mod(classe)"
        affiche la liste des lves et leur type de blocage dans la listCtrl
        ou un message en cas d'erreur
        """
        disconnect()
        if not bdict: return
        if len(bdict) == 0:
            self.listCtrlUsers.Append((u'Aucun lve trouv',''))
            return
        try:
##        if 1:
            self.ele_li = bdict.keys()
            self.ele_li.sort()
            self.itemDataMap = {}
            for i in range(len(self.ele_li)):
                eleve = self.ele_li[i]
                netmod = bdict[eleve]['netmod']
                partmod = bdict[eleve]['partmod'][0]
                bloclabel = '%s, %s'%(utftoiso(self.bloc_dict['reseau'][netmod]), utftoiso(self.bloc_dict['partages'][partmod]))
                self.itemDataMap[i] = (eleve, bloclabel)
                self.listCtrlUsers.Append((eleve, bloclabel))
                self.listCtrlUsers.SetItemData(i,i)
        except Exception, e:
            self.listCtrlUsers.Append((u'Erreur', ''))
            self.serv_err('%s'%traceback.format_exc(), 'Erreur')
        self.SortListItems(self._col, self._colSortFlag[self._col])
    
    def bloc_users(self, users):
        if len(users) > 1: msg = 'Application des blocages ...'
        else: msg = 'Application du blocage ...'
        self.statusBar1.SetStatusText(msg, 0)
        d = getrootobject()
        d.addCallback(lambda obj: obj.callRemote('set_user_bloc_mod', users))
        d.addErrback(self.serv_err,("Impossible d'appliquer le blocage"))
        d.addCallback(self.return_bloc_users)
    
    def return_bloc_users(self, ret):
        disconnect()
        self.init_liste_eleves()
        self.statusBar1.SetStatusText('Pr\xeat', 0)

# Par Machines #
    def init_liste_machines(self):
        """Recupere la liste des machines (celles inscrites dans LDAP)
        """
        self.listCtrlUsers.DeleteAllItems()
        d = getrootobject()
        d.addCallback(lambda obj: obj.callRemote('get_machines_blocmod'))
        d.addErrback(self.serv_err, ("Rcupration de la liste des machines impossible"))
        d.addCallback(self.return_machines)
        return d

    def return_machines(self, mach_blocmod):
        """Affiche la liste des machines
        """
        disconnect()
        if not mach_blocmod: return
        if len(mach_blocmod) == 0:
            self.listCtrlUsers.Append((u'Aucune machine trouve',''))
            return
        try:
            self.machines = mach_blocmod.keys()
            self.machines.sort()
            self.itemDataMap = {}
            for i in range(len(self.machines)):
                machine = self.machines[i]
                netmod = mach_blocmod[machine]['netmod']
                #partmod = mach_blocmod[machine]['partmod'][0]
                bloclabel = '%s'%utftoiso(self.bloc_dict['reseau'][netmod])
                self.itemDataMap[i] = (machine, bloclabel)
                self.listCtrlUsers.Append((machine, bloclabel))
                self.listCtrlUsers.SetItemData(i,i)
        except Exception, e:
            self.listCtrlUsers.Append((u'Erreur', ''))
            self.serv_err('%s'%traceback.format_exc(), 'Erreur')
        self.SortListItems(self._col, self._colSortFlag[self._col])

    def bloc_machines(self, machines):
        if len(machines) > 1: msg = 'Application des blocages ...'
        else: msg = 'Application du blocage ...'
        self.statusBar1.SetStatusText(msg, 0)
        d = getrootobject()
        d.addCallback(lambda obj: obj.callRemote('set_machine_bloc_mod', machines))
        d.addErrback(self.serv_err,("Impossible d'appliquer le blocage"))
        d.addCallback(self.return_bloc_machines)

    def return_bloc_machines(self, ret):
        disconnect()
        self.init_liste_machines()
        self.statusBar1.SetStatusText('Pr\xeat', 0)

    def serv_err(self, ret, err):
        self.statusBar1.SetStatusText(u'Erreur')
        disconnect()
        err = 'Reseau : %s'%err
        self.parent.serv_err(ret, err)
        self.statusBar1.SetStatusText(u'Prt')

