# _*_ coding: iso-8859-1 _*_
#Boa:FramePanel:Devoir

import wx
from win32com.shell import shell, shellcon

import traceback

from pbgest import CliPB
C = CliPB()
getrootobject, disconnect = C.getrootobject, C.disconnect

import gest_devoir, fonctions

[wxID_DEVOIR, wxID_DEVOIRADDDBTN, wxID_DEVOIRADDFBTN, wxID_DEVOIRCBELEVEONLY, 
 wxID_DEVOIRCHOICEGROUPS, wxID_DEVOIRCHOICERAM, wxID_DEVOIRCHOICEREN, 
 wxID_DEVOIRCHOICESUPPR, wxID_DEVOIRDISTBTN, wxID_DEVOIRLISTBOXD, 
 wxID_DEVOIRLISTBOXF, wxID_DEVOIRRADIOBUTTON1, wxID_DEVOIRRADIOBUTTON2, 
 wxID_DEVOIRRAMBTN, wxID_DEVOIRRENBTN, wxID_DEVOIRSTATICBOX1, 
 wxID_DEVOIRSTATICBOX2, wxID_DEVOIRSTATICLINE2, wxID_DEVOIRSTATICLINE3, 
 wxID_DEVOIRSTATICTEXT1, wxID_DEVOIRSTATICTEXT2, wxID_DEVOIRSTATICTEXTD, 
 wxID_DEVOIRSTATICTEXTF, wxID_DEVOIRSTATICTEXTRA, wxID_DEVOIRSTATICTEXTRE, 
 wxID_DEVOIRSUPPRBTN, wxID_DEVOIRSUPPRDBTN, wxID_DEVOIRSUPPRFBTN, 
 wxID_DEVOIRTESTNAMEDEV, 
] = [wx.NewId() for _init_ctrls in range(29)]

class Devoir(wx.Panel):
    def _init_ctrls(self, prnt):
        # generated method, don't edit
        wx.Panel.__init__(self, id=wxID_DEVOIR, name='Devoir', parent=prnt,
              pos=wx.Point(371, 291), size=wx.Size(739, 418),
              style=wx.TAB_TRAVERSAL)
        self.SetClientSize(wx.Size(731, 384))
        self.SetBackgroundColour(wx.Colour(255, 255, 209))

        self.staticTextF = wx.StaticText(id=wxID_DEVOIRSTATICTEXTF,
              label='Devoir \xe0 distribuer', name='staticTextF', parent=self,
              pos=wx.Point(40, 16), size=wx.Size(121, 16), style=0)
        self.staticTextF.SetFont(wx.Font(10, wx.SWISS, wx.NORMAL, wx.BOLD,
              False, 'Tahoma'))

        self.listBoxF = wx.ListBox(choices=[], id=wxID_DEVOIRLISTBOXF,
              name='listBoxF', parent=self, pos=wx.Point(16, 38),
              size=wx.Size(264, 64), style=wx.LB_MULTIPLE)
        self.listBoxF.SetFont(wx.Font(9, wx.SWISS, wx.NORMAL, wx.NORMAL, False,
              'Tahoma'))

        self.addFbtn = wx.Button(id=wxID_DEVOIRADDFBTN, label='Ajouter',
              name='addFbtn', parent=self, pos=wx.Point(296, 44),
              size=wx.Size(64, 23), style=0)
        self.addFbtn.Bind(wx.EVT_BUTTON, self.OnAddFbtnButton,
              id=wxID_DEVOIRADDFBTN)

        self.supprFbtn = wx.Button(id=wxID_DEVOIRSUPPRFBTN, label='Supprimer',
              name='supprFbtn', parent=self, pos=wx.Point(296, 76),
              size=wx.Size(64, 23), style=0)
        self.supprFbtn.Bind(wx.EVT_BUTTON, self.OnSupprFbtnButton,
              id=wxID_DEVOIRSUPPRFBTN)

        self.staticTextD = wx.StaticText(id=wxID_DEVOIRSTATICTEXTD,
              label='Donn\xe9e (facultatif)', name='staticTextD', parent=self,
              pos=wx.Point(40, 118), size=wx.Size(106, 16), style=0)
        self.staticTextD.SetFont(wx.Font(10, wx.SWISS, wx.NORMAL, wx.NORMAL,
              False, 'Tahoma'))

        self.listBoxD = wx.ListBox(choices=[], id=wxID_DEVOIRLISTBOXD,
              name='listBoxD', parent=self, pos=wx.Point(16, 140),
              size=wx.Size(264, 64), style=wx.LB_MULTIPLE)
        self.listBoxD.SetFont(wx.Font(9, wx.SWISS, wx.NORMAL, wx.NORMAL, False,
              'Tahoma'))

        self.addDbtn = wx.Button(id=wxID_DEVOIRADDDBTN, label='Ajouter',
              name='addDbtn', parent=self, pos=wx.Point(296, 146),
              size=wx.Size(64, 23), style=0)
        self.addDbtn.Bind(wx.EVT_BUTTON, self.OnAddDbtnButton,
              id=wxID_DEVOIRADDDBTN)

        self.supprDbtn = wx.Button(id=wxID_DEVOIRSUPPRDBTN, label='Supprimer',
              name='supprDbtn', parent=self, pos=wx.Point(296, 178),
              size=wx.Size(64, 23), style=0)
        self.supprDbtn.Bind(wx.EVT_BUTTON, self.OnSupprDbtnButton,
              id=wxID_DEVOIRSUPPRDBTN)

        self.testNameDev = wx.TextCtrl(id=wxID_DEVOIRTESTNAMEDEV,
              name=u'testNameDev', parent=self, pos=wx.Point(40, 240),
              size=wx.Size(208, 21), style=0, value=u'')
        self.testNameDev.SetFont(wx.Font(10, wx.SWISS, wx.NORMAL, wx.NORMAL,
              False, u'MS Sans Serif'))

        self.choiceGroups = wx.Choice(choices=[], id=wxID_DEVOIRCHOICEGROUPS,
              name='choiceGroups', parent=self, pos=wx.Point(40, 272),
              size=wx.Size(168, 24), style=0)
        self.choiceGroups.SetFont(wx.Font(10, wx.SWISS, wx.NORMAL, wx.NORMAL,
              False, 'Tahoma'))
        self.choiceGroups.Enable(False)
        self.choiceGroups.Bind(wx.EVT_CHOICE, self.OnChoiceGroupsChoice,
              id=wxID_DEVOIRCHOICEGROUPS)

        self.cBEleveOnly = wx.CheckBox(id=wxID_DEVOIRCBELEVEONLY,
              label=u'Uniquement aux \xe9l\xe8ves du groupe',
              name=u'cBEleveOnly', parent=self, pos=wx.Point(40, 310),
              size=wx.Size(216, 16), style=0)
        self.cBEleveOnly.SetValue(True)
        self.cBEleveOnly.SetFont(wx.Font(10, wx.SWISS, wx.NORMAL, wx.NORMAL,
              False, u'Tahoma'))

        self.radioButton1 = wx.RadioButton(id=wxID_DEVOIRRADIOBUTTON1,
              label=u'Dans le dossier "perso\\devoirs"', name='radioButton1',
              parent=self, pos=wx.Point(40, 334), size=wx.Size(168, 16),
              style=0)
        self.radioButton1.SetValue(True)

        self.radioButton2 = wx.RadioButton(id=wxID_DEVOIRRADIOBUTTON2,
              label=u'Dans le partage "devoirs" (non accessible par d\xe9faut)',
              name='radioButton2', parent=self, pos=wx.Point(40, 352),
              size=wx.Size(280, 17), style=0)

        self.distBtn = wx.Button(id=wxID_DEVOIRDISTBTN,
              label='Choisissez un groupe', name='distBtn', parent=self,
              pos=wx.Point(232, 272), size=wx.Size(112, 24), style=0)
        self.distBtn.SetFont(wx.Font(8, wx.SWISS, wx.NORMAL, wx.NORMAL, False,
              'Tahoma'))
        self.distBtn.Enable(False)
        self.distBtn.Bind(wx.EVT_BUTTON, self.OnDistBtnButton,
              id=wxID_DEVOIRDISTBTN)

        self.staticTextRa = wx.StaticText(id=wxID_DEVOIRSTATICTEXTRA,
              label='Devoir \xe0 ramasser', name='staticTextRa', parent=self,
              pos=wx.Point(434, 24), size=wx.Size(119, 16), style=0)
        self.staticTextRa.SetFont(wx.Font(10, wx.SWISS, wx.NORMAL, wx.BOLD,
              False, 'Tahoma'))

        self.choiceRam = wx.Choice(choices=[], id=wxID_DEVOIRCHOICERAM,
              name='choiceRam', parent=self, pos=wx.Point(416, 54),
              size=wx.Size(264, 24), style=0)
        self.choiceRam.SetFont(wx.Font(10, wx.SWISS, wx.NORMAL, wx.NORMAL,
              False, 'Tahoma'))
        self.choiceRam.Bind(wx.EVT_CHOICE, self.OnChoiceRamChoice,
              id=wxID_DEVOIRCHOICERAM)

        self.ramBtn = wx.Button(id=wxID_DEVOIRRAMBTN,
              label='Choisissez un devoir', name='ramBtn', parent=self,
              pos=wx.Point(456, 88), size=wx.Size(108, 24), style=0)
        self.ramBtn.SetFont(wx.Font(8, wx.SWISS, wx.NORMAL, wx.NORMAL, False,
              'Tahoma'))
        self.ramBtn.Enable(False)
        self.ramBtn.Bind(wx.EVT_BUTTON, self.OnRamBtnButton,
              id=wxID_DEVOIRRAMBTN)

        self.staticTextRe = wx.StaticText(id=wxID_DEVOIRSTATICTEXTRE,
              label='Devoir \xe0 rendre (corrig\xe9)', name='staticTextRe',
              parent=self, pos=wx.Point(434, 136), size=wx.Size(164, 16),
              style=0)
        self.staticTextRe.SetFont(wx.Font(10, wx.SWISS, wx.NORMAL, wx.BOLD,
              False, 'Tahoma'))

        self.choiceRen = wx.Choice(choices=[], id=wxID_DEVOIRCHOICEREN,
              name='choiceRen', parent=self, pos=wx.Point(416, 166),
              size=wx.Size(264, 24), style=0)
        self.choiceRen.SetFont(wx.Font(10, wx.SWISS, wx.NORMAL, wx.NORMAL,
              False, 'Tahoma'))
        self.choiceRen.Bind(wx.EVT_CHOICE, self.OnChoiceRenChoice,
              id=wxID_DEVOIRCHOICEREN)

        self.renBtn = wx.Button(id=wxID_DEVOIRRENBTN,
              label='Choisissez un devoir', name='renBtn', parent=self,
              pos=wx.Point(456, 200), size=wx.Size(108, 24), style=0)
        self.renBtn.SetFont(wx.Font(8, wx.SWISS, wx.NORMAL, wx.NORMAL, False,
              'Tahoma'))
        self.renBtn.Enable(False)
        self.renBtn.Bind(wx.EVT_BUTTON, self.OnRenBtnButton,
              id=wxID_DEVOIRRENBTN)

        self.staticLine2 = wx.StaticLine(id=wxID_DEVOIRSTATICLINE2,
              name='staticLine2', parent=self, pos=wx.Point(400, 238),
              size=wx.Size(300, 1), style=0)

        self.choiceSuppr = wx.Choice(choices=[], id=wxID_DEVOIRCHOICESUPPR,
              name='choiceSuppr', parent=self, pos=wx.Point(416, 278),
              size=wx.Size(264, 24), style=0)
        self.choiceSuppr.SetFont(wx.Font(10, wx.SWISS, wx.NORMAL, wx.NORMAL,
              False, 'Tahoma'))
        self.choiceSuppr.Bind(wx.EVT_CHOICE, self.OnChoiceSupprChoice,
              id=wxID_DEVOIRCHOICESUPPR)

        self.staticText1 = wx.StaticText(id=wxID_DEVOIRSTATICTEXT1,
              label="Supprimer  les donn\xe9es d'un devoir rendu",
              name='staticText1', parent=self, pos=wx.Point(418, 248),
              size=wx.Size(270, 16), style=0)
        self.staticText1.SetFont(wx.Font(10, wx.SWISS, wx.NORMAL, wx.BOLD,
              False, 'Tahoma'))

        self.supprBtn = wx.Button(id=wxID_DEVOIRSUPPRBTN,
              label='Choisissez un devoir', name='supprBtn', parent=self,
              pos=wx.Point(456, 312), size=wx.Size(108, 24), style=0)
        self.supprBtn.Enable(False)
        self.supprBtn.Bind(wx.EVT_BUTTON, self.OnSupprBtnButton,
              id=wxID_DEVOIRSUPPRBTN)

        self.staticLine3 = wx.StaticLine(id=wxID_DEVOIRSTATICLINE3,
              name='staticLine3', parent=self, pos=wx.Point(400, 126),
              size=wx.Size(300, 1), style=0)

        self.staticBox1 = wx.StaticBox(id=wxID_DEVOIRSTATICBOX1, label='',
              name='staticBox1', parent=self, pos=wx.Point(4, 8),
              size=wx.Size(370, 368), style=0)

        self.staticBox2 = wx.StaticBox(id=wxID_DEVOIRSTATICBOX2, label='',
              name='staticBox2', parent=self, pos=wx.Point(384, 8),
              size=wx.Size(336, 368), style=0)

        self.staticText2 = wx.StaticText(id=wxID_DEVOIRSTATICTEXT2,
              label=u'Nom du devoir', name='staticText2', parent=self,
              pos=wx.Point(48, 220), size=wx.Size(80, 14), style=0)
        self.staticText2.SetFont(wx.Font(9, wx.SWISS, wx.NORMAL, wx.NORMAL,
              False, u'Tahoma'))

    def __init__(self, parent, id, pos, size, style, name):
        self._init_ctrls(parent)
        # Pour rcuprer le chemin vers "Mes Documents"
        self.mydocs = shell.SHGetPathFromIDList (shell.SHGetSpecialFolderLocation (0, shellcon.CSIDL_PERSONAL))
        self.file_type =  "Tous les fichiers (*.*)|*.*"

    def init_pb(self, parent):
        # rcupration du parent
        self.parent = parent
        self.statusBar1 = self.parent.statusBar1
        # rcupration de la liste des groupes
        return self.get_groups()
    
    def get_groups(self):
        d = getrootobject()
        d.addCallback(lambda obj: obj.callRemote("groupes"))
        d.addErrback(self.serv_err,("Impossible de rcuprer la liste des groupes"))
        d.addCallback(self.return_grplist)
        return d

    def return_grplist(self, grpliste):
        disconnect()
        if grpliste is None :
            fonctions.red_alert(u'Erreur lors de la rcupration de la liste des groupes "None"')
            return
        self.groupes = grpliste
        self.groupes.append('eleves')
        self.gd = gest_devoir.GestDevoir()
        d = self.gd.get_devs()
        d.addCallback(lambda _: self.init_Listes())
    
    def init_Listes(self):
        try:
            self.testNameDev.SetValue(self.gd.get_next_devname())
            self.init_GroupeListe()
            self.init_RamListe()
            self.init_RenListe()
            self.init_SupprListe()
        except:
            m = '%s'%traceback.format_exc()
            self.serv_err(m, u"Erreur lors de l'initialisation")
        
    def init_GroupeListe(self):
        self.choiceGroups.Clear()
        self.choiceGroups.AppendItems(self.groupes)

    def init_RamListe(self):
        self.choiceRam.Clear()
        self.choiceRam.AppendItems(self.gd.get_dist_devoirs())

    def init_RenListe(self):
        self.choiceRen.Clear()
        self.choiceRen.AppendItems(self.gd.get_ram_devoirs())

    def init_SupprListe(self):
        self.choiceSuppr.Clear()
        self.choiceSuppr.AppendItems(self.gd.get_dev_todel())

    # Utilis plus bas, pour r-initialiser les boutons aprs une action
    def init_boutons(self):
        self.distBtn.SetLabel('Choisissez un groupe')
        self.distBtn.SetFont(wx.Font(8, wx.SWISS, wx.NORMAL, wx.NORMAL, False, 'Tahoma'))
        self.distBtn.Enable(False)
        for btn in [self.ramBtn, self.renBtn, self.supprBtn]:
            btn.SetLabel('Choisissez un devoir')
            btn.SetFont(wx.Font(8, wx.SWISS, wx.NORMAL, wx.NORMAL, False, 'Tahoma'))
            btn.Enable(False)

    #####################
    ## Fichiers devoir ##
    #####################
    def OnAddFbtnButton(self, event):
        """Clic sur le bouton "Ajouter devoir"
        """
        dlg = wx.FileDialog(self, message="Ouvrir", defaultDir=self.mydocs, wildcard=self.file_type, style=wx.OPEN|wx.MULTIPLE)
        try:
            if dlg.ShowModal() == wx.ID_OK:
                self.AddF(dlg.GetPaths())
        finally:
            dlg.Destroy()

    def OnSupprFbtnButton(self, event):
        """Supprimer un fichier devoir
        """
        self.DelF(self.listBoxF.GetSelections())

    def AddF(self, flist):
        """Ajoute la liste flist de fichiers dans la listbox devoirs
        """
        # le fichier  ajouter n'est-il pas dj dans l'autre liste ?
        for i in self.listBoxD.GetItems():
            if i in flist:
                fonctions.red_alert(u'%s : dj dans la liste des fichiers de donnes'%i, 'Erreur - Doublon')
                return
        self.setFlabel(self.AddItems(self.listBoxF, flist))
        
    def DelF(self, flist):
        """Supprime la liste flist de la listbox devoirs
        """
        self.setFlabel(self.DelItems(self.listBoxF, flist))
        
    def setFlabel(self, length):
        """Accorde le label au sigulier/pluriel en fonction du nombre d'items
        """
        if length > 1: self.staticTextF.SetLabel(u'Devoirs  distribuer')
        else: self.staticTextF.SetLabel(u'Devoir  distribuer')
        self.set_btn(length)

    def set_btn(self, length):
        """(Ds)active la liste et le bouton distribuer en fonction du contenu de self.listboxF "length"
        """
        if length == 0:
            self.choiceGroups.Disable()
            self.distBtn.Disable()
        else:
            self.choiceGroups.Enable()
            if self.choiceGroups.GetStringSelection() != '': self.distBtn.Enable()

    #########################
    ## Fichiers de donnes ##
    #########################
    def OnAddDbtnButton(self, event):
        """Clic sur le bouton "Ajouter donnes"
        """
        dlg = wx.FileDialog(self, message="Ouvrir", defaultDir=self.mydocs, wildcard=self.file_type, style=wx.OPEN|wx.MULTIPLE)
        try:
            if dlg.ShowModal() == wx.ID_OK:
                self.AddD(dlg.GetPaths())
        finally:
            dlg.Destroy()

    def OnSupprDbtnButton(self, event):
        """Supprimer un fichier donnes
        """
        self.DelD(self.listBoxD.GetSelections())

    def AddD(self, flist):
        """Ajoute la liste flist de fichiers dans la listbox donnes
        """
        # le fichier  ajouter n'est-il pas dj dans l'autre liste ?
        for i in self.listBoxF.GetItems():
            if i in flist:
                fonctions.red_alert(u'%s : dj dans la liste des fichiers du devoir'%i, 'Erreur - Doublon')
                return
        self.setDlabel(self.AddItems(self.listBoxD, flist))
        
    def DelD(self, flist):
        """Supprime la liste flist de la listbox donnes
        """
        self.setDlabel(self.DelItems(self.listBoxD, flist))
        
    def setDlabel(self, length):
        """Accorde le label au sigulier/pluriel en fonction du nombre d'items
        """
        if length > 1: self.staticTextD.SetLabel(u'Donnes (facultatif)')
        else: self.staticTextD.SetLabel(u'Donne (facultatif)')

    ###############
    ## Fonctions ##
    ###############
    def AddItems(self, box, items):
        """Ajoute la liste d'items dans box
        renvoie le nombre d'lments dans la box aprs ajout
        """
        for i in items:
            if i not in box.GetItems():
                box.Append(i)
        return len(box.GetItems())
                
    def DelItems(self, box, items):
        """Supprime la liste d'items de box
        renvoie le nombre d'lments dans la box aprs suppression
        """
        l = box.GetItems()
        for i in items:
            try: l.remove(box.GetString(i))
            except: continue
        box.Clear()
        box.AppendItems(l)
        return len(box.GetItems())

    ##################
    ## Distribution ##
    ##################
    def OnChoiceGroupsChoice(self, event):
        self.groupe = self.choiceGroups.GetStringSelection()
        self.distBtn.SetLabel('Distribuer')
        self.distBtn.SetFont(wx.Font(10, wx.SWISS, wx.NORMAL, wx.NORMAL, False, 'Tahoma'))
        self.distBtn.Enable()

    def OnDistBtnButton(self, event):
        if self.cBEleveOnly.GetValue():
            groupe = [self.groupe, 'eleves']
        else: groupe = self.groupe
        dev_name = self.testNameDev.GetValue().lower()
        if not self.verif_devname(dev_name):
            fonctions.red_alert(u"""Le nom "%s" est invalide.\n
Seul les caractre [a-Z], [0-9], ".", "-" et "_" sont autoriss (sans espace)."""%dev_name)
            return
        if dev_name in self.gd.devs.keys():
            texte = """Vous avez dj utilis "%s" comme nom pour un devoir.\n
Si vous le r-utilisez vous ne pourrez plus ramasser le devoir prcdent.\n
Voulez-vous continuer ?"""%dev_name
            dlg = wx.MessageDialog(self.parent, texte, '', wx.YES_NO|wx.ICON_QUESTION)
            try: val = dlg.ShowModal()
            finally: dlg.Destroy()
            if val == wx.ID_YES:
                self.statusBar1.SetStatusText(u'Copie vers les membres du groupe %s en cours ...'%self.groupe)
            
        d = getrootobject()
        d.addCallback(lambda obj: obj.callRemote("nb_membres", groupe))
        d.addErrback(self.serv_err, 'Erreur lors de la rcupration du nombre de membres')
        d.addCallback(self.return_nb_membres, dev_name)

    def verif_devname(self, dev_name):
        # todo, vrifier que le nom n'est pas dj utilis
        if not dev_name: return
        c = [chr(i) for i in range(97,123)]
        c.extend(['-', '_', '.'])
        c.extend([str(i) for i in range(0,10)])
        for i in dev_name:
            if i not in c: return
        return True

    def return_nb_membres(self, num, dev_name):
        disconnect()
        if int(num) == 0:
            if self.cBEleveOnly.GetValue():
                msg = "Aucun lve n'a t trouv dans le groupe %s"%self.groupe
            else:
                msg = "Aucun utilisateur n'a t trouv dans le groupe %s"%self.groupe
            return fonctions.red_alert(msg)
        flist, dlist = self.listBoxF.GetItems(), self.listBoxD.GetItems()
        texte = '%s devoirs vont tre distribus, voulez-vous continuer ?'%num
        dlg = wx.MessageDialog(self.parent, texte, '', wx.YES_NO|wx.ICON_QUESTION)
        try: val = dlg.ShowModal()
        finally: dlg.Destroy()
        if val == wx.ID_YES:
            self.statusBar1.SetStatusText(u'Copie vers les membres du groupe %s en cours ...'%self.groupe)
            self.distBtn.Disable()
            d = self.gd.distribute(flist, dlist, self.groupe, self.cBEleveOnly.GetValue(),
                                                              self.radioButton1.GetValue(),
                                                              dev_name)
            d.addCallback(self.return_dist)
            d.addErrback(self.serv_err, 'Erreur lors de la distribution des copies')

    def return_dist(self, ret):
        num = ret[0]
        rateu = ret[1]
        dev_name = ret[2]
        self.init_Listes()
        self.init_boutons()
        if len(rateu) > 0:
            eleves = '\n* '.join(rateu)
            m = u"%s copies distribues"%num
            m += u'\nLe nom du devoir est "%s"'%dev_name
            m += u"\n\nUne erreur s'est produite durant la distribution aux lves suivants : \n* %s"%eleves
            mm = 'Erreurs lors de la distribution'
            f = fonctions.red_alert
        else:
            m = u"%s copies distribues"%num
            m += u'\nLe nom du devoir est "%s"'%dev_name
            mm = u'Prt'
            f = fonctions.xmessage
        self.statusBar1.SetStatusText(mm)
        f(m)

    ###############
    ## Ramassage ##
    ###############
    def OnChoiceRamChoice(self, event):
        self.ram_devoir = self.choiceRam.GetStringSelection()
        self.ramBtn.SetLabel('Ramasser')
        self.ramBtn.SetFont(wx.Font(10, wx.SWISS, wx.NORMAL, wx.NORMAL, False, 'Tahoma'))
        self.ramBtn.Enable()

    def OnRamBtnButton(self, event):
        self.statusBar1.SetStatusText(u'Ramassage de "%s" en cours ...'%self.ram_devoir)
        self.ramBtn.Disable()
        d = self.gd.ramasse(self.ram_devoir)
        d.addCallback(self.return_ram)
        d.addErrback(self.serv_err, 'Erreur lors du ramassage')
    
    def return_ram(self, ret=''):
        reussi, rate = ret
        self.statusBar1.SetStatusText(u'Prt')
        self.init_Listes()
        self.init_boutons()
        if reussi > 1: texte = '%s copies ont t ramasses'%reussi
        elif reussi == 1: texte = '%s copie a t ramasse'%reussi
        else: texte = "Aucune copie n'a t ramasse"
        if len(rate) > 0: f = fonctions.red_alert
        else: f = fonctions.xmessage
        if len(rate) > 1: texte += "\n\nLes copies des lves suivant n'ont pas pu tre ramasses :\n* %s"%'\n* '.join(rate)
        elif len(rate) == 1: texte += "\n\nLa copie de l'lve n'a pas pu tre ramasse :\n* %s"%rate[0]
        f(texte)

    #############
    ## Rendage ##
    #############
    def OnChoiceRenChoice(self, event):
        self.ren_devoir = self.choiceRen.GetStringSelection()
        self.renBtn.SetLabel('Rendre')
        self.renBtn.SetFont(wx.Font(10, wx.SWISS, wx.NORMAL, wx.NORMAL, False, 'Tahoma'))
        self.renBtn.Enable()

    def OnRenBtnButton(self, event):
        self.statusBar1.SetStatusText(u'Remise des corrigs de "%s" en cours ...'%self.ren_devoir)
        self.renBtn.Disable()
        d = self.gd.rendre(self.ren_devoir)
        d.addCallback(self.return_ren)
        d.addErrback(self.serv_err, u'Erreur lors de la remise des corrigs')
    
    def return_ren(self, ret=''):
        reussi, rate = ret
        self.statusBar1.SetStatusText(u'Prt')
        self.init_Listes()
        self.init_boutons()
        if reussi > 1: texte = '%s copies ont t rendues'%reussi
        elif reussi == 1: texte = '%s copie a t rendue'%reussi
        else: texte = "Aucune copie n'a t rendue"
        if len(rate) > 0: f = fonctions.red_alert
        else: f = fonctions.xmessage
        if len(rate) > 1: texte += "\n\nLes copies des lves suivant n'ont pas pu tre rendues :\n* %s"%'\n* '.join(rate)
        elif len(rate) == 1: texte += "\n\nLa copie de l'lve suivant n'a pas pu tre rendue :\n* "%rate[0]
        f(texte)

    ###########
    ## Purge ##
    ###########
    def OnChoiceSupprChoice(self, event):
        self.suppr_devoir = self.choiceSuppr.GetStringSelection()
        self.supprBtn.SetLabel('Supprimer')
        self.supprBtn.SetFont(wx.Font(10, wx.SWISS, wx.NORMAL, wx.NORMAL, False, 'Tahoma'))
        self.supprBtn.Enable()

    def OnSupprBtnButton(self, event):
        self.statusBar1.SetStatusText(u'Suppression des donnes de "%s" en cours ...'%self.suppr_devoir)
        self.supprBtn.Disable()
        d = self.gd.suppr(self.suppr_devoir)
        d.addCallback(self.return_suppr)
        d.addErrback(self.serv_err, 'Erreur lors de la suppression')
    
    def return_suppr(self, ret):
        self.statusBar1.SetStatusText(u'Prt')
        self.init_Listes()
        self.init_boutons()
        fonctions.xmessage('Les donnes du devoir %s ont t supprimes'%self.suppr_devoir)

    def serv_err(self, ret, err):
        self.statusBar1.SetStatusText(u'Erreur')
        disconnect()
        err = 'Devoir : %s'%err
        self.parent.serv_err(ret, err)
        self.statusBar1.SetStatusText(u'Prt')
