# _*_ coding: iso-8859-1 _*_
# Windows IP Helper API function wrappers.
# http://msdn2.microsoft.com/en-gb/library/aa366073.aspx
#
# The contents of this file are subject to the Python Software Foundation
# License Version 2.3 (the License).  You may not copy or use this file, in
# either source code or executable form, except in compliance with the License.
# You may obtain a copy of the License at http://www.python.org/license.
#
# Software distributed under the License is distributed on an AS IS basis,
# WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the License
# for the specific language governing rights and limitations under the
# License.
#
# by Greg Hazel

import wmi

import logging, traceback

import pythoncom

import ctypes
import socket
import struct
from ctypes.wintypes import DWORD, ULONG

Iphlpapi = ctypes.windll.Iphlpapi

class IPAddr(ctypes.Structure):
    _fields_ = [ ("S_addr", ctypes.c_ulong),
                 ]

    def __str__(self):
        return socket.inet_ntoa(struct.pack("L", self.S_addr))

class MIB_IPADDRROW(ctypes.Structure):
    _fields_ = [("dwAddr", IPAddr),
                ("dwIndex", DWORD),
                ("dwMask", DWORD),
                ("dwBCastAddr", IPAddr),
                ("dwReasmSize", DWORD),
                ("unused1", ctypes.c_ushort),
                ("wType", ctypes.c_ushort),
                ]

MAX_INTERFACES = 10
class MIB_IPADDRTABLE(ctypes.Structure):
    _fields_ = [("dwNumEntries", DWORD),
                ("table", MIB_IPADDRROW * MAX_INTERFACES)]

def get_mac(ip):
    pythoncom.CoInitialize()
    c = wmi.WMI ()
    for interface in c.Win32_NetworkAdapterConfiguration (IPEnabled=1):
        for i in interface.IPAddress:
            if i == ip:
                a = interface.MACAddress
                pythoncom.CoUninitialize()
                return a

def inet_addr(ip):
    return IPAddr(struct.unpack("L", socket.inet_aton(ip))[0])

def get_interface_by_index(index):
    table = MIB_IPADDRTABLE()
    size = ULONG(ctypes.sizeof(table))
    table.dwNumEntries = 0
    Iphlpapi.GetIpAddrTable(ctypes.byref(table), ctypes.byref(size), 0)

    for n in xrange(table.dwNumEntries):
        row = table.table[n]
        if row.dwIndex == index:
            return str(row.dwAddr)
    raise IndexError("interface index out of range")

def get_route_ip(dest_ip):
    # doesn't really matter if this is out of date, we're just trying to find
    # the interface to get to the internet.
    dest_ip = socket.gethostbyname(dest_ip)
    dest_ip = inet_addr(dest_ip)

    index = ctypes.c_ulong()
    Iphlpapi.GetBestInterface(dest_ip, ctypes.byref(index))
    index = long(index.value)
    try:
        ip = get_interface_by_index(index)
        mac = get_mac(ip)
    except Exception, e:
        logging.error('%s'%e)
        logging.debug('Erreur %s'%traceback.format_exc())
        ip, mac = None, None
    return ip, mac


def getTCPOpenPorts():
    """
        This function will return a list of ports (TCP/UDP) that the current
        machine is listening on. It's basically a replacement for parsing
        netstat output but also serves as a good example for using the
        IP Helper API:
        http://msdn.microsoft.com/library/default.asp?url=/library/en-
        us/iphlp/iphlp/ip_helper_start_page.asp.
        I also used the following post as a guide myself (in case it's useful
        to anyone):
        http://aspn.activestate.com/ASPN/Mail/Message/ctypes-users/1966295
     """
    portList = []

    DWORD = ctypes.c_ulong
    NO_ERROR = 0
    NULL = ""
    bOrder = 0

    # define some MIB constants used to identify the state of a TCP port
    #MIB_TCP_STATE_CLOSED = 1
    MIB_TCP_STATE_LISTEN = 2
    #MIB_TCP_STATE_SYN_SENT = 3
    #MIB_TCP_STATE_SYN_RCVD = 4
    #MIB_TCP_STATE_ESTAB = 5
    #MIB_TCP_STATE_FIN_WAIT1 = 6
    #MIB_TCP_STATE_FIN_WAIT2 = 7
    #MIB_TCP_STATE_CLOSE_WAIT = 8
    #MIB_TCP_STATE_CLOSING = 9
    #MIB_TCP_STATE_LAST_ACK = 10
    #MIB_TCP_STATE_TIME_WAIT = 11
    #MIB_TCP_STATE_DELETE_TCB = 12

    ANY_SIZE = 1

    # defing our MIB row structures
    class MIB_TCPROW(ctypes.Structure):
        _fields_ = [('dwState', DWORD),
                    ('dwLocalAddr', DWORD),
                    ('dwLocalPort', DWORD),
                    ('dwRemoteAddr', DWORD),
                    ('dwRemotePort', DWORD)]

    dwSize = DWORD(0)

    # call once to get dwSize
    ctypes.windll.iphlpapi.GetTcpTable(NULL, ctypes.byref(dwSize), bOrder)

    # ANY_SIZE is used out of convention (to be like MS docs); even setting this
    # to dwSize will likely be much larger than actually necessary but much
    # more efficient that just declaring ANY_SIZE = 65500.
    # (in C we would use malloc to allocate memory for the *table pointer and
    #  then have ANY_SIZE set to 1 in the structure definition)

    ANY_SIZE = dwSize.value

    class MIB_TCPTABLE(ctypes.Structure):
        _fields_ = [('dwNumEntries', DWORD),
                    ('table', MIB_TCPROW * ANY_SIZE)]

    tcpTable = MIB_TCPTABLE()
    tcpTable.dwNumEntries = 0 # define as 0 for our loops sake

    # now make the call to GetTcpTable to get the data
    if (ctypes.windll.iphlpapi.GetTcpTable(ctypes.byref(tcpTable),
        ctypes.byref(dwSize), bOrder) == NO_ERROR):

        maxNum = tcpTable.dwNumEntries
        placeHolder = 0

        # loop through every connection
        while placeHolder < maxNum:

            item = tcpTable.table[placeHolder]
            placeHolder += 1

            # format the data we need (there is more data if it is useful -
            #    see structure definition)
            lPort = item.dwLocalPort
            lPort = socket.ntohs(lPort)
            lAddr = item.dwLocalAddr
            lAddr = socket.inet_ntoa(struct.pack('L', lAddr))
            portState = item.dwState

            # only record TCP ports where we're listening on our external
            #    (or all) connections
            if str(lAddr) != "127.0.0.1" and portState == MIB_TCP_STATE_LISTEN:
                portList.append(str(lPort) + "/TCP")

    else:
        print "Error occurred when trying to get TCP Table"

def getUDPOpenPorts():

    DWORD = ctypes.c_ulong
    NO_ERROR = 0
    NULL = ""
    bOrder = 0

    dwSize = DWORD(0)
    portList = []

    # call once to get dwSize
    ctypes.windll.iphlpapi.GetUdpTable(NULL, ctypes.byref(dwSize), bOrder)

    ANY_SIZE = dwSize.value # again, used out of convention
    #                            (see notes in TCP section)

    class MIB_UDPROW(ctypes.Structure):
        _fields_ = [('dwLocalAddr', DWORD),
                    ('dwLocalPort', DWORD)]

    class MIB_UDPTABLE(ctypes.Structure):
        _fields_ = [('dwNumEntries', DWORD),
                    ('table', MIB_UDPROW * ANY_SIZE)]

    udpTable = MIB_UDPTABLE()
    udpTable.dwNumEntries = 0 # define as 0 for our loops sake

    # now make the call to GetUdpTable to get the data
    if (ctypes.windll.iphlpapi.GetUdpTable(ctypes.byref(udpTable),
        ctypes.byref(dwSize), bOrder) == NO_ERROR):

        maxNum = udpTable.dwNumEntries
        placeHolder = 0
        while placeHolder < maxNum:

            item = udpTable.table[placeHolder]
            placeHolder += 1
            lPort = item.dwLocalPort

            lPort = socket.ntohs(lPort)
            lAddr = item.dwLocalAddr

            lAddr = socket.inet_ntoa(struct.pack('L', lAddr))

            # only record UDP ports where we're listening on our external
            #    (or all) connections
            if str(lAddr) != "127.0.0.1":
                portList.append(str(lPort) + "/UDP")
    else:
        print "Error occurred when trying to get UDP Table"

    portList.sort()

    return portList

def getTcpTable():
    """
    http://msdn.microsoft.com/library/default.asp?url=/library/en-us/iphlp/iphlp/ip_helper_start_page.asp
    http://aspn.activestate.com/ASPN/Mail/Message/ctypes-users/1966295
    http://aspn.activestate.com/ASPN/Cookbook/Python/Recipe/392572
    """
    NO_ERROR = 0
    NULL = ""

    #ERROR_ACCESS_DENIED  = 5L
    #ERROR_INVALID_PARAMETER = 87L
    #ERROR_NOT_SUPPORTED = 50L

    # define some MIB constants used to identify the state of a TCP port
    #MIB_TCP_STATE_CLOSED = 1
    #MIB_TCP_STATE_LISTEN = 2
    #MIB_TCP_STATE_SYN_SENT = 3
    #MIB_TCP_STATE_SYN_RCVD = 4
    #MIB_TCP_STATE_ESTAB = 5
    #MIB_TCP_STATE_FIN_WAIT1 = 6
    #MIB_TCP_STATE_FIN_WAIT2 = 7
    #MIB_TCP_STATE_CLOSE_WAIT = 8
    #MIB_TCP_STATE_CLOSING = 9
    #MIB_TCP_STATE_LAST_ACK = 10
    #MIB_TCP_STATE_TIME_WAIT = 11
    #MIB_TCP_STATE_DELETE_TCB = 12

    (TCP_TABLE_BASIC_LISTENER,
     TCP_TABLE_BASIC_CONNECTIONS,
     TCP_TABLE_BASIC_ALL,
     TCP_TABLE_OWNER_PID_LISTENER,
     TCP_TABLE_OWNER_PID_CONNECTIONS,
     TCP_TABLE_OWNER_PID_ALL,
     TCP_TABLE_OWNER_MODULE_LISTENER,
     TCP_TABLE_OWNER_MODULE_CONNECTIONS,
     TCP_TABLE_OWNER_MODULE_ALL) = map(ctypes.c_int, xrange(9))

    AF_INET = 2

    tcpTab = {}
    bOrder = 0
    # call once to get dwSize
    dwSize = DWORD(0)
    ctypes.windll.iphlpapi.GetExtendedTcpTable(NULL, ctypes.byref(dwSize), bOrder,
                                               AF_INET, TCP_TABLE_OWNER_PID_LISTENER, 0)
    ANY_SIZE = dwSize.value
    class MIB_TCPROW_OWNER_PID(ctypes.Structure):
        _fields_ = [('dwState', DWORD),
                    ('dwLocalAddr', DWORD),
                    ('dwLocalPort', DWORD),
                    ('dwRemoteAddr', DWORD),
                    ('dwRemotePort', DWORD),
                    ('dwOwningPid', DWORD)]

    class MIB_TCPTABLE_OWNER_PID(ctypes.Structure):
        _fields_ = [('dwNumEntries', DWORD),
                    ('table', MIB_TCPROW_OWNER_PID * ANY_SIZE)]
    tcpTable = MIB_TCPTABLE_OWNER_PID()
    tcpTable.dwNumEntries = 0 # define as 0 for our loops sake

    # now make the call to GetTcpTable to get the data
    if (ctypes.windll.iphlpapi.GetExtendedTcpTable(ctypes.byref(tcpTable),
                                                   ctypes.byref(dwSize),
                                                   bOrder,
                                                   AF_INET,
                                                   TCP_TABLE_OWNER_PID_LISTENER,
                                                   0) == NO_ERROR):
        maxNum = tcpTable.dwNumEntries
        placeHolder = 0
        # loop through every connection
        while placeHolder < maxNum:
            item = tcpTable.table[placeHolder]
            placeHolder += 1
            # format the data we need (there is more data if it is useful -
            #    see structure definition)
            lPort = socket.ntohs(item.dwLocalPort)
            lAddr = socket.inet_ntoa(struct.pack('L', item.dwLocalAddr))
            #rPort = socket.ntohs(item.dwRemotePort)
            #rAddr = socket.inet_ntoa(struct.pack('L', item.dwRemoteAddr))
            #portState = item.dwState
            pid = item.dwOwningPid
            # only record TCP ports where we're listening on our external
            #    (or all) connections
            if str(lAddr) != "127.0.0.1" :
                #src = (lAddr, lPort)
                #dst = (rAddr, rPort)
                tcpTab[pid] = lPort
    else:
        print "Error occurred when trying to get TCP Table"

    return tcpTab

