# _*_ coding: iso-8859-1 _*_
#!/usr/bin/env python

import logging, os, unicodedata
import traceback

import win32api as wa

import background
import ini
import js
import option
import perms
from printers import install_printers


"""
Actions logon effectues par l'utilisateur :
- fond d'cran
- imprimantes
- ini
- js
"""


def logon(esu_dict, user_dict):
    try:
        # fond d'ecran
        set_background(esu_dict['SID'], user_dict)
        # gestion des imprimantes
        logging.info('Installation des imprimantes')
        install_printers()
        # gestion des ini
        logging.info('Gestion des .ini')
        set_ini(user_dict['ini'])
        # gestion des js
        logging.info('Gestion des .js')
        set_js(user_dict['js'])
    except Exception, e:
        logging.error('%s'%e)
        logging.debug('Erreur %s'%traceback.format_exc())
    return True
    
def set_background(sid, user_dict):
    outbg = os.path.join(wa.GetTempPath(), 'cliscribe_bg.bmp')
    domname = option.get_nom_domaine()
    try:
        if not os.path.isfile(outbg): file(outbg, 'w').write('')
        perms.set_acl(outbg, domname)
    except: pass
    if option.get_esu_show_username() != 1:
        logging.debug("Application du fond d'ecran par defaut")
        background.del_backgrnd(outbg)
        background.apply_wallpaper(sid)
        return
    logging.debug('Option esu_show_username=%s'%option.get_esu_show_username())
    logging.info("Generation du fond d'ecran personnalise")
    message = user_dict['bckgrnd_msg'].splitlines()
    try: background.set_backgrnd(sid, message)
    except:
        logging.error("Echec de la mise en place du fond d'ecran")
        logging.debug('Erreur %s'%traceback.format_exc())

def set_js(js_list):
    if len(js_list) == 0:
        logging.debug('Liste JS vide : %s'%js_list)
        return
    try:
        for fich, var, value, typ in js_list:
            if value == 'IGNORE': continue
            rep = os.path.dirname(fich)
            logging.debug('JS : %s'%([fich, var, value, typ]))
            create_rep(rep)
            js.set_option(fich, var, value, typ)
    except Exception, e:
        logging.error('%s'%e)
        logging.debug('Erreur %s'%traceback.format_exc())

def set_ini(ini_list):
    if len(ini_list) == 0:
        logging.debug('Liste INI vide : %s'%ini_list)
        return
    try:
        for fich, sect, var, value, typ in ini_list:
            if value == 'IGNORE': continue
            rep = os.path.dirname(fich)
            logging.debug('INI : %s'%([fich, sect, var, value, typ]))
            create_rep(rep)
            ini.set_option(fich, sect, var, value, typ)
    except Exception, e:
        logging.error('%s'%e)
        logging.debug('Erreur %s'%traceback.format_exc())

def create_rep(rep):
    try:
        if not os.path.isdir(rep): os.makedirs(rep)
    except Exception, e:
        if type(rep) == unicode:
            rep = unicodedata.normalize("NFKD", rep).encode("ascii", "ignore" )
        logging.error('Erreur de creation du repertoire "%s" %s'%(rep, e))
        logging.debug('Erreur %s'%traceback.format_exc())

