# _*_ coding: iso-8859-1 _*_

import os, re, logging
import traceback
import ini
from reg import get_option
import option

def get_vars_from_dict(dict_list):
    """Certaines variables d'environnement peuvent avoir t
    redfinies dans la Console Esu. Il faut donc rcuprer leur
    valeur dans les dictionnaires de rgles (machine_dict['reg'] et user_dict['reg'])
    
    dict_list = [{'hkey': 'HKEY_LOCAL_MACHINE',
                 'keytype': 'REG_DWORD',
                 'keyname': 'ShutdownWithoutLogon',
                 'value': '1', 'keypath': 'Software\\Microsoft\\Windows\\CurrentVersion\\Policies\\System'},
                 {'hkey': 'HKEY_LOCAL_MACHINE',
                 ...},
                ]
    """
    var_liste = ['TEMP'
    ,'TMP'
    ,'USERNAME'
    ,'USERPROFILE'
    ,'USERDOMAIN'
    ,'HOMESHARE'
    ,'HOMEDRIVE'
    ,'LOGONSERVER'
    ,'ALLUSERSPROFILE'
    ,'APPDATA'
    ,'COMMONPROGRAMFILES'
    ,'PROGRAMFILES'
    ,'PERSONAL'
    ]
    varsdict = {}
    for i in dict_list:
        if i['keyname'].upper() in var_liste:
            try: varsdict[i['keyname'].upper()] = i['value']
            except: continue
    return varsdict

def get_scribe_vars():
    """Renvoie un dictionnaire des variable Scribe de la base de registre
    """
    d = {}
    d['EOLE_IP_SCRIBE'] = option.get_ip_scribe()
    d['EOLE_IP_ACCESS_LIST'] = option.get_ip_access_list()
    d['EOLE_INST_PATH'] = option.get_inst_path()
    d['EOLE_PORT_CLIENT'] = option.get_port_client()
    d['EOLE_PORT_SCRIBE'] = option.get_port_scribe()
    d['EOLE_PORT_UTILISATEUR'] = option.get_port_utilisateur()
    d['EOLE_NOM_SCRIBE'] = option.get_nom_scribe()
    d['EOLE_NOM_DOMAINE'] = option.get_nom_domaine()
    d['EOLE_DEBUG_LOGON'] = option.get_debug_logon()
    d['EOLE_LOG_LEVEL'] = option.get_log_level()
    d['EOLE_PORT_SCRIBE_UPDATE'] = option.get_port_scribe_update()
    d['EOLE_VNC_VIEWONLY'] = option.get_vnc_viewonly()
    return d

def gest_ini(chaine):
    """
'JS://%appdata%\\Mozilla\\Firefox\\??INI://%appdata%\\Mozilla\\FireFox\\profiles.ini?section=Profile0,variable=Path??\\prefs.js'
remplace "??INI://<chemin_fichier>,section=...,variable=...??" par la valeur de variable
de la section section dans <chemin_fichier>
    """
    if chaine.count('??') == 0: return chaine
    c = chaine.split('??', 1)[1].split('??')[0]
    if c.startswith("INI://"):
        fich = c.split('?')[0].split('INI://')[1]
        # si excut par le service, pas d'accs aux fichies dans U:
        if not os.path.isfile(fich): return chaine
        sect = c.split('?')[1].split(',')[0].split('=')[1]
        var = c.split('?')[1].split(',')[1].split('=')[1]
        val = ini.get_option(fich, sect, var)
        chaine = chaine.replace('??%s??'%c, val)
    return chaine

def replace_vars(chaine, opt_var_list=None):
    """remplace les variables %VAR% par os.environ['VAR']
    si opt_var_list est fourni, commence par l
    """
    try:
        if not opt_var_list:
            opt_var_list = dict(os.environ)
        d = get_scribe_vars()
        opt_var_list.update(d)
        opt_var_list['eolepath'] = get_option(r'Software\Eole\Scribe', 'inst_path')
        for var, val in opt_var_list.items():
            if not val: continue
            chaine = replace(chaine, '%%%s%%'%var, val)
        chaine = gest_ini(chaine)
        return chaine
    except Exception, e:
        logging.error('%s %s'%(e, [chaine, opt_var_list]))
        logging.debug('Erreur %s'%traceback.format_exc())
        return chaine

def replace(chaine, motif, value):
    """remplace motif par value dans chaine sans tenir compt de la casse
    """
    rpl = re.compile(motif, re.IGNORECASE)
    try: value = str(value)
    except: return chaine
    v = value.replace('\\', '\\\\')
    chaine = rpl.sub(v, chaine) # parce que 'C:\Doc\toto' renvoie 'C:\Doc     oto'
    return chaine

def convert(objet, vardict=None):
    """Parcour objet jusqu' trouver une chaine et remplace les variables par leur valeur
    Les variables sont %variable%
    vardict = {'variable' : valeur}
    """
    if type(objet) == list:
        return convlist(objet, vardict)
    if type(objet) == tuple:
        return tuple(convlist(objet, vardict))
    if type(objet) == dict:
        return convdict(objet, vardict)
    if type(objet) == unicode:
        return convuni(objet, vardict)
    if type(objet) == str:
        objet = replace_vars(objet, vardict)
    return objet

def convlist(objet, vardict):
    l = []
    for item in objet:
        l.append(convert(item, vardict))
    return l

def convdict(objet, vardict):
    dico={}
    for cle in objet.keys():
        dico[cle] = convert(objet[cle], vardict)
    return dico

def convuni(objet, vardict):
    string =  objet.encode('iso8859-1')
    return convert(string, vardict)

