#!/usr/bin/env python
# _*_ coding: iso-8859-1 _*_


import logging
import time
import os

import ini
import reg
import option
import process

from pbgest import CliPB
C = CliPB()
getrootobject, disconnect = C.getrootobject, C.disconnect

# Accs  l'environnement utilisateur
class uservnc:
    def lance_uservnc(self, action, val=None):
        d = getrootobject(ip='127.0.0.1', port=option.get_port_utilisateur())
        d.addCallback(lambda object: object.callRemote('uservnc', action, val))
        d.addCallback(disconnect)
        return d

lance_uservnc = uservnc().lance_uservnc


# Section VNC #
#
# Classe de gestion de VNC.
# pour l'affichage de l'cran d'un poste A sur un poste B :
#    * Poste B se met en coute
#    * Poste A se connecte  Poste B
#
# Les commandes sont lances dans l'environnement utilisateur
# Actions possibles :
#    * vncviewer.exe :
#        * mise en coute (/listen)
#        * arrt de l'coute (killProcess)
#    * winvnc.exe :
#        * connexion (winvnc.exe -connect)  un hte distant ( l'coute)
#        * arrt de la connexion (killProcess)
#        * mise en coute (authentification ncessaire)
# Pour "vncviewer /listen", il faut au pralable lancer winvnc.exe
#
# Modification du type de contrle (desactive|simple|controle) pour gestion-postes
#
# Configuration VNC de l'activation (ou non) du clavier et de la souris
#
class Vnc:
    """Gestion vnc distante. Actions possibles :
            - start (winvnc.exe)
            - start_listen (vncviewer.exe /listen)
            - connect (winvnc -connect ip)
            - stop
            - stop_listen
            - disconnect
            - setinputs True/False (gestion clavier/souris)
    """
    def __init__(self, vncdir):
        self.vncdir = vncdir
        self.vnc_conf = os.path.join(self.vncdir, 'eole_conf.vnc')
        self.vnc_ini = os.path.join(self.vncdir, 'ultravnc.ini')
        self.winvnc_exe = os.path.join(self.vncdir, 'winvnc.exe')
        self.vncviewer = os.path.join(self.vncdir, 'vncviewer.exe')
        
    ###################
    ## Configuration ##
    ###################
    def setinputs(self, val=False, restart=True):
        """(ds)activer souris/clavier (activ par dfaut) pour winvnc.exe
        """
        logging.debug("Application du type de controle 'setinputs' var=%s"%val)
        if val == '1' or val == True: t = '1'
        else: t = '0'
        # la BDR n'est plus utilise, remplace par "ultravnc.ini"
        # reg_liste = [{ 'hkey' : 'HKEY_LOCAL_MACHINE', 'keypath' : r'SOFTWARE\ORL\WinVNC3\Default',
        #               'keyname' : 'InputsEnabled', 'keytype' : 'REG_DWORD', 'value' : t}]
        # reg.put_regs(reg_liste)
        ini.set_option(self.vnc_ini, 'admin', 'InputsEnabled', t, 'BOOLEAN')
        if self.isrunning() and restart:
            self.stop() # le dmarrage est fait lors de l'observation/diffusion
        
    def set_type(self, type):
        """Renseigne le mode d'observation autorise dans l'EAD pour Gestion-postes
        """
        reg_liste = [{ 'hkey' : 'HKEY_LOCAL_MACHINE', 'keypath' : 'Software\\Eole\\Scribe',
                       'keyname' : 'vnc_viewonly', 'keytype' : 'REG_SZ', 'value' : type}]
        return reg.put_regs(reg_liste)

    ################
    ## VNC Server ##
    ################
    def start(self):
        """connecter une ip qui est en mode "listen"
        """
        return lance_uservnc('start')
    
    def stop(self):
        """Mthode la plus sre (radicale) pour arrter "winvnc"
        A pour inconvnient de laisser l'icne  ct de l'heure.
        """
        logging.debug("Tentative d'arret de winvnc")
        if not self.isrunning(): return True
        ret = process.killProcName('winvnc.exe')
        logging.debug('"winvnc.exe" arrete')
        # attendre le temps que le port se ferme
        time.sleep(1)
        return ret

    def isrunning(self):
        """Y'a-t-il un procesus "winvnc.exe" ?
        """
        return process.isrunning('winvnc.exe')
    
    def connect(self, ip):
        """connecter une ip qui est en mode "listen"
        """
        return lance_uservnc('connect', ip)
    
    def disconnect(self):
        """Forcer la dconnexion en stoppant winvnc.exe
        """
        self.stop()
    
    ################
    ## VNC Viewer ##
    ################
    def start_listen(self, args=None, conf=None):
        """se mettre en mode listen
        """
        if not args: args = ''
        if conf: file(self.vnc_conf, 'w').write(conf)
        return lance_uservnc('start_listen')
        
    def stop_listen(self):
        """kill self.listen_pid"""
        process.killProcName('vncviewer.exe')
    
