# _*_ coding: iso-8859-1 _*_

# from twisted.internet import reactor

import os
import time
import shutil
import logging
import urllib2, md5

import win32api as wa

from logging.handlers import RotatingFileHandler

from eole.ini import get_option
from eole.os_type import type_os
from eole.perms import AdjustPrivilege
from eole.lance_cmd import lancecmd
from eole import option, reg
from eole.log import SERVICEMAJ_LOG, FORMATTER

class upDater:
    def __init__(self, restart=True):
        """
        fichier de configuration "install.ini" (contient la version du client)
        setup a telecharger "cliscribe-setup.exe"
        self.inst_path: chemin d'installation des applications (%WINDIR%\Eole)
        self.tmpdir: repertoire de telechargement/decompactage (%WINDIR%\Eole\tmp)
        """
        # creation du logger
        self.set_logger()
        # redemarrer auto en fin d'install ?
        self.restart = restart
        # type de l'OS
        self.type_os = type_os
        # nom du fichier a telecharger
        self.setup = option.setup_name()
        self.unin_key = option.unin_key()
        # le repertoire temporaire pour le telechargement
        self.inst_path = option.get_inst_path()
        self.tmpdir = os.path.join(self.inst_path, 'tmp')
        # fichier de configuration
        self.conf_f_name = 'install.ini'
        self.conf_f = os.path.join(self.inst_path, self.conf_f_name)
        # adresse ip scribe et port du serveur de fichiers
        self.serveur = option.get_ip_scribe()
        self.port = int(option.get_port_scribe_update())

    def set_logger(self):
        # on log sur 2 fichiers de 100ko
        handler = RotatingFileHandler(SERVICEMAJ_LOG, 'a', 100000, 2)
        handler.setFormatter(FORMATTER)
        self.log = logging.getLogger(SERVICEMAJ_LOG)
        self.log.addHandler(handler)
        self.log.setLevel(option.get_log_level())

    #################
    ## Mise a jour ##
    #################
    def update(self):
        """telecharge self.setup (inclue comparatif checksum)
        desinstalle l'ancienne version
        installe la nouvelle
        """
        # Une ligne blanche pour mieux voir
        self.log.info('')
        # Faut-il mettre a jour ?
        if not self.test_update():
            return True
        # Oui
        self.log.info(u'Mise a jour declenchee')
        # options eventuelles d'installation
        inst_args = get_option(self.tmp_conf_f, 'global', 'inst_args')
        # telechargement et verification de l'archive
        if not self.download(self.setup):
            return False
        # desinstallation
        unin = self.uninstall_old()
        if not unin: 
            return False
        elif unin == 'reboot':
            return True
        # installation de la nouvelle version
        self.log.info('Installation de la version %s'%self.new_ver)
        cmd = '%s %s'%(os.path.join(self.tmpdir, self.setup), inst_args)
        self.log.debug(u'%s'%cmd)
        ret = lancecmd(cmd)
        if ret != 0:
            self.log.error(u'Installation echouee (code retour : %s)'%ret)
            return False
        self.log.info(u'Mise a jour terminee')
        os.remove(self.conf_f)
        shutil.copy(self.tmp_conf_f, self.conf_f)
        self.clean_tmp()
        self.reboot()
    
    def test_update(self):
        """compare le numero de version local et distant (telechargement de self.serveur/install.ini)
        si local inferieur a distant, lance la mise a jour
        return True : il faut mettre a jour/installer le client
        return False : le client est installe et a jour ou il est impossible d'installer/mettre a jour
        """
        # version du client actuellement installe
        if not os.path.isfile(self.conf_f):
            self.log.error("Fichier %s introuvable"%self.conf_f)
            return False
        self.cur_ver = int(get_option(self.conf_f, 'global', 'version'))
        # version = 0 sur la station permet de desactiver la MAJ du client Scribe
        if self.cur_ver == 0:
            self.log.warning("Mise a jour desactivee sur cette machine (Version locale = 0)")
            return False
        # telechargement de http://<scribe>/install.ini
        self.tmp_conf_f = self.download(self.conf_f_name)
        if not self.tmp_conf_f:
            return False
        # recuperation du numero de version distant
        self.new_ver = int(get_option(self.tmp_conf_f, 'global', 'version'))
        self.log.info('Test de version => current : %s, new : %s'%(self.cur_ver, self.new_ver))
        self.old_ver = self.cur_ver
        # version = 0 sur le serveur permet de desactiver la MAJ du client Scribe sur toutes les stations
        if self.new_ver == 0:
            self.log.warning('Mise a jour du client desactivee (version serveur = 0)')
            self.clean_tmp()
            return False
        # numero de version superieur ou egal a celui du serveur et client deja installe
        # TODO mettre en BDR la key d'uninstall
        if not reg.get_option(self.unin_key, 'UninstallString'):
            self.log.info('Cle "%s" non trouvee, installation du client necessaire'%self.unin_key)
            return True
        if self.cur_ver >= self.new_ver:
            self.log.info('Rien a faire ...')
            return False
        return True

    def uninstall_old(self):
        """desinstallation de l'ancien paquet
        - par uninstall si le precedent etait cliscribe-setup.exe (mode silencieux "/verysilent")
        - par l'ancienne methode pour cliscribe V1
        """
        old = reg.get_option(self.unin_key, 'UninstallString')
        # cas InnoSetup
        if not old:
            self.log.info('Rien a desinstaller')
            return True
        self.log.info(u'Desinstallation de la version %s'%self.old_ver)
        # Tester si a redemarre tout seul si necessaire.
        # options eventuelles d'installation
        try: uninst_args = get_option(self.tmp_conf_f, 'global', 'uninst_args')
        except: uninst_args = ''
        cmd = '%s %s'%(eval(old), uninst_args)
        self.log.debug(cmd)
        ret = lancecmd(cmd)
        if ret != 0:
            self.log.error(u'Desinstallation echouee (code retour : %s)'%ret)
            return False
        # l'installeur InnoSetup n'arrive pas a redemarrer quand il est lance par le service
        self.reboot()
        return 'reboot'
    
    def clean_tmp(self):
        """purge du repertoire temporaire
        """
        try: shutil.rmtree(self.tmpdir)
        except: pass
        return True
                
    ####################
    ## telechargement ##
    ####################
    def download(self, fich):
        """supprime le repertoire self.tmpdir et le recree
        telecharge "fich" et "fich.MD5SUM" et compare les checksums
        """
        self.log.info('Telechargement de %s'%fich)
        try:
            if not os.path.exists(self.tmpdir):
                os.makedirs(self.tmpdir)
            return self.get_file(fich)
        except Exception, e:
            self.log.error(e)
            return False

    def get_file(self, fich):
        """telecharge "fich" et "fich.MD5SUM" sur self.serveur
        calcul le checksum de fich et le compare a celui contenu dans "fich.MD5SUM"
        """
        dest = os.path.join(self.tmpdir, fich)
        dest5 = '%s.MD5SUM'%dest
        for i in [dest, dest5]:
            if os.path.exists(i):
                os.remove(i)
        url = 'http://%s:%s/%s'%(self.serveur, self.port, fich)
        url5 = '%s.MD5SUM'%url
        self.log.debug(u'Telechargement de %s'%url)
        for i in range(5): # 5 essais pour telecharger
            try:
                fc = urllib2.urlopen(url).read()
                break
            except Exception, e:
                self.log.error(e)
                if i == 4: return
                time.sleep(2) # attendre
        file(dest, 'wb').write(fc)
        # le md5sum
        self.log.debug(u'Telechargement de %s'%url5)
        for i in range(5): # 5 essais pour telecharger
            try:
                fc5 = urllib2.urlopen(url5).read()
                break
            except Exception, e:
                self.log.error(e)
                if i == 4: return
                time.sleep(2) # attendre
        file(dest5, 'wb').write(fc5)
        if not self.check_sum(dest, dest5): return False
        return dest
        
    def check_sum(self, fich, sumfich):
        """recupere le checksum contenu dans sumfich,
        calcule le checksum de fich
        et compare les deux
        """
        orig_sum = file(sumfich, 'r').readlines()[0].strip().split()[0].strip()
        dest_sum = md5.md5(file(fich, 'rb').read()).hexdigest().strip()
        if orig_sum == dest_sum:
            self.log.debug('checksum OK %s'%orig_sum)
            return True
        else:
            self.log.error('checksum ERROR : %s=%s, %s=%s'%(sumfich, orig_sum, fich, dest_sum))
            return False

    #################
    ## redemarrage ##
    #################
    def reboot(self): #, message="", timeout=0, bForce=0, bReboot=1):
        """Sur XP < SP2 le redemarrage lors de la MAJ plantouille, il faut ouvrir une session
        aussitt le systeme redemarre. Pas de pb apparent avec SP2 (et vista)
        """
        if not self.restart: return
        self.log.info('Redemarrage')
        time.sleep(2)
        if self.type_os in ['WinXP', 'Win2K', 'Vista']:
            AdjustPrivilege('SeShutdownPrivilege')
            while True:
##                wa.WinExec('shutdown -r -t 0 -f', 0)
                # Differentes methode pour redemarrer mais la suivante semble tre la plus officielle
                try:
                    wa.InitiateSystemShutdown(None, '', 0, True, 1) #message, timeout, bForce, bReboot)
                    break
                except Exception, e:
                    continue
##                    self.log.debug('%s'%e)
##                try:
##                    wa.ExitWindowsEx(wc.EWX_REBOOT|wc.EWX_FORCE, 0)
##                    break
##                except Exception, e:
##                    self.log.debug('%s'%e)
##                try:
##                    wts.WTSShutdownSystem(wts.WTS_CURRENT_SERVER_HANDLE, wts.WTS_WSD_REBOOT)
##                    break
##                except Exception, e:
##                    self.log.debug('%s'%e)
                time.sleep(2)
        elif self.type_os in ['Win95']:
            cmd = os.path.join(os.environ['WINDIR'], r'system\runonce.exe -q')
            wa.WinExec(cmd)
        # if reactor.running:
            # reactor.stop()
    
def main():
    updt = upDater()
    updt.update()
    # if reactor.running:
        # reactor.stop()

if __name__ == '__main__':
    main()
    # reactor.run()
