# _*_ coding: iso-8859-1 _*_
#########################################
# Gnration du service client SCRIBE   #
# pour la gestion du poste              #
# licence GPL Eole                      #
#########################################

import win32serviceutil
import win32service
import win32event
import win32evtlogutil

class MyService(win32serviceutil.ServiceFramework):
    """
       Dfinition du service Windows
    """
    _svc_name_ = "servupdate"
    _svc_display_name_ = "Service de MAJ du Client Scribe"
    _svc_deps_ = ["EventLog"]
    
    def __init__(self, args):
        """Docstring
        """
        win32serviceutil.ServiceFramework.__init__(self, args)
        self.hWaitStop = win32event.CreateEvent(None, 0, 0, None)

    def SvcDoRun(self):
        """Methode de demarrage du service
        """
        import servicemanager
        win32evtlogutil.AddSourceToRegistry(self._svc_name_,
                servicemanager.__file__)
        # Write a 'started' event to the event log...
        win32evtlogutil.ReportEvent(self._svc_name_,
                                    servicemanager.PYS_SERVICE_STARTED,
                                    0, # category
                                    servicemanager.EVENTLOG_INFORMATION_TYPE,
                                    (self._svc_name_, ''))
        # l'import de reactor permet de s'assurer que le reseau est disponible
        # Tant que ipfw n'est pas lanc, l'import plante
        while True:
            try:
                from twisted.internet import reactor
                break
            except: continue
        import updater
        updater.main()
        # reactor.run(installSignalHandlers=0)

        # and write a 'stopped' event to the event log.
        win32evtlogutil.ReportEvent(self._svc_name_,
                                    servicemanager.PYS_SERVICE_STOPPED,
                                    0, # category
                                    servicemanager.EVENTLOG_INFORMATION_TYPE,
                                    (self._svc_name_, ''))
    
    def SvcStop(self):
        """Methode d'arret du service
        """
        self.ReportServiceStatus(win32service.SERVICE_STOP_PENDING)
        win32event.SetEvent(self.hWaitStop)

    #c'est un appel diffrent quand on reboot/halt
    #que pour 'net stop servscribe'
    SvcShutdown = SvcStop


if __name__ == '__main__':
    # Note that this code will not be run in the 'frozen' exe-file!!!
    win32serviceutil.HandleCommandLine(MyService)
