#! /usr/bin/env python
# -*- coding: UTF-8 -*-

###########################################################################
# Eole NG - 2007
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
#
# dyn-logon.py
#
# Script de génération de fichiers netlogon depuis LDAP
#
###########################################################################

import time
import commands
from optparse import OptionParser
from horus import backend
import os
import sys
__version__ = "0.99"

retour = '\n'

def log_connexion(opt):
    """
    enregistrement des connexions
    """
    sdate = commands.getoutput('date +%a" "%d" "%b" "%Y" "%H":"%M').capitalize()
    primgrp = commands.getoutput('id -gn %s' % opt.user)
    cmd = 'echo CONNECTION %s %s %s %s %s %s %s' % (sdate, opt.user, primgrp, opt.machine,
                                                 opt.os, opt.ip, opt.pid)
    os.system('%s >> /var/log/samba/connexions.log' % (cmd))
    os.system('%s >> /var/log/samba/log.%s' % (cmd, opt.machine))

def get_share_attr(share):
    """renvoie "groupe", "name", "uri", "path", "drive"=None
    """
    groupe = share[1]['sambaShareGroup'][0]
    name = share[1]['sambaShareName'][0]
    uri = share[1]['sambaShareURI'][0]
    path = share[1]['sambaFilePath'][0]
    try: drive = share[1]['sambaShareDrive'][0]
    except: drive = None
    return groupe, name, uri, path, drive

def gen_groupedir(user, user_group_dir):
    """Suppression du répertoire contenant les liens vers les groupes de l'utilisateur
    et (re)construction du répertoire
    """
    # visiblement os.removedirs()  n'est pas si récursif que ça !
    os.system('rm -rf %s'%user_group_dir)
    os.makedirs(user_group_dir)
    os.system('/bin/chown %s %s'%(user, user_group_dir))
    os.system('setfacl -bk %s'%user_group_dir)
    os.chmod(user_group_dir,0500) # pas d'écriture à la racine  S:

def get_scripts(user,groups,machine,os_type):
    """
    gestion des scripts bat personnalisés
    +--path_scripts/users/<user>.txt
    +--path_scripts/groups/<group>.txt
    +--path_scripts/machines/<machine>.txt
    +--path_scripts/os/<os>.txt
    +--path_scripts/os/<os>/<group>.txt
    +--path_scripts/os/<os>/<user>.txt
    """
    motif_include = [ "%%NetUse%%", "%NetUse%" ]
    path_scripts = '/home/netlogon/scripts'
    buffer_debut = ""
    buffer_fin = retour
    # on créé la liste des fichiers possibles
    chemins = []
    chemins.append(os.path.join(path_scripts, 'users', '%s.txt'%user))
    chemins.append(os.path.join(path_scripts, 'machines', '%s.txt'%machine))
    for group in groups:
        chemins.append(os.path.join(path_scripts, 'groups', '%s.txt'%group))
        chemins.append(os.path.join(path_scripts, 'os', os_type, '%s.txt'%group))
    chemins.append(os.path.join(path_scripts, 'os', '%s.txt'%os_type))
    chemins.append(os.path.join(path_scripts, 'os', os_type, '%s.txt'%user))
    # on traite ceux qui sont présents
    for chemin in chemins:
        if os.path.isfile(chemin):
            fic = open(chemin,"r")
            debut = 1
            for line in fic.readlines():
                if line.strip() in motif_include:
                    debut = 0
                else:
                    if debut == 1:
                        buffer_debut += line.strip()+retour
                    else:
                        buffer_fin += line.strip()+retour
    return (buffer_debut,buffer_fin)

def parse_command_line():
    """
    traitement de la ligne de commande
    option.user
    option.machine
    option.os
    option.ip
    option.pid
    """
    parser = OptionParser(__doc__, version='%%prog version %s' % __version__)

    parser.add_option('-u', '--user', action='store', dest='user',
                      help='login', metavar='LOGIN')
    parser.add_option('-o', '--os', action='store', dest='os',
                      help="type d'OS", metavar='TYPE_OS',
                      choices=['Win95', 'Win2K', 'WinXP', 'Win2K3', 'Vista'])
    parser.add_option('-m', '--machine', action='store', dest='machine',
                      help="nom de machine", metavar='NOM_MACHINE')
    parser.add_option('-i', '--ip', action='store', dest='ip',
                      help="adresse ip", metavar='ADR_IP')
    parser.add_option('-p', '--pid', action='store', dest='pid',
                      help="pid smbd", metavar='PID', default='unknown')

    options, args = parser.parse_args()

    if len(args) >= 1:
        parser.error("le script ne prend pas d'argument")
    if options.user is None:
        parser.error("pas de nom de login")
    if options.machine is None:
        parser.error("pas de nom de machine")
    if options.os is None:
        parser.error("pas de type d'OS")
    if options.ip is None:
        parser.error("pas de type d'IP")

    return options

def main():

    script = ""
    # gestion de la ligne de commande
    opt = parse_command_line()

    # données de l'utilisateur
    try:
        user_data = backend.ldapsearch("(&%s(uid=%s))" % (backend.user_filters, opt.user))[0][1]
    except:
        sys.exit("Utilisateur %s non trouvé" % opt.user)

    batfile = "/home/netlogon/%s%s.txt"%(opt.user, opt.os)
    batfiletodel = "/home/netlogon/%s%s.bat"%(opt.user, opt.os)
    batfiletodel2 = "/home/netlogon/%s.bat"%(opt.user)
    #si le fichier existe déjà et qu'il a moins de 1min on loggue juste la connexion
    if os.path.isfile(batfile):
        diff = time.time() - os.path.getmtime(batfile)
        if diff >= 0 and diff <= 60:
            log_connexion(opt)
            sys.exit(0)

    user_groups = backend.get_user_groups(opt.user)

    # le répertoire "$HOME/groupes"
    user_group_dir = os.path.join(user_data['homeDirectory'][0], 'groupes')
    # création du répertoire
    gen_groupedir(opt.user, user_group_dir)

    shares = backend.ldapsearch(backend.share_filters)

    for share in shares:
        groupe, name, uri, path, drive = get_share_attr(share)
        if groupe in user_groups:
            if not drive:
                os.symlink(path, os.path.join(user_group_dir, name))
                # pas de lettre -> montage en dernier
            else:
                script += 'lecteur,%s,%s\n'%(drive, uri)

    # scripts perso
    debut,fin = get_scripts(opt.user, user_groups, opt.machine, opt.os)

    try:
        fic = open(batfile,"w")
        fic.write('%s%s%s'%(debut,script,fin))
        fic.close()
        os.system("/usr/bin/todos -u %s" % batfile)
        os.system("chmod 0644 %s" % batfile)
        # on supprime le .bat pour éviter les conflits http://dev-eole.ac-dijon.fr/issues/5460
        if os.path.isfile(batfiletodel): os.unlink(batfiletodel)
        if os.path.isfile(batfiletodel2): os.unlink(batfiletodel2)
    except Exception, e:
            sys.exit("erreur d'écriture du fichier %s : %s" % (batfile, e))

    log_connexion(opt)


if __name__ == '__main__':
    try:
        main()
    except Exception, e:
        file('/tmp/dyn-logon.errors','w').write('%s'%e)

