# -*- coding: UTF-8 -*-
###########################################################################
# Eole NG - 2007
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
#
# machines.py
#
# Librairie de gestion des machines
#
###########################################################################

import sys, commands
sys.path.append('/usr/share/eole/client')

class Machines:
    def __init__(self):
        self.__init__machinesdb()

    def __init__machinesdb(self):
        """Charge une liste contenant l'historique des connexions, le premier élément
        est la connexion la plus récente
        # ('vm-xp3-sp2', 'WinXP', '172.16.0.185')
        """
        # Le fichier machines.db est renseigné à chaque démarrage du service Scribe
        # sur les stations (à chaque boot). Il contient "nom:ip:os"
        self.fich = '/usr/share/eole/client/machines.db'
        lignes = file(self.fich).read().splitlines()
        self.machinesdb = {}
        self.ipdb = {}
        for l in lignes:
            try:
                if len(l.split(';')) == 3:
                    mach, ip, ost = l.split(';')
                    mac = None
                elif len(l.split(';')) == 4:
                    mach, ip, ost, mac = l.split(';')
                self.machinesdb[mach] = (ip, ost, mac)
                self.ipdb[ip] = (mach, ost, mac)
            except: continue

    def get_ip(self, mach):
        if self.machinesdb.has_key(mach):
            return self.machinesdb[mach][0]
        else:
            raise Exception('Machine %s non trouvée' % mach)

    def get_nom(self, ip):
        if self.ipdb.has_key(ip):
            return self.ipdb[ip][0]
        else:
            raise Exception('Machine %s non trouvée' % ip)

    def get_os(self, mach):
        if self.machinesdb.has_key(mach):
            return self.machinesdb[mach][1]
        else:
            raise Exception('Machine %s non trouvée' % mach)

    def get_mac(self, mach):
        if self.machinesdb.has_key(mach):
            return self.machinesdb[mach][2]
        else: return # les adresses MAC ne sont pas forcément renseignée donc pas de "raise"

    def isup(self, ip):
        cmd = 'tcpcheck 1 %s:8788'%ip
        r = commands.getstatusoutput(cmd)[1].strip().lower().endswith('alive')
        return r

def get_ip(mach):
    """renvoie l'ip depuis un nom de machin
    """
    return Machines().get_ip(mach)

def get_nom(ip):
    """renvoie le nom de machine depuis une ip
    """
    return Machines().get_nom(ip)

def get_os(mach):
    """renvoie la version de l'OS depuis un nom de machine
    """
    return Machines().get_os(mach)

def get_mac(mach):
    """renvoie l'adresse MAC depuis un nom de machine
    """
    return Machines().get_mac(mach)

def isup(ip):
    """renvoie si le port 8788 d'IP est accessible
    """
    return Machines().isup(ip)

def get_machines():
    """renvoie la liste des noms de machines
    """
    return Machines().machinesdb.keys()

