; Fichier InnoSetup de cration de l'installeur du Client Scribe
; clieole-setup.exe doit tre accompagn d'un fichier "install.ini"
; plac dans le mme rpertoire.
;
; Ce fichier contient :
; [global]
; ip_scribe = %adresse_ip_eth0
; nom_scribe = %smb_netbios_name
; nom_domaine = %smb_workgroup
; port_scribe = 8789
; port_scribe_update = 8790
; port_client = 8788
; port_utilisateur = 8791
; version = 1 # sert  dclencher ou non la MAJ par updater.exe
; client_gw = x.x.x.x;
;
;
; installation de Inno Setup, ISPP
;
;
; * les cls de registres sont spcifies dans la partie [Registry].
; Certaines cls sont types avec MinVersion voir la doc InnoSetup pour les dtails
; * les services sont installs dans la partie [Run]

#define IpScribe "{ini:{src}\install.ini,global,ip_scribe|0.0.0.0}"
#define IpAccessList "['{ini:{src}\install.ini,global,ip_scribe|1.1.1.1}']"
#define PortClient "{ini:{src}\install.ini,global,port_client|8788}"
#define PortScribe "{ini:{src}\install.ini,global,port_scribe|8789}"
#define PortScribeUpdate "{ini:{src}\install.ini,global,port_scribe_update|8790}"
#define PortUtilisateur "{ini:{src}\install.ini,global,port_utilisateur|8791}"
#define NomScribe "{ini:{src}\install.ini,global,nom_scribe|scribe}"
#define NomDomaine "{ini:{src}\install.ini,global,nom_domaine|workgroup}"
#define DebugLogon "{ini:{src}\install.ini,global,debug_logon|1}"
#define LogLevel "{ini:{src}\install.ini,global,log_level|debug}"
#define ClientGw "{ini:{src}\install.ini,global,client_gw|any}"

#define InnoSources "U:\git\eole-client\sources"
#define CliScribeInnoSources InnoSources + "\all\dists\cliscribe"
#define VNCInnoSources InnoSources + "\ultravnc"
#define WipfwInnoSources InnoSources + "\wipfw"
#define ImagesDir InnoSources + "\all\images"
#define CliScribeOutputDir InnoSources

#define AppVersion GetFileVersion(CliScribeInnoSources + "\servscribe.exe")

;#define InnoNuWinCSources InnoSources + "\nuwinc"

[Setup]
AppName=Client Eole ({#AppVersion})
; AppId sert  reconnaitre l'application
AppId=CliEole
AppVerName=Client Eole ({#AppVersion})
AppPublisher=quipe Eole
AppPublisherURL=http://eole.orion.education.fr/
AppSupportURL=http://eole.orion.education.fr/
AppUpdatesURL=http://eole.orion.education.fr/
AppVersion={#AppVersion}
VersionInfoVersion={#AppVersion}
VersionInfoCompany=Eole
VersionInfoDescription=Client Eole
VersionInfoCopyright=Eole
AppCopyright=Eole
DefaultDirName={win}\Eole
; interdit la modification du chemin d'installation
DisableDirPage=true
; interdit la modification du chemin de copie des icnes
DisableProgramGroupPage=true
OutputDir={#CliScribeOutputDir}
OutputBaseFilename=clieole-setup
PrivilegesRequired=admin
AllowCancelDuringInstall=false
SetupIconFile={#ImagesDir}\eole.ico
UninstallDisplayIcon={app}\cliscribe\servscribe.exe
;WizardImageFile=eole.bmp
WizardImageFile={#ImagesDir}\logo-eole.bmp
;WizardImageStretch=false
WizardSmallImageFile={#ImagesDir}\eole.bmp
;InfoAfterFile=licence_nufw.txt
AlwaysRestart=false
ChangesEnvironment=true
ArchitecturesInstallIn64BitMode=x64 ia64
CloseApplications=false


[Languages]
Name: french; MessagesFile: compiler:Languages\French.isl

[Files]
Source: "{#CliScribeInnoSources}\*"; DestDir: "{app}\cliscribe"; Flags: ignoreversion recursesubdirs createallsubdirs restartreplace uninsrestartdelete
; BeforeInstall: CopySc
Source: "{#VNCInnoSources}\ultravnc-32\*"; DestDir: "{app}\ultravnc"; Flags: ignoreversion createallsubdirs recursesubdirs restartreplace uninsrestartdelete; Check: not Is64BitInstallMode; MinVersion: 5.0.2195
; OnlyBelowVersion: 6.2.9200
Source: "{#VNCInnoSources}\ultravnc-64\*"; DestDir: "{app}\ultravnc"; Flags: ignoreversion createallsubdirs recursesubdirs restartreplace uninsrestartdelete; Check: Is64BitInstallMode; MinVersion: 5.0.2195
; OnlyBelowVersion: 6.2.9200
; Source: "{#VNCInnoSources}\ultravnc8\x86\*"; DestDir: "{app}\ultravnc"; Flags: ignoreversion createallsubdirs recursesubdirs restartreplace uninsrestartdelete; Check: not Is64BitInstallMode; MinVersion: 6.2.9200
; Source: "{#VNCInnoSources}\ultravnc8\x64\*"; DestDir: "{app}\ultravnc"; Flags: ignoreversion createallsubdirs recursesubdirs restartreplace uninsrestartdelete; Check: Is64BitInstallMode; MinVersion: 6.2.9200

; Wipfw version NuFW
Source: "{#WipfwInnoSources}\ipfw.exe"; DestDir: "{win}\system32\"; Flags: ignoreversion recursesubdirs createallsubdirs restartreplace uninsrestartdelete; MinVersion: 0,5.0.2195
Source: "{#WipfwInnoSources}\ip_fw.sys"; DestDir: "{win}\system32\drivers\"; Flags: ignoreversion recursesubdirs createallsubdirs restartreplace uninsrestartdelete; MinVersion: 0,5.0.2195
Source: "{#WipfwInnoSources}\config.cmd"; DestDir: "{app}\wipfw\"; Flags: ignoreversion recursesubdirs createallsubdirs restartreplace uninsrestartdelete; MinVersion: 0,5.0.2195; OnlyBelowVersion: 0,6.0.6000; AfterInstall: ConfigWipfw
; ce fichier est cr dynamiquement car il contient l'IP de Scribe
Source: "{#WipfwInnoSources}\wipfw.conf"; DestDir: "{app}\wipfw\"; Flags: ignoreversion recursesubdirs createallsubdirs restartreplace; MinVersion: 0,5.0.2195

; NuFW
;Source: {#InnoSources}\NuWINc\common\*; DestDir: {app}\NuWINc; Flags: ignoreversion recursesubdirs createallsubdirs restartreplace uninsrestartdelete
;Source: {#InnoSources}\NuWINc\WIN9X\*; DestDir: {app}\NuWINc; Flags: ignoreversion recursesubdirs createallsubdirs restartreplace uninsrestartdelete; MinVersion: 4.0.950,5.0.2195; OnlyBelowVersion: 0,5.0.2195sp3
;Source: {#InnoSources}\NuWINc\WIN2K\*; DestDir: {app}\NuWINc; Flags: ignoreversion recursesubdirs createallsubdirs restartreplace uninsrestartdelete; MinVersion: 0,5.0.2195sp3; OnlyBelowVersion: 0,5.0.2195sp9
;Source: {#InnoSources}\NuWINc\WINXP\*; DestDir: {app}\NuWINc; Flags: ignoreversion recursesubdirs createallsubdirs restartreplace uninsrestartdelete; MinVersion: 0,5.01.2600; OnlyBelowVersion: 0,5.01.2600sp9
;Source: {#InnoSources}\NuWINc\VISTA\nuwinc-drv.inf; DestDir: {sys}; Flags: ignoreversion restartreplace uninsrestartdelete; MinVersion: 0,6.0.6000
;Source: {#InnoSources}\NuWINc\VISTA\nuwinc-drv.sys; DestDir: {sys}; Flags: ignoreversion restartreplace uninsrestartdelete; MinVersion: 0,6.0.6000; Languages:
;Source: {#InnoSources}\NuWINc\VISTA\*; DestDir: {app}\NuWINc; Flags: ignoreversion recursesubdirs createallsubdirs restartreplace uninsrestartdelete; MinVersion: 0,6.0.6000
; NuFW
;Source: {#InnoNuWinCSources}\common\*; DestDir: {app}\NuWINc; Flags: ignoreversion recursesubdirs createallsubdirs restartreplace uninsrestartdelete
;Source: {#InnoNuWinCSources}\WIN9X\*; DestDir: {app}\NuWINc; Flags: ignoreversion recursesubdirs createallsubdirs restartreplace uninsrestartdelete; MinVersion: 4.1.1998,0
;Source: {#InnoNuWinCSources}\WIN2K_SP3\*; DestDir: {app}\NuWINc; Flags: ignoreversion recursesubdirs createallsubdirs restartreplace uninsrestartdelete; MinVersion: 0,5.0.2195sp3; OnlyBelowVersion: 0,5.0.2195sp9
;Source: {#InnoNuWinCSources}\WINXP\*; DestDir: {app}\NuWINc; Flags: ignoreversion recursesubdirs createallsubdirs restartreplace uninsrestartdelete; MinVersion: 0,5.01.2600; OnlyBelowVersion: 0,5.02.3790sp9
;Source: {#InnoNuWinCSources}\VISTA\nuwinc.exe; DestDir: {app}\NuWINc; Flags: ignoreversion recursesubdirs createallsubdirs restartreplace uninsrestartdelete; MinVersion: 0,6.0.6000
;Source: {#InnoNuWinCSources}\VISTA\nuwinc-drv.inf; DestDir: {sys}; Flags: ignoreversion restartreplace uninsrestartdelete; MinVersion: 0,6.0.6000
;Source: {#InnoNuWinCSources}\VISTA\nuwinc-drv.sys; DestDir: {sys}; Flags: ignoreversion restartreplace uninsrestartdelete; MinVersion: 0,6.0.6000; Languages:

[Registry]
; NuFW
;Root: HKLM; SubKey: SOFTWARE\Microsoft\Windows NT\CurrentVersion\Winlogon; ValueType: string; ValueName: GinaDLL; ValueData: {app}\NuWINc\nugina.dll; MinVersion: 0,5.0.2195; Languages: ; Flags: uninsdeletevalue; OnlyBelowVersion: 0,5.01.2600sp9
;Root: HKLM; SubKey: SOFTWARE\INL\NuWINc; ValueType: string; ValueName: BinPath; ValueData: {app}\NuWINc\nuwinc.exe; Flags: uninsdeletevalue
;Root: HKLM; SubKey: SOFTWARE\INL\NuWINc; ValueType: dword; ValueName: Disabled; ValueData: $00000001
; client Scribe
Root: HKLM; Subkey: Software\Eole\Scribe; ValueType: string; ValueName: ip_scribe; ValueData: {#IpScribe}
Root: HKLM; Subkey: Software\Eole\Scribe; ValueType: string; ValueName: ip_access_list; ValueData: {#IpAccessList}
Root: HKLM; Subkey: Software\Eole\Scribe; ValueType: string; ValueName: inst_path; ValueData: {app}
Root: HKLM; Subkey: Software\Eole\Scribe; ValueType: string; ValueName: port_client; ValueData: {#PortClient}
Root: HKLM; Subkey: Software\Eole\Scribe; ValueType: string; ValueName: port_scribe; ValueData: {#PortScribe}
Root: HKLM; Subkey: Software\Eole\Scribe; ValueType: string; ValueName: port_scribe_update; ValueData: {#PortScribeUpdate}
Root: HKLM; Subkey: Software\Eole\Scribe; ValueType: string; ValueName: port_utilisateur; ValueData: {#PortUtilisateur}
Root: HKLM; Subkey: Software\Eole\Scribe; ValueType: string; ValueName: nom_scribe; ValueData: {#NomScribe}
Root: HKLM; Subkey: Software\Eole\Scribe; ValueType: string; ValueName: nom_domaine; ValueData: {#NomDomaine}
Root: HKLM; Subkey: Software\Eole\Scribe; ValueType: string; ValueName: debug_logon; ValueData: {#DebugLogon}
Root: HKLM; Subkey: Software\Eole\Scribe; ValueType: string; ValueName: log_level; ValueData: {#LogLevel}
; client Scribe, conf Windows
Root: HKLM; Subkey: SOFTWARE\Microsoft\Windows NT\CurrentVersion\Winlogon; ValueType: string; ValueName: Userinit; ValueData: {win}\Eole\cliscribe\logon.exe,; BeforeInstall: SaveUserinitReg; MinVersion: 0,5.0.2195
Root: HKLM; Subkey: SOFTWARE\Microsoft\Windows NT\CurrentVersion\Winlogon; ValueType: string; ValueName: AutoAdminLogon; ValueData: 0; MinVersion: 0,4.0.1381

; DLL cliscribe.dll
;Root: HKLM; SubKey: SOFTWARE\Eole\cliscribe; ValueType: string; ValueName: logon_exe; Flags: uninsclearvalue; MinVersion: 0,5.0.2195
;Root: HKLM; SubKey: SOFTWARE\Eole\cliscribe; ValueType: string; ValueName: logon_exe_user; Flags: uninsclearvalue; MinVersion: 0,5.0.2195
;Root: HKLM; SubKey: SOFTWARE\Eole\cliscribe; ValueType: string; ValueName: logoff_exe; ValueData: ; Flags: uninsclearvalue; MinVersion: 0,5.0.2195
;Root: HKLM; SubKey: SOFTWARE\Eole\cliscribe; ValueType: string; ValueName: logoff_exe_user; ValueData: ; Flags: uninsclearvalue; MinVersion: 0,5.0.2195
;Root: HKLM; SubKey: SOFTWARE\Eole\cliscribe; ValueType: string; ValueName: debug; ValueData: 0; Flags: uninsclearvalue; MinVersion: 0,5.0.2195
; WinLogon
;Root: HKLM; SubKey: SOFTWARE\Microsoft\Windows NT\CurrentVersion\Winlogon\Notify\cliscribe; ValueType: string; ValueName: Dllname; ValueData: {win}\Eole\cliscribe\cliscribe_dll.dll; Flags: uninsdeletekey; MinVersion: 0,5.0.2195
;Root: HKLM; SubKey: SOFTWARE\Microsoft\Windows NT\CurrentVersion\Winlogon\Notify\cliscribe; ValueType: string; ValueName: Logon; ValueData: ELogon; Flags: uninsdeletekey; MinVersion: 0,5.0.2195
;Root: HKLM; SubKey: SOFTWARE\Microsoft\Windows NT\CurrentVersion\Winlogon\Notify\cliscribe; ValueType: string; ValueName: Logoff; ValueData: ELogoff; Flags: uninsdeletekey; MinVersion: 0,5.0.2195

; configurations diverses du poste XP (visite guide, ne pas afficher le nom du dernier connect, etc.)
Root: HKLM; Subkey: Software\Microsoft\Windows NT\CurrentVersion\Winlogon; ValueType: dword; ValueName: DeleteRoamingCache; ValueData: $00000001; MinVersion: 0,4.0.1381
Root: HKLM; Subkey: Software\Microsoft\Windows\CurrentVersion\NetCache; ValueType: dword; ValueName: Enabled; ValueData: $00000000; MinVersion: 0,4.0.1381
Root: HKLM; Subkey: Software\Microsoft\Windows\CurrentVersion\Policies\System; ValueType: dword; ValueName: DontDisplayLastUserName; ValueData: $00000001; MinVersion: 0,4.0.1381; Flags: uninsdeletevalue
Root: HKLM; Subkey: Software\Microsoft\Windows\CurrentVersion\Policies\System; ValueType: dword; ValueName: HideFastUserSwitching; ValueData: $00000001; MinVersion: 0,6.0.6000; Flags: uninsdeletevalue
Root: HKLM; Subkey: Software\Microsoft\Windows\CurrentVersion\Applets\Tour; ValueType: dword; ValueName: RunCount; ValueData: $00000000; MinVersion: 0,4.0.1381
Root: HKLM; Subkey: Software\Microsoft\Windows\CurrentVersion\Policies\System; ValueType: dword; ValueName: DisableCAD; ValueData: $00000001; MinVersion: 0,4.0.1381
Root: HKU; Subkey: .DEFAULT\Control Panel\Keyboard; ValueType: string; ValueName: InitialKeyboardIndicators; ValueData: 2; MinVersion: 0,4.0.1381
; attendre que le rseau soit compltement dmarr
Root: HKLM; SubKey: SOFTWARE\Policies\Microsoft\Windows NT\CurrentVersion\Winlogon; ValueType: dword; ValueName: SyncForegroundPolicy; ValueData: $00000001

; ultravnc XP (paramtr avec UltraVNC, export avec regedit et import avec IStools)
Root: HKLM; Subkey: SOFTWARE\ORL\WinVNC3; Flags: uninsdeletekey; MinVersion: 0,4.0.1381
Root: HKLM; Subkey: SOFTWARE\UltraVnc\mslogon; Flags: uninsdeletekey; MinVersion: 0,4.0.1381
Root: HKLM; SubKey: SOFTWARE\ORL\WinVNC3; ValueType: dword; ValueName: MSLogonRequired; ValueData: $00000001; MinVersion: 0,4.0.1381
Root: HKLM; SubKey: SOFTWARE\ORL\WinVNC3; ValueType: dword; ValueName: NewMSLogon; ValueData: $00000000; MinVersion: 0,4.0.1381
Root: HKLM; SubKey: SOFTWARE\ORL\WinVNC3; ValueType: binary; ValueName: ACL; ValueData: 02 00 08 00 00 00 00 00; MinVersion: 0,4.0.1381
Root: HKLM; SubKey: SOFTWARE\ORL\WinVNC3; ValueType: dword; ValueName: DebugMode; ValueData: $00000000; MinVersion: 0,4.0.1381
Root: HKLM; SubKey: SOFTWARE\ORL\WinVNC3; ValueType: dword; ValueName: DebugLevel; ValueData: $00000000; MinVersion: 0,4.0.1381
Root: HKLM; SubKey: SOFTWARE\ORL\WinVNC3; ValueType: dword; ValueName: AllowLoopback; ValueData: $00000000; MinVersion: 0,4.0.1381
Root: HKLM; SubKey: SOFTWARE\ORL\WinVNC3; ValueType: dword; ValueName: LoopbackOnly; ValueData: $00000000; MinVersion: 0,4.0.1381
Root: HKLM; SubKey: SOFTWARE\ORL\WinVNC3; ValueType: dword; ValueName: DisableTrayIcon; ValueData: $00000000; MinVersion: 0,4.0.1381
Root: HKLM; SubKey: SOFTWARE\ORL\WinVNC3; ValueType: dword; ValueName: UseDSMPlugin; ValueData: $00000000; MinVersion: 0,4.0.1381
Root: HKLM; SubKey: SOFTWARE\ORL\WinVNC3; ValueType: dword; ValueName: ConnectPriority; ValueData: $00000000; MinVersion: 0,4.0.1381
Root: HKLM; SubKey: SOFTWARE\ORL\WinVNC3; ValueType: binary; ValueName: DSMPlugin; ValueData: 00 bb a8 80 40 22 a9 80 18 7c 54 80 10 7c 54 80 80 c8 1c 00 ff ff ff ff c8 cb 61 fa 1e 2a 57 80 0c f0 1e 00 38 7c 54 80 00 00 00 00 f8 b9 3f e1 10 ba 3f e1 47 fb 56 80 e0 bc a8 80 c8 cb 61 fa a2 fb 56 80 40 00 00 00 38 fd 97 80 10 ba 3f e1 fb 01 00 00 fa 01 00 00 4c bc a8 80 94 22 a9 80 f8 f9 18 01 2c 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 01 00 00 00 01 f9 18 01 d8 f5 93 80 e8 53 ae 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 49 f6 4e 80 78 5c 8a 80 85 6e 00 00 85 6e 00 00 78 5c 8a 80 78 74 bd ff fa 06 00 00 43 06 4f 80 fa 06 00 00 78 74 bd ff 00 f0 96 01 18 00 30 c0 00 00 00 00 fa 06 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 10 00 00 20 cc 61 fa bf 06 4f 80 18 00 30 c0 20 cc 61 fa 20 c5 4b 00 00 00 00 00 40 36 49 00 00 00 00 00; MinVersion: 0,4.0.1381
Root: HKLM; SubKey: SOFTWARE\ORL\WinVNC3\Default; ValueType: dword; ValueName: FileTransferEnabled; ValueData: $00000001; MinVersion: 0,4.0.1381
Root: HKLM; SubKey: SOFTWARE\ORL\WinVNC3\Default; ValueType: dword; ValueName: FTUserImpersonation; ValueData: $00000000; MinVersion: 0,4.0.1381
Root: HKLM; SubKey: SOFTWARE\ORL\WinVNC3\Default; ValueType: dword; ValueName: BlankMonitorEnabled; ValueData: $00000000; MinVersion: 0,4.0.1381
Root: HKLM; SubKey: SOFTWARE\ORL\WinVNC3\Default; ValueType: dword; ValueName: CaptureAlphaBlending; ValueData: $00000000; MinVersion: 0,4.0.1381
Root: HKLM; SubKey: SOFTWARE\ORL\WinVNC3\Default; ValueType: dword; ValueName: BlackAlphaBlending; ValueData: $00000000; MinVersion: 0,4.0.1381
Root: HKLM; SubKey: SOFTWARE\ORL\WinVNC3\Default; ValueType: dword; ValueName: DefaultScale; ValueData: $00000001; MinVersion: 0,4.0.1381
Root: HKLM; SubKey: SOFTWARE\ORL\WinVNC3\Default; ValueType: dword; ValueName: UseDSMPlugin; ValueData: $00000000; MinVersion: 0,4.0.1381
Root: HKLM; SubKey: SOFTWARE\ORL\WinVNC3\Default; ValueType: binary; ValueName: DSMPlugin; ValueData: 00 bb a8 80 40 22 a9 80 18 7c 54 80 10 7c 54 80 80 c8 1c 00 ff ff ff ff c8 cb 61 fa 1e 2a 57 80 0c f0 1e 00 38 7c 54 80 00 00 00 00 f8 b9 3f e1 10 ba 3f e1 47 fb 56 80 e0 bc a8 80 c8 cb 61 fa a2 fb 56 80 40 00 00 00 38 fd 97 80 10 ba 3f e1 fb 01 00 00 fa 01 00 00 4c bc a8 80 94 22 a9 80 f8 f9 18 01 2c 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 01 00 00 00 01 f9 18 01 d8 f5 93 80 e8 53 ae 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 49 f6 4e 80 78 5c 8a 80 85 6e 00 00 85 6e 00 00 78 5c 8a 80 78 74 bd ff fa 06 00 00 43 06 4f 80 fa 06 00 00 78 74 bd ff 00 f0 96 01 18 00 30 c0 00 00 00 00 fa 06 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 10 00 00 20 cc 61 fa bf 06 4f 80 18 00 30 c0 20 cc 61 fa 20 c5 4b 00 00 00 00 00 40 36 49 00 00 00 00 00; MinVersion: 0,4.0.1381
Root: HKLM; SubKey: SOFTWARE\ORL\WinVNC3\Default; ValueType: dword; ValueName: SocketConnect; ValueData: $00000001; MinVersion: 0,4.0.1381
Root: HKLM; SubKey: SOFTWARE\ORL\WinVNC3\Default; ValueType: dword; ValueName: HTTPConnect; ValueData: $00000001; MinVersion: 0,4.0.1381
Root: HKLM; SubKey: SOFTWARE\ORL\WinVNC3\Default; ValueType: dword; ValueName: XDMCPConnect; ValueData: $00000000; MinVersion: 0,4.0.1381
Root: HKLM; SubKey: SOFTWARE\ORL\WinVNC3\Default; ValueType: dword; ValueName: AutoPortSelect; ValueData: $00000001; MinVersion: 0,4.0.1381
Root: HKLM; SubKey: SOFTWARE\ORL\WinVNC3\Default; ValueType: dword; ValueName: InputsEnabled; ValueData: $00000001; MinVersion: 0,4.0.1381
Root: HKLM; SubKey: SOFTWARE\ORL\WinVNC3\Default; ValueType: dword; ValueName: LocalInputsDisabled; ValueData: $00000000; MinVersion: 0,4.0.1381
Root: HKLM; SubKey: SOFTWARE\ORL\WinVNC3\Default; ValueType: dword; ValueName: IdleTimeout; ValueData: $00000000; MinVersion: 0,4.0.1381
Root: HKLM; SubKey: SOFTWARE\ORL\WinVNC3\Default; ValueType: dword; ValueName: QuerySetting; ValueData: $00000002; MinVersion: 0,4.0.1381
Root: HKLM; SubKey: SOFTWARE\ORL\WinVNC3\Default; ValueType: dword; ValueName: QueryTimeout; ValueData: $0000000a; MinVersion: 0,4.0.1381
Root: HKLM; SubKey: SOFTWARE\ORL\WinVNC3\Default; ValueType: dword; ValueName: QueryAccept; ValueData: $00000000; MinVersion: 0,4.0.1381
Root: HKLM; SubKey: SOFTWARE\ORL\WinVNC3\Default; ValueType: dword; ValueName: LockSetting; ValueData: $00000000; MinVersion: 0,4.0.1381
Root: HKLM; SubKey: SOFTWARE\ORL\WinVNC3\Default; ValueType: dword; ValueName: RemoveWallpaper; ValueData: $00000000; MinVersion: 0,4.0.1381
Root: HKLM; SubKey: SOFTWARE\ORL\WinVNC3\Default; ValueType: binary; ValueName: Password; ValueData: 5a fd 3f 83 9f cd ab 86; MinVersion: 0,4.0.1381
Root: HKLM; SubKey: SOFTWARE\ORL\WinVNC3\Default; ValueType: dword; ValueName: AllowShutdown; ValueData: $00000000; MinVersion: 0,4.0.1381
Root: HKLM; SubKey: SOFTWARE\ORL\WinVNC3\Default; ValueType: dword; ValueName: AllowProperties; ValueData: $00000000; MinVersion: 0,4.0.1381
Root: HKLM; SubKey: SOFTWARE\ORL\WinVNC3\Default; ValueType: dword; ValueName: AllowEditClients; ValueData: $00000000; MinVersion: 0,4.0.1381
Root: HKLM; SubKey: SOFTWARE\UltraVnc\mslogon; ValueType: binary; ValueName: group1; ValueData: 70 72 6f 66 65 73 73 65 75 72 73 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00; MinVersion: 0,4.0.1381
Root: HKLM; SubKey: SOFTWARE\UltraVnc\mslogon; ValueType: binary; ValueName: group2; ValueData: 00 64 6d 69 6e 69 73 74 72 61 74 6f 72 73 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 08 df 0f 01 00 00 15 00 f5 16 f4 77 07 00 00 00 d8 07 15 00 00 00 15 00 80 a9 16 00 e0 de 0f 01 00 00 00 00 f8 e0 0f 01 02 24 f7 77 20 55 f6 77 ff ff; MinVersion: 0,4.0.1381
Root: HKLM; SubKey: SOFTWARE\UltraVnc\mslogon; ValueType: binary; ValueName: group3; ValueData: 00 4e 43 56 49 45 57 4f 4e 4c 59 00 44 e1 0f 01 68 e1 0f 01 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00; MinVersion: 0,4.0.1381
Root: HKLM; SubKey: SOFTWARE\UltraVnc\mslogon; ValueType: dword; ValueName: locdom1; ValueData: $00000002; MinVersion: 0,4.0.1381
Root: HKLM; SubKey: SOFTWARE\UltraVnc\mslogon; ValueType: dword; ValueName: locdom2; ValueData: $00000000; MinVersion: 0,4.0.1381
Root: HKLM; SubKey: SOFTWARE\UltraVnc\mslogon; ValueType: dword; ValueName: locdom3; ValueData: $00000000; MinVersion: 0,4.0.1381

; configuration 9x
Root: HKLM; SubKey: Network\Logon; ValueType: dword; ValueName: MustBeValidated; ValueData: $0000001; MinVersion: 4.0.950,0; Flags: uninsclearvalue
Root: HKLM; SubKey: Network\Logon; ValueType: dword; ValueName: LMLogon; ValueData: $00000001; MinVersion: 4.0.950,0
Root: HKLM; SubKey: Network\Logon; ValueType: dword; ValueName: DontShowLastUser; ValueData: $00000001; MinVersion: 4.0.950,0; Flags: uninsclearvalue
Root: HKLM; SubKey: SOFTWARE\Microsoft\Windows\CurrentVersion\Policies\Network; ValueType: dword; ValueName: DisablePwdCaching; ValueData: $00000001; MinVersion: 4.0.950,0
Root: HKLM; SubKey: System\CurrentControlSet\Services\VxD\VNETSUP; ValueType: string; ValueName: Workgroup; ValueData: {#NomDomaine}; MinVersion: 4.0.950,0
Root: HKLM; SubKey: System\CurrentControlSet\Services\MSNP32\NetworkProvider; ValueType: string; ValueName: AuthenticatingAgent; ValueData: {#NomDomaine}; MinVersion: 4.0.950,0
Root: HKLM; SubKey: System\CurrentControlSet\Services\MSNP32\NetworkProvider; ValueType: binary; ValueName: LogonDisconnected; ValueData: 01 00 00 00; MinVersion: 4.0.950,0
; ultravnc 9x (import avec IStools http://www.istool.org/)
Root: HKLM; SubKey: Software\UltraVnc\mslogon; MinVersion: 4.0.950,0; Flags: uninsdeletekey
Root: HKLM; SubKey: Software\ORL\WinVNC3; MinVersion: 4.0.950,0; Flags: uninsdeletekey
Root: HKLM; SubKey: Software\Microsoft\Windows\CurrentVersion\RunServices; ValueType: string; ValueName: WinVNC; ValueData: """{app}\ultravnc\WINVNC.EXE"" -service"; MinVersion: 4.0.950,0; Flags: uninsclearvalue
Root: HKLM; SubKey: Software\ORL\WinVNC3; ValueType: dword; ValueName: DebugMode; ValueData: $00000000; MinVersion: 4.0.950,0
Root: HKLM; SubKey: Software\ORL\WinVNC3; ValueType: dword; ValueName: DebugLevel; ValueData: $00000000; MinVersion: 4.0.950,0
Root: HKLM; SubKey: Software\ORL\WinVNC3; ValueType: dword; ValueName: AllowLoopback; ValueData: $00000000; MinVersion: 4.0.950,0
Root: HKLM; SubKey: Software\ORL\WinVNC3; ValueType: dword; ValueName: LoopbackOnly; ValueData: $00000000; MinVersion: 4.0.950,0
Root: HKLM; SubKey: Software\ORL\WinVNC3; ValueType: dword; ValueName: DisableTrayIcon; ValueData: $00000000; MinVersion: 4.0.950,0
Root: HKLM; SubKey: Software\ORL\WinVNC3; ValueType: dword; ValueName: MSLogonRequired; ValueData: $00000001; MinVersion: 4.0.950,0
Root: HKLM; SubKey: Software\ORL\WinVNC3; ValueType: dword; ValueName: NewMSLogon; ValueData: $00000000; MinVersion: 4.0.950,0
Root: HKLM; SubKey: Software\ORL\WinVNC3; ValueType: dword; ValueName: UseDSMPlugin; ValueData: $00000000; MinVersion: 4.0.950,0
Root: HKLM; SubKey: Software\ORL\WinVNC3; ValueType: dword; ValueName: ConnectPriority; ValueData: $00000000; MinVersion: 4.0.950,0
Root: HKLM; SubKey: Software\ORL\WinVNC3; ValueType: binary; ValueName: DSMPlugin; ValueData: 00 63 6b 33 32 2e 64 6c 6c 2c 20 76 65 72 32 2e 32 2c 20 33 32 62 69 74 20 6f 66 20 41 70 72 20 32 32 20 31 39 39 39 2c 20 61 74 20 32 30 3a 32 39 3a 33 32 2e 00 00 00 b8 46 4c 00 90 06 00 80 e0 09 00 00 00 00 00 00 00 00 00 00 00 00 40 00 00 00 40 00 65 e2 f7 bf 00 00 40 00 d2 e1 f7 bf 00 00 40 00 d8 f7 73 00 00 00 40 00 00 00 40 00 ac fd 73 00 37 05 f8 bf 00 00 40 00 01 00 40 00 10 11 a7 00 00 00 00 00 00 00 00 00 00 00 00 00 00 fd 73 00 b8 cb 03 00 00 00 40 00 74 f7 73 00 a8 f7 73 00 00 00 00 00 28 f8 73 00 b4 05 fc bf 00 95 f7 bf ff ff ff ff f0 f7 73 00 bb 0b f8 bf 00 00 40 00 e0 49 4c 00 18 f8 73 00 00 00 00 00 01 00 00 00 00 00 00 00 00 00 00 00 e0 49 4c 00 18 f8 73 00 00 00 00 00 00 00 00 00 3e 00 00 00 20 c5 4b 00 00 00 00 00 40 36 49 00 35 2e 00 00; MinVersion: 4.0.950,0
Root: HKLM; SubKey: Software\ORL\WinVNC3\Default; ValueType: dword; ValueName: FileTransferEnabled; ValueData: $00000001; MinVersion: 4.0.950,0
Root: HKLM; SubKey: Software\ORL\WinVNC3\Default; ValueType: dword; ValueName: FTUserImpersonation; ValueData: $00000001; MinVersion: 4.0.950,0
Root: HKLM; SubKey: Software\ORL\WinVNC3\Default; ValueType: dword; ValueName: BlankMonitorEnabled; ValueData: $00000001; MinVersion: 4.0.950,0
Root: HKLM; SubKey: Software\ORL\WinVNC3\Default; ValueType: dword; ValueName: CaptureAlphaBlending; ValueData: $00000000; MinVersion: 4.0.950,0
Root: HKLM; SubKey: Software\ORL\WinVNC3\Default; ValueType: dword; ValueName: BlackAlphaBlending; ValueData: $00000000; MinVersion: 4.0.950,0
Root: HKLM; SubKey: Software\ORL\WinVNC3\Default; ValueType: dword; ValueName: DefaultScale; ValueData: $00000001; MinVersion: 4.0.950,0
Root: HKLM; SubKey: Software\ORL\WinVNC3\Default; ValueType: dword; ValueName: UseDSMPlugin; ValueData: $00000000; MinVersion: 4.0.950,0
Root: HKLM; SubKey: Software\ORL\WinVNC3\Default; ValueType: binary; ValueName: DSMPlugin; ValueData: 00 63 6b 33 32 2e 64 6c 6c 2c 20 76 65 72 32 2e 32 2c 20 33 32 62 69 74 20 6f 66 20 41 70 72 20 32 32 20 31 39 39 39 2c 20 61 74 20 32 30 3a 32 39 3a 33 32 2e 00 00 00 b8 46 4c 00 90 06 00 80 e0 09 00 00 00 00 00 00 00 00 00 00 00 00 40 00 00 00 40 00 65 e2 f7 bf 00 00 40 00 d2 e1 f7 bf 00 00 40 00 d8 f7 73 00 00 00 40 00 00 00 40 00 ac fd 73 00 37 05 f8 bf 00 00 40 00 01 00 40 00 10 11 a7 00 00 00 00 00 00 00 00 00 00 00 00 00 00 fd 73 00 b8 cb 03 00 00 00 40 00 74 f7 73 00 a8 f7 73 00 00 00 00 00 28 f8 73 00 b4 05 fc bf 00 95 f7 bf ff ff ff ff f0 f7 73 00 bb 0b f8 bf 00 00 40 00 e0 49 4c 00 18 f8 73 00 00 00 00 00 01 00 00 00 00 00 00 00 00 00 00 00 e0 49 4c 00 18 f8 73 00 00 00 00 00 00 00 00 00 3e 00 00 00 20 c5 4b 00 00 00 00 00 40 36 49 00 35 2e 00 00; MinVersion: 4.0.950,0
Root: HKLM; SubKey: Software\ORL\WinVNC3\Default; ValueType: dword; ValueName: SocketConnect; ValueData: $00000001; MinVersion: 4.0.950,0
Root: HKLM; SubKey: Software\ORL\WinVNC3\Default; ValueType: dword; ValueName: HTTPConnect; ValueData: $00000001; MinVersion: 4.0.950,0
Root: HKLM; SubKey: Software\ORL\WinVNC3\Default; ValueType: dword; ValueName: XDMCPConnect; ValueData: $00000000; MinVersion: 4.0.950,0
Root: HKLM; SubKey: Software\ORL\WinVNC3\Default; ValueType: dword; ValueName: AutoPortSelect; ValueData: $00000001; MinVersion: 4.0.950,0
Root: HKLM; SubKey: Software\ORL\WinVNC3\Default; ValueType: dword; ValueName: InputsEnabled; ValueData: $00000001; MinVersion: 4.0.950,0
Root: HKLM; SubKey: Software\ORL\WinVNC3\Default; ValueType: dword; ValueName: LocalInputsDisabled; ValueData: $00000000; MinVersion: 4.0.950,0
Root: HKLM; SubKey: Software\ORL\WinVNC3\Default; ValueType: dword; ValueName: IdleTimeout; ValueData: $00000000; MinVersion: 4.0.950,0
Root: HKLM; SubKey: Software\ORL\WinVNC3\Default; ValueType: dword; ValueName: QuerySetting; ValueData: $00000002; MinVersion: 4.0.950,0
Root: HKLM; SubKey: Software\ORL\WinVNC3\Default; ValueType: dword; ValueName: QueryTimeout; ValueData: $0000000a; MinVersion: 4.0.950,0
Root: HKLM; SubKey: Software\ORL\WinVNC3\Default; ValueType: dword; ValueName: QueryAccept; ValueData: $00000000; MinVersion: 4.0.950,0
Root: HKLM; SubKey: Software\ORL\WinVNC3\Default; ValueType: dword; ValueName: LockSetting; ValueData: $00000000; MinVersion: 4.0.950,0
Root: HKLM; SubKey: Software\ORL\WinVNC3\Default; ValueType: dword; ValueName: RemoveWallpaper; ValueData: $00000000; MinVersion: 4.0.950,0
Root: HKLM; SubKey: Software\ORL\WinVNC3\Default; ValueType: binary; ValueName: Password; ValueData: 5a fd 3f 83 9f cd ab 86; MinVersion: 4.0.950,0
Root: HKLM; SubKey: Software\ORL\WinVNC3\Default; ValueType: dword; ValueName: AllowShutdown; ValueData: $00000001; MinVersion: 4.0.950,0
Root: HKLM; SubKey: Software\ORL\WinVNC3\Default; ValueType: dword; ValueName: AllowProperties; ValueData: $00000000; MinVersion: 4.0.950,0
Root: HKLM; SubKey: Software\ORL\WinVNC3\Default; ValueType: dword; ValueName: AllowEditClients; ValueData: $00000000; MinVersion: 4.0.950,0
Root: HKLM; SubKey: Software\UltraVnc\mslogon; ValueType: binary; ValueName: group1; ValueData: 50 52 4f 46 45 53 53 45 55 52 53 00 ff ff ff ff f0 f7 73 00 bb 0b f8 bf 00 00 40 00 e0 49 4c 00 18 f8 73 00 00 00 00 00 01 00 00 00 00 00 00 00 00 00 00 00 e0 49 4c 00 18 f8 73 00 00 00 00 00 00 00 00 00 3e 00 00 00 20 c5 4b 00 00 00 00 00 40 36 49 00 35 2e 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00; MinVersion: 4.0.950,0
Root: HKLM; SubKey: Software\UltraVnc\mslogon; ValueType: binary; ValueName: group2; ValueData: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00; MinVersion: 4.0.950,0
Root: HKLM; SubKey: Software\UltraVnc\mslogon; ValueType: binary; ValueName: group3; ValueData: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00; MinVersion: 4.0.950,0
Root: HKLM; SubKey: Software\UltraVnc\mslogon; ValueType: dword; ValueName: locdom1; ValueData: $00000002; MinVersion: 4.0.950,0
Root: HKLM; SubKey: Software\UltraVnc\mslogon; ValueType: dword; ValueName: locdom2; ValueData: $00000000; MinVersion: 4.0.950,0
Root: HKLM; SubKey: Software\UltraVnc\mslogon; ValueType: dword; ValueName: locdom3; ValueData: $00000000; MinVersion: 4.0.950,0
Root: HKLM; SubKey: System\CurrentControlSet\Services\VxD\FILESEC; ValueType: string; ValueName: StaticVxD; ValueData: filesec.vxd; MinVersion: 4.0.950,0
Root: HKLM; SubKey: System\CurrentControlSet\Services\VxD\FILESEC; ValueType: binary; ValueName: Start; ValueData: 00; MinVersion: 4.0.950,0
Root: HKLM; SubKey: System\CurrentControlSet\Services\VxD\FILESEC; ValueType: binary; ValueName: NetClean; ValueData: 01; MinVersion: 4.0.950,0
Root: HKLM; SubKey: System\CurrentControlSet\Services\VxD\MSSP; ValueType: string; ValueName: StaticVxD; ValueData: mssp.vxd; MinVersion: 4.0.950,0
Root: HKLM; SubKey: System\CurrentControlSet\Services\VxD\MSSP; ValueType: binary; ValueName: Start; ValueData: 00; MinVersion: 4.0.950,0
Root: HKLM; SubKey: System\CurrentControlSet\Services\VxD\MSSP; ValueType: binary; ValueName: NetClean; ValueData: 01; MinVersion: 4.0.950,0
Root: HKLM; SubKey: Security\Provider; ValueType: binary; ValueName: Platform_Type; ValueData: 02 00 00 00; MinVersion: 4.0.950,0
Root: HKLM; SubKey: Security\Provider; ValueType: string; ValueName: Address_Book; ValueData: msab32.dll; MinVersion: 4.0.950,0
Root: HKLM; SubKey: Security\Provider; ValueType: string; ValueName: Container; ValueData: {#NomDomaine}; MinVersion: 4.0.950,0
Root: HKLM; SubKey: Security\Provider; ValueType: string; ValueName: Address_Server; ValueData: {#NomScribe}; MinVersion: 4.0.950,0

[Run]
; Paramtrage parefeu Vista (fait  chaque dmarrage du service Scribe)
 Filename: {sys}\netsh.exe; Parameters: firewall set opmode mode=enable profile=ALL; Flags: runhidden; MinVersion: 0,6.0.6000; OnlyBelowVersion: 0,0
Filename: {sys}\netsh.exe; Parameters: advfirewall firewall delete rule name=EoleUtilisateur; Flags: runhidden; MinVersion: 0,6.0.6000; OnlyBelowVersion: 0,0
Filename: {sys}\netsh.exe; Parameters: advfirewall firewall delete rule name=EoleService; Flags: runhidden; MinVersion: 0,6.0.6000; OnlyBelowVersion: 0,0
Filename: {sys}\netsh.exe; Parameters: advfirewall firewall delete rule name=EoleVNC; Flags: runhidden; MinVersion: 0,6.0.6000; OnlyBelowVersion: 0,0
Filename: {sys}\netsh.exe; Parameters: firewall set service type=FILEANDPRINT mode=ENABLE scope=ALL profile=ALL; Flags: runhidden; MinVersion: 0,6.0.6000; OnlyBelowVersion: 0,0
Filename: {sys}\netsh.exe; Parameters: advfirewall firewall add rule dir=in action=allow name=EoleUtilisateur program={app}\cliscribe\utilisateur.exe; Flags: runhidden; MinVersion: 0,6.0.6000; OnlyBelowVersion: 0,0
Filename: {sys}\netsh.exe; Parameters: advfirewall firewall add rule dir=out action=allow name=EoleUtilisateur program={app}\cliscribe\utilisateur.exe; Flags: runhidden; MinVersion: 0,6.0.6000; OnlyBelowVersion: 0,0
Filename: {sys}\netsh.exe; Parameters: advfirewall firewall add rule dir=in action=allow name=EoleService program={app}\cliscribe\servscribe.exe remoteip={#IpScribe}; Flags: runhidden; MinVersion: 0,6.0.6000; OnlyBelowVersion: 0,0
Filename: {sys}\netsh.exe; Parameters: advfirewall firewall add rule dir=out action=allow name=EoleService program={app}\cliscribe\servscribe.exe; Flags: runhidden; MinVersion: 0,6.0.6000; OnlyBelowVersion: 0,0
;
Filename: {sys}\netsh.exe; Parameters: advfirewall firewall add rule dir=in action=allow name=EoleVNC program={app}\ultravnc\vncviewer.exe; Flags: runhidden; MinVersion: 0,6.0.6000; OnlyBelowVersion: 0,0
Filename: {sys}\netsh.exe; Parameters: advfirewall firewall add rule dir=out action=allow name=EoleVNC program={app}\ultravnc\vncviewer.exe; Flags: runhidden; MinVersion: 0,6.0.6000; OnlyBelowVersion: 0,0
Filename: {sys}\netsh.exe; Parameters: advfirewall firewall add rule dir=in action=allow name=EoleVNC program={app}\ultravnc\winvnc.exe; Flags: runhidden; MinVersion: 0,6.0.6000; OnlyBelowVersion: 0,0
Filename: {sys}\netsh.exe; Parameters: advfirewall firewall add rule dir=out action=allow name=EoleVNC program={app}\ultravnc\winvnc.exe; Flags: runhidden; MinVersion: 0,6.0.6000; OnlyBelowVersion: 0,0
Filename: {sys}\netsh.exe; Parameters: advfirewall firewall add rule dir=in action=allow name=EoleVNC program=P:\gestion-postes\vncviewer.exe; Flags: runhidden; MinVersion: 0,6.0.6000; OnlyBelowVersion: 0,0
Filename: {sys}\netsh.exe; Parameters: advfirewall firewall add rule dir=out action=allow name=EoleVNC program=P:\gestion-postes\vncviewer.exe; Flags: runhidden; MinVersion: 0,6.0.6000; OnlyBelowVersion: 0,0
Filename: {sys}\netsh.exe; Parameters: advfirewall firewall add rule dir=in action=allow name=EoleVNC program=P:\gestion-postes\winvnc.exe; Flags: runhidden; MinVersion: 0,6.0.6000; OnlyBelowVersion: 0,0
Filename: {sys}\netsh.exe; Parameters: advfirewall firewall add rule dir=out action=allow name=EoleVNC program=P:\gestion-postes\winvnc.exe; Flags: runhidden; MinVersion: 0,6.0.6000; OnlyBelowVersion: 0,0

; Pour NT, 2000, XP, Vista
; Installation du service
Filename: {app}\cliscribe\servscribe.exe; Parameters: -install -auto -interactive; Flags: runhidden; MinVersion: 0,4.0.1381
; Pour 2000 et XP (IpFw)
Filename: {win}\system32\ipfw.exe; Parameters: install_drv {win}\System32\DRIVERS\ip_fw.sys; Flags: runhidden; MinVersion: 0,5.0.2195; OnlyBelowVersion: 0,6.0.6000
Filename: {sys}\net.exe; Parameters: start ip_fw; Flags: runhidden; MinVersion: 0,5.0.2195; OnlyBelowVersion: 0,6.0.6000
Filename: {win}\system32\ipfw.exe; Parameters: install {app}\wipfw\config.cmd; Flags: runhidden; MinVersion: 0,5.0.2195; OnlyBelowVersion: 0,6.0.6000
Filename: {sys}\net.exe; Parameters: start ipfw; Flags: runhidden; MinVersion: 0,5.0.2195; OnlyBelowVersion: 0,6.0.6000
; Pour 2000, XP et Vista (activer le service messenger pour les popups ( ne pas confondre avec msn messenger))
Filename: {sys}\sc.exe; Parameters: config messenger start= auto; Flags: runhidden; MinVersion: 0,5.0.2195
; ; Vista (NuFw)
; Filename: {sys}\rundll32.exe; Parameters: setupapi.dll,InstallHinfSection DefaultInstall 128 nuwinc-drv.inf; Flags: runhidden; MinVersion: 0,6.0.6000
; Filename: {app}\NuWINc\gina_reg.exe; Parameters: install; Flags: runhidden
; Installation (pas pour Win9x) du service de MAJ, pas lanc si mode /SILENT
Filename: {src}\clieole-updater-setup.exe; Parameters: /SILENT /NORESTART; WorkingDir: {src}; Flags: skipifsilent hidewizard skipifdoesntexist; MinVersion: 0,4.0.1381
; paramtrage du client Scribe (ajout dans lmhost, groupe de service, etc.)
Filename: {app}\cliscribe\confservscribe.exe; Parameters: --install; Flags: runhidden; MinVersion: 0,4.0.1381
Filename: {sys}\net.exe; Parameters: start servscribe; Flags: runhidden; MinVersion: 0,4.0.1381

[UninstallRun]
; 9x
Filename: {app}\ultravnc\winvnc.exe; Parameters: -kill; Flags: runhidden; MinVersion: 4.0.950,0
; NT, 2000 et XP
Filename: {sys}\net.exe; Parameters: stop /y ip_fw; Flags: runhidden; MinVersion: 0,5.0.2195; OnlyBelowVersion: 0,6.0.6000
Filename: {win}\system32\ipfw.exe; Parameters: remove_drv; Flags: runhidden; MinVersion: 0,5.0.2195; OnlyBelowVersion: 0,6.0.6000
Filename: {win}\system32\ipfw.exe; Parameters: remove; Flags: runhidden; MinVersion: 0,5.0.2195; OnlyBelowVersion: 0,6.0.6000
; NT, 2000, XP et Vista
Filename: {sys}\net.exe; Parameters: stop servscribe; Flags: runhidden; MinVersion: 0,4.0.1381
Filename: {sys}\sc.exe; Parameters: delete servscribe; Flags: runhidden; MinVersion: 0,4.0.1381
; ; Vista
; ; Dsinstallation de NuFw (voir C:\WINDOWS\Eole_inst\NuWINc_inst\VISTA\install_drv.bat
; Filename: {sys}\rundll32.exe; Parameters: setupapi.dll,InstallHinfSection DefaultUninstall 128 nuwinc-drv.inf; Flags: runhidden; MinVersion: 0,6.0.6000
; Filename: {app}\NuWINc\nuwinc-netstat.exe; Parameters: uninstall; Flags: runhidden; MinVersion: 0,6.0.6000
; Suppression des rgles Eole*
Filename: {sys}\netsh.exe; Parameters: advfirewall firewall delete rule name=EoleUtilisateur; Flags: runhidden; MinVersion: 0,6.0.6000; OnlyBelowVersion: 0,0
Filename: {sys}\netsh.exe; Parameters: advfirewall firewall delete rule name=EoleService; Flags: runhidden; MinVersion: 0,6.0.6000; OnlyBelowVersion: 0,0
Filename: {sys}\netsh.exe; Parameters: advfirewall firewall delete rule name=EoleVNC; Flags: runhidden; MinVersion: 0,6.0.6000; OnlyBelowVersion: 0,0
Filename: {app}\cliscribe\confservscribe.exe; Parameters: --remove; Flags: runhidden; MinVersion: 0,4.0.1381
Filename: {sys}\taskkill.exe; Parameters: /F /IM utilisateur.exe; Flags: runhidden; MinVersion: 0,4.0.1381
Filename: {sys}\taskkill.exe; Parameters: /F /IM logon.exe; Flags: runhidden; MinVersion: 0,4.0.1381

[UninstallDelete]
Name: {app}\wipfw\wipfw.conf; Type: files; MinVersion: 0,4.0.1381; OnlyBelowVersion: 0,6.0.6000

[Tasks]

[Code]
// Sauvegarde de la cl "userinit", lanc  l'installation
procedure SaveUserinitReg();
var
  UserinitKeyPath, UserinitKeyName, UserinitKeyValue: String;
  UserinitSaveKeyPath, UserinitSaveKeyName: String;
begin
  UserinitKeyPath := 'SOFTWARE\Microsoft\Windows NT\CurrentVersion\Winlogon';
  UserinitKeyName := 'Userinit';
  UserinitSaveKeyPath := 'SOFTWARE\Eole\Scribe';
  UserinitSaveKeyName := 'SaveUserinit';
  if RegValueExists(HKLM, UserinitSaveKeyPath, UserinitSaveKeyName) then
    Exit;
  RegQueryStringValue(HKLM, UserinitKeyPath, UserinitKeyName, UserinitKeyValue);
  RegWriteStringValue(HKLM, UserinitSaveKeyPath, UserinitSaveKeyName, UserinitKeyValue);
end;

//Sauvegarde du menu dmarrer original dans la session "admin" pour les retrouver  la dsinstallation du client Scribe
procedure RestoreMenu();
var
  Kpath: String;
begin
  Kpath:='Software\Microsoft\Windows\CurrentVersion\Explorer\Shell Folders';
  RegWriteStringValue(HKCU, Kpath, 'Desktop', ExpandConstant('{%USERPROFILE|''}\\Bureau'));
  RegWriteStringValue(HKCU, Kpath, 'Start Menu', ExpandConstant('{%USERPROFILE|''}\Menu Dmarrer'));
  RegWriteStringValue(HKCU, Kpath, 'Programs', ExpandConstant('{%USERPROFILE|''}\Menu Dmarrer\Programmes'));
  RegWriteStringValue(HKCU, Kpath, 'Startup', ExpandConstant('{%USERPROFILE|''}\Menu Dmarrer\Programmes\Dmarrage'));

  Kpath:='Software\Microsoft\Windows\CurrentVersion\Explorer\User Shell Folders';
  RegWriteExpandStringValue(HKCU, Kpath, 'Start Menu', '%USERPROFILE%\Menu Dmarrer');
  RegWriteExpandStringValue(HKCU, Kpath, 'Programs', '%USERPROFILE%\Menu Dmarrer\Programmes');
  RegWriteExpandStringValue(HKCU, Kpath, 'Startup', '%USERPROFILE%\Menu Dmarrer\Programmes\Dmarrage');
  RegWriteExpandStringValue(HKCU, Kpath, 'Desktop', '%USERPROFILE%\Bureau');
end;

// Copie "sc.exe" pour les windows 2000
// si prsent dans le dossier de l'installeur {src}
function CopySc: Boolean;
var
  sc: String;
  scd: String;
begin
  sc:=ExpandConstant('{src}\sc.exe');
  scd:=ExpandConstant('{sys}\sc.exe');
  Result:= True;
  if not (GetWindowsVersionString() = '5.00.2195') then begin
    Exit;
  end;
  if not (FileExists(scd)) then begin
    if not (FileExists(sc)) then begin
      MsgBox('Le fichier "'+scd+'" est introuvable.'+#13#10#13#10+'Veuillez installer "Windows 2000 Resource Kit"'+#13#10+'ou le copier depuis Windows XP dans le dossier de "clieole-setup.exe".'+#13#10#13#10+'Abandon !', mbError, MB_OK)
      Result:=False;
      Exit;
    end;
	FileCopy(sc, scd, True)
    MsgBox('Le fichier "sc.exe" a t copi.', mbInformation, MB_OK);
  end;
end;

function IsSilent: Boolean;
var
  i : Integer;
begin
  Result := False;
  for i := 0 to ParamCount do
    //MsgBox('Parameter '+IntToStr(i)+' = '+ParamStr(i), mbInformation, MB_OK);
    if uppercase(ParamStr(i))='/SILENT' then
      Result:=True;
    if uppercase(ParamStr(i))='/VERYSILENT' then
      Result:=True;
    if uppercase(ParamStr(i))='/SUPPRESSMSGBOXES' then
      Result:=True;
end;

// arrte dsinstalle les services
function RemoveService: Boolean;
var
  ResultCode: Integer;
  oldservscribe: String;
begin
  Result:=True;
  oldservscribe:=ExpandConstant('{win}\eole\servscribe.exe');
  if (FileExists(oldservscribe)) then begin
//  Exec(FileName, '', '', SW_SHOWNORMAL, ewNoWait, ResultCode)
    Exec(ExpandConstant('{sys}\net.exe'), 'stop servscribe', '', SW_HIDE, ewWaitUntilTerminated, ResultCode)
    Exec(ExpandConstant('{sys}\sc.exe'), 'delete servscribe', '', SW_HIDE, ewWaitUntilTerminated, ResultCode)
    if not DeleteFile(oldservscribe) then begin
      MsgBox('Le client Scribe-1.0 n''a pas pu tre dsinstall.'+#13#10+'Abandon !', mbError, MB_OK)
      Result:=False;
    end else begin
      if IsSilent=False then
        MsgBox('Le client Scribe-1.0 a t dsinstall.', mbInformation, MB_OK);
    end;
  end;
end;

// InitializeSetup est une fonction interne appele par InnoSetup au dmarrage de l'installeur
// Test si
//* le client Scribe-1.0 est install et le dsinstalle si oui, quitte si la dsinstallation choue
//* %WINDIR%\system32\sc.exe existe, peut le copier depuis le dossier de l'installeur
// quitte si non prsent et non copiable depuis le dossier de l'installeur
function InitializeSetup(): Boolean;
//var
begin
  Result:=True;
  if RemoveService=False then
    Result:= False;
  if CopySc=False then
    Result:= False;
end;

// CurUninstallStepChanged est une fonction internet InnoSetup appele  chaque tape de la ds-installation
// l'tape usPostUninstall correspond  la dernire tape :
// * l'installeur remet la valeur d'origine dans la cl Userinit
// * et efface la cl de sauvegarde
procedure CurUninstallStepChanged(CurUninstallStep: TUninstallStep);
var
  UserinitKeyPath, UserinitKeyName, UserinitKeyValue: String;
  UserinitSaveKeyPath, UserinitSaveKeyName: String;
begin
  if CurUninstallStep <> usPostUninstall then
	Exit;
  RestoreMenu();
  UserinitKeyPath := 'SOFTWARE\Microsoft\Windows NT\CurrentVersion\Winlogon';
  UserinitKeyName := 'Userinit';
  UserinitSaveKeyPath := 'SOFTWARE\Eole\Scribe';
  UserinitSaveKeyName := 'SaveUserinit';
  if RegValueExists(HKLM, UserinitSaveKeyPath, UserinitSaveKeyName) then begin
    RegQueryStringValue(HKLM, UserinitSaveKeyPath, UserinitSaveKeyName, UserinitKeyValue);
    RegWriteStringValue(HKLM, UserinitKeyPath, UserinitKeyName, UserinitKeyValue);
    RegDeleteValue(HKLM, UserinitSaveKeyPath, UserinitSaveKeyName);
  end else begin
    UserinitKeyValue := ExpandConstant('{sys}\userinit.exe,')
    RegWriteStringValue(HKLM, UserinitKeyPath, UserinitKeyName, UserinitKeyValue);
  end;
end;


// Configuration Wipfw (2000 et XP), appel  l'install de wipfw\config.cmd
procedure ConfigWipfw();
var
 fichier : String;
  s : String;
begin
  fichier:=ExpandConstant('{app}\wipfw\wipfw.conf');

  s:='# First flush the firewall rules'+#13#10;
  s:=s+'-f flush'+#13#10+#13#10;
  s:=s+'add 001 allow all from any to any via lo*'+#13#10;
  s:=s+'# check-state + keep-state = related, established en iptables'+#13#10;
  s:=s+'add 002 check-state'+#13#10;

  s:=s+'add 65533 allow udp from me to any keep-state'+#13#10;
  s:=s+'add 65534 allow ip from any to any'+#13#10;

  if ( FileExists( fichier ) ) then
    DeleteFile( fichier ) ;
  SaveStringToFile(fichier, s, False);
end;
