# -*- coding: cp1252 -*-
#Liste des processus Windows

from ctypes import windll, Structure, c_ulong, c_char, sizeof, byref
import os
#from win32api import GetSystemMetrics
#from time import sleep
#import copy, os, sys

#dclaration fonctions
CreateToolhelp32Snapshot = windll.kernel32.CreateToolhelp32Snapshot
Process32First = windll.kernel32.Process32First
Process32Next = windll.kernel32.Process32Next
GetCurrentProcessId = windll.kernel32.GetCurrentProcessId
OpenProcess = windll.kernel32.OpenProcess
TerminateProcess = windll.kernel32.TerminateProcess

class PROCESSENTRY32(Structure):
    _fields_ = [("dwSize", c_ulong),
            ("cntUsage", c_ulong),
            ("th32ProcessID", c_ulong),
            ("th32DefaultHeapID", c_ulong),
            ("th32ModuleID", c_ulong),
            ("cntThreads", c_ulong),
            ("th32ParentProcessID", c_ulong),
            ("pcPriClassBase", c_ulong),
            ("dwFlags", c_ulong),
            ("szexeFile", c_char * 260)]

def GetProcessList():
    liste = []
    uProcess = PROCESSENTRY32()
    uProcess.dwSize = sizeof(PROCESSENTRY32)
    mSnapshot = CreateToolhelp32Snapshot(2,0)
    mresult = Process32First(mSnapshot, byref(uProcess))
    while mresult:
        #name = ''.join([c for c in uProcess.szexeFile if c != '\0'])
        liste.append((uProcess.szexeFile,uProcess.th32ProcessID, uProcess.cntThreads))
        mresult = Process32Next(mSnapshot, byref(uProcess))
    return liste

def Terminate(pid):
    hProcess = OpenProcess(1, False, int(pid))
    return TerminateProcess(hProcess, 0) != 0

def killProcName(procname, own=True):
    """Tue le programme procname
    own = False => ne se tue pas soit mme
    """
    for i in range(10):
        for pid in get_pids(procname, own):
            if not pid: continue
            Terminate(pid)

def isrunning(procname):
    for proc, pid, thrd in GetProcessList():
        if procname.lower() == proc.lower():
            return True
    return False

def get_pids(procname, own=True):
    own_pid = os.getpid()
    pid_list = []
    for proc, pid, thrd in GetProcessList():
        if not own and pid == own_pid: continue
        if procname.lower() == proc.lower(): pid_list.append(pid)
    return pid_list
