# _*_ coding: iso-8859-1 _*_
# From http://code.activestate.com/recipes/578035-disable-file-system-redirector/

import platform, _winreg, win32process

KEY_WOW64_64KEY = 0

if platform.architecture()[0] == '64bit' or win32process.IsWow64Process():
    KEY_WOW64_64KEY = _winreg.KEY_WOW64_64KEY
    import ctypes
    class disable_file_system_redirection:
        _disable = ctypes.windll.kernel32.Wow64DisableWow64FsRedirection
        _revert = ctypes.windll.kernel32.Wow64RevertWow64FsRedirection
        def __enter__(self):
            self.old_value = ctypes.c_long()
            self.success = self._disable(ctypes.byref(self.old_value))
        def __exit__(self, type, value, traceback):
            if self.success:
                self._revert(self.old_value)
else:
    class disable_file_system_redirection:
        def __enter__(self):
            pass
        def __exit__(self, type, value, traceback):
            pass


# #Example usage
# import os

# path = 'C:\\Windows\\System32\\nbtstat.exe'

# print os.path.exists(path)
# with disable_file_system_redirection():
    # print os.path.exists(path)
# print os.path.exists(path)
